/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.slider;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import dev.isxander.yacl3.gui.controllers.slider.ISliderController;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.Validate;

public class LongSliderController
implements ISliderController<Long> {
    public static final Function<Long, Component> DEFAULT_FORMATTER = value -> Component.literal((String)String.format("%,d", value).replaceAll("[\u00a0\u202f]", " "));
    private final Option<Long> option;
    private final long min;
    private final long max;
    private final long interval;
    private final ValueFormatter<Long> valueFormatter;

    public LongSliderController(Option<Long> option, long min, long max, long interval) {
        this(option, min, max, interval, DEFAULT_FORMATTER);
    }

    public LongSliderController(Option<Long> option, long min, long max, long interval, Function<Long, Component> valueFormatter) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"`max` cannot be smaller than `min`", (Object[])new Object[0]);
        Validate.isTrue((interval > 0L ? 1 : 0) != 0, (String)"`interval` must be more than 0", (Object[])new Object[0]);
        Validate.notNull(valueFormatter, (String)"`valueFormatter` must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.valueFormatter = valueFormatter::apply;
    }

    public static LongSliderController createInternal(Option<Long> option, long min, long max, long interval, ValueFormatter<Long> formatter) {
        return new LongSliderController(option, min, max, interval, formatter::format);
    }

    @Override
    public Option<Long> option() {
        return this.option;
    }

    @Override
    public Component formatValue() {
        return this.valueFormatter.format(this.option().pendingValue());
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }

    @Override
    public double interval() {
        return this.interval;
    }

    @Override
    public void setPendingValue(double value) {
        this.option().requestSet((long)value);
    }

    @Override
    public double pendingValue() {
        return this.option().pendingValue().longValue();
    }
}

