/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.net.Packet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class JoinedGroupPacket
implements Packet<JoinedGroupPacket> {
    public static final CustomPacketPayload.Type<JoinedGroupPacket> JOINED_GROUP = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"joined_group"));
    @Nullable
    private UUID group;
    private boolean wrongPassword;

    public JoinedGroupPacket() {
    }

    public JoinedGroupPacket(@Nullable UUID group, boolean wrongPassword) {
        this.group = group;
        this.wrongPassword = wrongPassword;
    }

    @Nullable
    public UUID getGroup() {
        return this.group;
    }

    public boolean isWrongPassword() {
        return this.wrongPassword;
    }

    @Override
    public JoinedGroupPacket fromBytes(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.group = buf.readUUID();
        }
        this.wrongPassword = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.group != null);
        if (this.group != null) {
            buf.writeUUID(this.group);
        }
        buf.writeBoolean(this.wrongPassword);
    }

    @Override
    public CustomPacketPayload.Type<JoinedGroupPacket> type() {
        return JOINED_GROUP;
    }
}

