/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import net.minecraft.network.chat.Component;

public class MicAmplificationSlider
extends DebouncedSlider {
    public MicAmplificationSlider(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn, (Component)Component.empty(), MicAmplificationSlider.gainToValue(VoicechatClient.CLIENT_CONFIG.microphoneGain.get()));
        this.updateMessage();
    }

    protected void updateMessage() {
        long gain = Math.round(MicAmplificationSlider.valueToGain(this.value));
        this.setMessage((Component)Component.translatable((String)"message.voicechat.microphone_gain", (Object[])new Object[]{gain}));
    }

    @Override
    public void applyDebounced() {
        VoicechatClient.CLIENT_CONFIG.microphoneGain.set(MicAmplificationSlider.valueToGain(this.value)).save();
    }

    private static double gainToValue(double gain) {
        return (gain - -40.0) / 64.0;
    }

    private static double valueToGain(double value) {
        return value * 64.0 + -40.0;
    }
}

