/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import plus.dragons.visuality.Visuality;
import plus.dragons.visuality.config.ReloadableJsonConfig;
import plus.dragons.visuality.data.ParticleWithVelocity;
import plus.dragons.visuality.data.VisualityCodecs;
import plus.dragons.visuality.particle.type.ColorParticleType;
import plus.dragons.visuality.registry.VisualityParticles;

public class EntityArmorParticleConfig
extends ReloadableJsonConfig {
    private boolean enabled = true;
    private int interval = 20;
    private List<Entry> entries;
    private final IdentityHashMap<Item, ParticleWithVelocity> particles = new IdentityHashMap();

    public EntityArmorParticleConfig() {
        super(Visuality.location("particle_emitters/entity_armor"));
        this.entries = EntityArmorParticleConfig.createDefaultEntries();
        for (Entry entry : this.entries) {
            for (Item armor : entry.armors) {
                this.particles.put(armor, entry.particle);
            }
        }
    }

    public void spawnParticles(LivingEntity entity) {
        RenderLayerParent parent;
        if (!this.enabled) {
            return;
        }
        Level level = entity.level();
        if (!entity.isAlive()) {
            return;
        }
        RandomSource random = entity.getRandom();
        if (random.nextInt(this.interval) != 0) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        EntityRenderer renderer = minecraft.getEntityRenderDispatcher().getRenderer((Entity)entity);
        if (!(renderer instanceof RenderLayerParent) || !((parent = (RenderLayerParent)renderer).getModel() instanceof HumanoidModel)) {
            return;
        }
        if (minecraft.cameraEntity == entity && minecraft.options.getCameraType().isFirstPerson()) {
            return;
        }
        double height = random.nextDouble();
        EquipmentSlot slot = this.switchEquipmentSlotFromHeight(height);
        Item armor = entity.getItemBySlot(slot).getItem();
        if (this.particles.containsKey(armor)) {
            AABB aabb = entity.getBoundingBox();
            double radian = Math.PI * 2 * random.nextDouble();
            double x = Mth.lerp((double)(0.5 + 0.75 * Math.cos(radian)), (double)aabb.minX, (double)aabb.maxX);
            double y = Mth.lerp((double)height, (double)aabb.minY, (double)aabb.maxY);
            double z = Mth.lerp((double)(0.5 + 0.75 * Math.sin(radian)), (double)aabb.minZ, (double)aabb.maxZ);
            this.particles.get(armor).spawn(level, x, y, z);
        }
    }

    private EquipmentSlot switchEquipmentSlotFromHeight(double height) {
        if (height < 0.1875) {
            return EquipmentSlot.FEET;
        }
        if (height < 0.5) {
            return EquipmentSlot.LEGS;
        }
        if (height < 0.8125) {
            return EquipmentSlot.CHEST;
        }
        return EquipmentSlot.HEAD;
    }

    @Override
    @Nullable
    protected JsonObject apply(JsonObject input, boolean config, String source, ProfilerFiller profiler) {
        JsonArray array;
        profiler.push(source);
        if (config) {
            this.enabled = GsonHelper.getAsBoolean((JsonObject)input, (String)"enabled", (boolean)true);
            this.interval = GsonHelper.getAsInt((JsonObject)input, (String)"interval", (int)20);
        }
        if ((array = GsonHelper.getAsJsonArray((JsonObject)input, (String)"entries", null)) == null) {
            this.logger.warn("Failed to load options entries from {}: Missing JsonArray 'entries'.", (Object)source);
            profiler.pop();
            return config ? this.serializeConfig() : null;
        }
        boolean save = false;
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        ArrayList elements = Lists.newArrayList((Iterable)array);
        for (JsonElement element : elements) {
            DataResult data = Entry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (data.error().isPresent()) {
                save = config;
                this.logger.warn("Error parsing {} from {}: {}", new Object[]{this.id, source, ((DataResult.Error)data.error().get()).message()});
                continue;
            }
            if (data.result().isPresent()) {
                newEntries.add((Entry)data.result().get());
                continue;
            }
            save = config;
            this.logger.warn("Error parsing {} from {}: Missing decode result", (Object)this.id, (Object)source);
        }
        if (config) {
            this.entries = newEntries;
            this.particles.clear();
        }
        for (Entry entry : newEntries) {
            for (Item armor : entry.armors) {
                this.particles.put(armor, entry.particle);
            }
        }
        profiler.pop();
        return save ? this.serializeConfig() : null;
    }

    @Override
    protected JsonObject serializeConfig() {
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        object.addProperty("interval", (Number)this.interval);
        object.add("entries", (JsonElement)Entry.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.entries).getOrThrow());
        return object;
    }

    private static List<Entry> createDefaultEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(Entry.of(((ColorParticleType)((Object)VisualityParticles.SPARKLE.get())).withColor(16711613), Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS));
        entries.add(Entry.of(((ColorParticleType)((Object)VisualityParticles.SPARKLE.get())).withColor(11861486), Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS));
        return entries;
    }

    private record Entry(List<Item> armors, ParticleWithVelocity particle) {
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VisualityCodecs.compressedListOf(BuiltInRegistries.ITEM.byNameCodec()).fieldOf("armor").forGetter(Entry::armors), (App)ParticleWithVelocity.CODEC.fieldOf("particle").forGetter(Entry::particle)).apply((Applicative)instance, Entry::new));
        private static final Codec<List<Entry>> LIST_CODEC = CODEC.listOf();

        private static Entry of(ParticleOptions particle, Item ... armors) {
            return new Entry(List.of(armors), ParticleWithVelocity.ofZeroVelocity(particle));
        }
    }
}

