/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.base;

import com.drmangotea.tfmg.content.machinery.vat.base.VatBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class VatRenderer
extends SafeBlockEntityRenderer<VatBlockEntity> {
    public VatRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(VatBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        LerpedFloat[] fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        if (!be.window) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        ms.pushPose();
        float totalFluidHeight = 0.0f;
        float xMin = tankHullWidth;
        float xMax = xMin + (float)be.width - 2.0f * tankHullWidth;
        float zMin = tankHullWidth;
        float zMax = zMin + (float)be.width - 2.0f * tankHullWidth;
        int tankNumber = 0;
        for (int i = 0; i < 8; ++i) {
            IFluidHandler fluidHandler = be.fluidCapability;
            if (fluidHandler.getFluidInTank(tankNumber).isEmpty()) continue;
            float level = fluidLevel[i].getValue(partialTicks);
            float yMin = capHeight + totalFluidHeight;
            float yMax = yMin + level * ((float)be.height - 2.0f * capHeight) / 8.0f;
            NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidHandler.getFluidInTank(tankNumber), xMin, yMin, zMin, xMax, yMax, zMax, bufferSource, ms, light, false, false);
            ++tankNumber;
            totalFluidHeight += yMax - yMin;
        }
        ms.popPose();
    }

    public boolean shouldRenderOffScreen(VatBlockEntity te) {
        return te.isController();
    }
}

