/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.voltage_observer;

import com.drmangotea.tfmg.base.blocks.WallMountBlock;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.utilities.voltage_observer.VoltageObserverBlock;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class VoltageObserverBlockEntity
extends ElectricBlockEntity {
    boolean update = false;

    public VoltageObserverBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        this.update = true;
    }

    public int getComparatorOutput() {
        return ComparatorUtil.fractionToRedstoneLevel((double)((double)this.getData().getVoltage() / 250.0));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.update) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)VoltageObserverBlock.POWERED, (Comparable)Boolean.valueOf(this.getData().getVoltage() != 0)), 2);
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
            this.update = false;
        }
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == this.getBlockState().getValue((Property)WallMountBlock.FACING);
    }
}

