/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.segmented_display;

import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.utilities.segmented_display.SegmentedDisplayRenderer;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.foundation.utility.DynamicComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SegmentedDisplayBlockEntity
extends ElectricBlockEntity {
    private static final Couple<String> EMPTY = Couple.create((Object)"", (Object)"");
    private Optional<DynamicComponent> customText;
    private Couple<String> displayedStrings;
    public List<Integer> segmentsToRender = new ArrayList<Integer>();
    public List<Integer> segmentsToRender2 = new ArrayList<Integer>();
    public DyeColor color;
    private int partIndex;

    public SegmentedDisplayBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.customText = Optional.empty();
        this.color = DyeColor.LIME;
    }

    public void setColor(DyeColor color) {
        if (color == DyeColor.BLACK || color == DyeColor.LIGHT_GRAY || color == DyeColor.GRAY) {
            return;
        }
        this.color = color;
        this.notifyUpdate();
    }

    @Override
    public float resistance() {
        return 100.0f;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.getPowerUsage() < 5 || !this.canWork()) {
            this.segmentsToRender = new ArrayList<Integer>();
            this.segmentsToRender2 = new ArrayList<Integer>();
        } else {
            this.segmentsToRender = this.getSegments();
        }
    }

    public void clearCustomText() {
        this.partIndex = 0;
        this.customText = Optional.empty();
    }

    public List<Integer> getSegments() {
        List<Integer> segments = SegmentedDisplayRenderer.SYMBOLS_TO_SEGMENTS.get(((String)this.getDisplayedStrings().get(true)).toLowerCase());
        List<Integer> segments2 = SegmentedDisplayRenderer.SYMBOLS_TO_SEGMENTS.get(((String)this.getDisplayedStrings().get(false)).toLowerCase());
        if (segments2 == null) {
            segments2 = new ArrayList<Integer>();
        }
        if (segments == null) {
            segments = new ArrayList<Integer>();
        }
        ArrayList<Integer> segments3 = new ArrayList<Integer>();
        for (int segment : segments2) {
            segments3.add(segment + 10);
        }
        this.segmentsToRender2 = segments3;
        return segments;
    }

    public Couple<String> getDisplayedStrings() {
        if (this.displayedStrings == null) {
            return EMPTY;
        }
        return this.displayedStrings;
    }

    public void initialize() {
        if (this.level.isClientSide) {
            this.updateDisplayedStrings();
        }
    }

    public void displayCustomText(String tagElement, int partPositionInRow) {
        if (tagElement == null) {
            return;
        }
        if (this.customText.filter(d -> d.sameAs(tagElement)).isPresent()) {
            return;
        }
        DynamicComponent component = this.customText.orElseGet(DynamicComponent::new);
        component.displayCustomText(this.level, this.worldPosition, tagElement);
        this.customText = Optional.of(component);
        this.partIndex = partPositionInRow;
        DisplayLinkBlock.notifyGatherers((LevelAccessor)this.level, (BlockPos)this.worldPosition);
        this.notifyUpdate();
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction != this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
    }

    public void updateDisplayedStrings() {
        this.customText.map(DynamicComponent::resolve).ifPresentOrElse(fullText -> {
            this.displayedStrings = Couple.create((Object)this.charOrEmpty((String)fullText, this.partIndex * 2), (Object)this.charOrEmpty((String)fullText, this.partIndex * 2 + 1));
        }, () -> {
            this.displayedStrings = Couple.create((Object)"0", (Object)"0");
        });
    }

    public MutableComponent getFullText() {
        return this.customText.map(DynamicComponent::get).orElse(Component.literal((String)""));
    }

    @Override
    public void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.color = (DyeColor)NBTHelper.readEnum((CompoundTag)compound, (String)"color", DyeColor.class);
        if (compound.contains("CustomText")) {
            DynamicComponent component = this.customText.orElseGet(DynamicComponent::new);
            component.read(this.worldPosition, compound, registries);
            if (component.isValid()) {
                this.customText = Optional.of(component);
                this.partIndex = compound.getInt("CustomTextIndex");
            } else {
                this.customText = Optional.empty();
                this.partIndex = 0;
            }
        }
        if (clientPacket) {
            this.updateDisplayedStrings();
        }
    }

    @Override
    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        NBTHelper.writeEnum((CompoundTag)compound, (String)"color", (Enum)this.color);
        if (this.customText.isPresent()) {
            compound.putInt("CustomTextIndex", this.partIndex);
            this.customText.get().write(compound, registries);
        }
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }
}

