/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.electric_motor;

import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.KineticElectricBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ElectricMotorBlockEntity
extends KineticElectricBlockEntity {
    public boolean delayedUpdate = false;
    protected ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;

    public ElectricMotorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onPlaced() {
        super.onPlaced();
        for (IElectric member : this.getOrCreateElectricNetwork().members) {
            if (!(member instanceof ElectricMotorBlockEntity)) continue;
            ElectricMotorBlockEntity be = (ElectricMotorBlockEntity)member;
            be.delayedUpdate = true;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.delayedUpdate) {
            this.updateGeneratedRotation();
            this.delayedUpdate = false;
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MotorValueBox(this));
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
    }

    private void onDirectionChanged() {
        this.updateNextTick();
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.getBlockState().getValue((Property)DirectionalKineticBlock.FACING)).getOpposite() || direction.getAxis().isHorizontal() && direction == Direction.DOWN;
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        this.delayedUpdate = true;
        this.notifyUpdate();
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getPowerUsage() > 0) {
            this.updateNextTick();
        }
    }

    public float getGeneratedSpeed() {
        if (this.networkUndersupplied()) {
            return 0.0f;
        }
        if (!this.canWork()) {
            return 0.0f;
        }
        int rotation = this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.CLOCKWISE ? 1 : -1;
        float speed = Math.min(255.0f, (float)this.data.getVoltage() * 0.8f) * (float)rotation;
        return speed;
    }

    public float calculateAddedStressCapacity() {
        float speedModifier = this.getSpeed() / 256.0f;
        return Math.abs((int)(super.calculateAddedStressCapacity() * speedModifier));
    }

    @Override
    public float resistance() {
        return TFMGConfigs.common().machines.electricMotorInternalResistance.getF();
    }

    class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox(ElectricMotorBlockEntity this$0) {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.getValue((Property)DirectionalKineticBlock.FACING);
            return super.getLocalOffset(level, pos, state).add(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(-0.0625));
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
            Direction facing = (Direction)state.getValue((Property)DirectionalKineticBlock.FACING);
            if (facing.getAxis() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.of((PoseStack)ms).rotateZ(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.getValue((Property)DirectionalKineticBlock.FACING);
            if (facing.getAxis() != Direction.Axis.Y && direction == Direction.DOWN || direction == Direction.UP) {
                return false;
            }
            return direction.getAxis() != facing.getAxis();
        }
    }
}

