/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base.spark;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.spark.AbstractSpark;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SparkRenderer
extends EntityRenderer<AbstractSpark> {
    private final ResourceLocation TEXTURE_LOCATION;

    public SparkRenderer(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context);
        this.TEXTURE_LOCATION = texture;
    }

    public static SparkRenderer fireSpark(EntityRendererProvider.Context context) {
        return new SparkRenderer(context, TFMG.asResource("textures/particle/lava.png"));
    }

    public static SparkRenderer greenSpark(EntityRendererProvider.Context context) {
        return new SparkRenderer(context, TFMG.asResource("textures/entity/green_spark.png"));
    }

    public static SparkRenderer blueSpark(EntityRendererProvider.Context context) {
        return new SparkRenderer(context, TFMG.asResource("textures/entity/blue_spark.png"));
    }

    public static SparkRenderer lithiumSpark(EntityRendererProvider.Context context) {
        return new SparkRenderer(context, TFMG.asResource("textures/entity/lithium_spark.png"));
    }

    public static SparkRenderer dryIceFlakeSpark(EntityRendererProvider.Context context) {
        return new SparkRenderer(context, TFMG.asResource("textures/entity/dry_ice_flake.png"));
    }

    protected int getBlockLightLevel(AbstractSpark flake, BlockPos blockPos) {
        return 15;
    }

    public void render(AbstractSpark flake, float p_114081_, float p_114082_, PoseStack stack, MultiBufferSource bufferSource, int p_114085_) {
        stack.pushPose();
        stack.scale(0.5f, 0.5f, 0.5f);
        stack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        stack.mulPose(Axis.YP.rotationDegrees(180.0f));
        PoseStack.Pose posestack$pose = stack.last();
        Matrix4f matrix4f = posestack$pose.pose();
        Matrix3f matrix3f = posestack$pose.normal();
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.TEXTURE_LOCATION));
        SparkRenderer.vertex(vertexconsumer, matrix4f, matrix3f, p_114085_, 0.0f, 0, 0, 1);
        SparkRenderer.vertex(vertexconsumer, matrix4f, matrix3f, p_114085_, 1.0f, 0, 1, 1);
        SparkRenderer.vertex(vertexconsumer, matrix4f, matrix3f, p_114085_, 1.0f, 1, 1, 0);
        SparkRenderer.vertex(vertexconsumer, matrix4f, matrix3f, p_114085_, 0.0f, 1, 0, 0);
        stack.popPose();
        super.render((Entity)flake, p_114081_, p_114082_, stack, bufferSource, p_114085_);
    }

    private static void vertex(VertexConsumer p_114090_, Matrix4f p_114091_, Matrix3f p_114092_, int p_114093_, float p_114094_, int p_114095_, int p_114096_, int p_114097_) {
        p_114090_.addVertex(p_114091_, p_114094_ - 0.5f, (float)p_114095_ - 0.25f, 0.0f).setColor(255, 255, 255, 255).setUv((float)p_114096_, (float)p_114097_).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(p_114093_, p_114093_).setNormal(0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(AbstractSpark spark) {
        return this.TEXTURE_LOCATION;
    }
}

