/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base.spark;

import com.drmangotea.tfmg.base.spark.AbstractSpark;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.registry.TFMGMobEffects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class DryIceFlake
extends AbstractSpark {
    public DryIceFlake(EntityType<? extends DryIceFlake> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount > 40) {
            this.discard();
        }
    }

    @Override
    public Optional<SimpleParticleType> getParticleEffect() {
        return Optional.of(ParticleTypes.SNOWFLAKE);
    }

    protected void onHitBlock(BlockHitResult blockHit) {
        Entity owner;
        super.onHitBlock(blockHit);
        if (!this.level().isClientSide && !((owner = this.getOwner()) instanceof Mob)) {
            BlockPos hitBlockPos = blockHit.getBlockPos().relative(blockHit.getDirection());
            AABB extinguisRadius = new AABB(hitBlockPos);
            extinguisRadius = extinguisRadius.inflate((double)((Integer)TFMGConfigs.common().machines.fireExtinguisherClearRadius.get()).intValue());
            Stream positions = BlockPos.betweenClosedStream((AABB)extinguisRadius);
            positions.forEach(p -> {
                BlockState state = this.level().getBlockState(p);
                if (state.getBlock() instanceof BaseFireBlock) {
                    this.level().setBlockAndUpdate(p, Blocks.AIR.defaultBlockState());
                }
            });
        }
    }

    protected void onHitEntity(EntityHitResult entityHit) {
        super.onHitEntity(entityHit);
        if (!this.level().isClientSide) {
            Entity hitEntity = entityHit.getEntity();
            hitEntity.extinguishFire();
            if (hitEntity.canFreeze()) {
                int currentFreeze = hitEntity.getTicksFrozen();
                int freezeIncrement = 10;
                int newFreeze = Math.min(currentFreeze + freezeIncrement, hitEntity.getTicksRequiredToFreeze() + 20);
                hitEntity.setTicksFrozen(newFreeze);
                if (newFreeze >= hitEntity.getTicksRequiredToFreeze()) {
                    hitEntity.hurt(this.damageSources().freeze(), 2.0f);
                }
                if (hitEntity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)hitEntity;
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 2, false, false, true));
                    livingEntity.removeEffect(TFMGMobEffects.HELLFIRE);
                }
            }
        }
    }

    protected void onHit(HitResult hit) {
        super.onHit(hit);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }
}

