/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.config;

import dev.imb11.mru.yacl.EntryType;
import dev.imb11.sounds.api.config.ConfiguredSound;
import dev.imb11.sounds.api.config.DynamicConfiguredSound;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.utils.ConfigGroup;
import dev.imb11.sounds.sound.context.ItemStackSoundContext;
import dev.imb11.sounds.sound.context.RepeaterSoundContext;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;

public class WorldSoundsConfig
extends ConfigGroup<WorldSoundsConfig>
implements YetAnotherConfigLib.ConfigBackedBuilder<WorldSoundsConfig> {
    @SerialEntry
    public DynamicConfiguredSound<Integer, RepeaterSoundContext> repeaterUseSoundEffect = new DynamicConfiguredSound("repeaterUse", SoundEvents.STONE_BUTTON_CLICK_ON, true, 0.95f, 0.3f, true);
    @SerialEntry
    public ConfiguredSound jukeboxUseSoundEffect = new ConfiguredSound("jukeboxUse", (Holder.Reference<SoundEvent>)SoundEvents.NOTE_BLOCK_BASEDRUM, true, 0.8f, 0.75f);
    @SerialEntry
    public ConfiguredSound daylightDetectorUseSoundEffect = new ConfiguredSound("daylightDetectorUse", (Holder.Reference<SoundEvent>)SoundEvents.NOTE_BLOCK_HAT, true, 0.8f, 0.45f);
    @SerialEntry
    public ConfiguredSound furnaceMinecartFuelSoundEffect = new ConfiguredSound("furnaceMinecartFuel", SoundEvents.CREEPER_HURT, true, 1.9f, 0.2f);
    @SerialEntry
    public ConfiguredSound frostWalkerSoundEffect = new ConfiguredSound("frostWalker", SoundEvents.POWDER_SNOW_FALL, true, 2.0f, 0.5f);
    @SerialEntry
    public ConfiguredSound leadSnappingSoundEffect = new ConfiguredSound("leadSnapping", SoundEvents.LEASH_KNOT_BREAK, true, 1.0f, 0.5f);
    @SerialEntry
    public ConfiguredSound bowPullSoundEffect = new ConfiguredSound("bowPull", (Holder<SoundEvent>)SoundEvents.CROSSBOW_LOADING_MIDDLE, true, 1.0f, 0.25f);
    @SerialEntry
    public DynamicConfiguredSound<ItemStack, ItemStackSoundContext> plantPotFillSoundEffect = new DynamicConfiguredSound("plantPotFill", SoundEvents.GRASS_PLACE, true, 1.1f, 0.4f, true);
    @SerialEntry
    public ConfiguredSound cakeEatSoundEffect = new ConfiguredSound("cakeEat", SoundEvents.GENERIC_EAT, true, 1.2f, 0.7f);
    @SerialEntry
    public boolean enableEnderpearlVariety = true;
    @SerialEntry
    public boolean disableBlocksEntirely = false;
    @SerialEntry
    public List<String> ignoredBlocks = new ArrayList<String>();

    public WorldSoundsConfig() {
        super(WorldSoundsConfig.class);
    }

    @Override
    public YetAnotherConfigLib getYACL() {
        return YetAnotherConfigLib.create(this.getHandler(), (YetAnotherConfigLib.ConfigBackedBuilder)this);
    }

    @Override
    public ResourceLocation getIcon() {
        return ResourceLocation.fromNamespaceAndPath((String)"sounds", (String)"textures/gui/world_sounds.png");
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"sounds.config.world");
    }

    @Override
    public String getID() {
        return "world";
    }

    public YetAnotherConfigLib.Builder build(WorldSoundsConfig defaults, WorldSoundsConfig config, YetAnotherConfigLib.Builder builder) {
        builder.title(Component.nullToEmpty((String)"World Sounds"));
        builder.category(ConfigCategory.createBuilder().name((Component)Component.translatable((String)"sounds.config.world.mechanics")).group(config.repeaterUseSoundEffect.getOptionGroup(defaults.repeaterUseSoundEffect)).group(config.jukeboxUseSoundEffect.getOptionGroup(defaults.jukeboxUseSoundEffect)).group(config.daylightDetectorUseSoundEffect.getOptionGroup(defaults.daylightDetectorUseSoundEffect)).group(config.furnaceMinecartFuelSoundEffect.getOptionGroup(defaults.furnaceMinecartFuelSoundEffect)).build());
        builder.category(ConfigCategory.createBuilder().name((Component)Component.translatable((String)"sounds.config.world.blocks")).option(SoundsConfig.HELPER.get("disableBlocksEntirely", defaults.disableBlocksEntirely, () -> config.disableBlocksEntirely, v1 -> {
            config.disableBlocksEntirely = v1;
        })).option((Option)LabelOption.create((Component)Component.translatable((String)"sounds.config.world.blocks.description"))).option((Option)ButtonOption.createBuilder().name(Component.nullToEmpty((String)"Open Wiki")).description(OptionDescription.EMPTY).action((screen, option) -> Util.getPlatform().openUri("https://docs.imb11.dev/sounds/data/custom-block-sounds")).build()).option((Option)LabelOption.create((Component)Component.empty())).option((Option)ListOption.createBuilder().name(SoundsConfig.HELPER.getText(EntryType.OPTION_NAME, "ignoredBlocks")).description(OptionDescription.of((Component[])new Component[]{SoundsConfig.HELPER.getText(EntryType.OPTION_DESCRIPTION, "ignoredBlocks")})).binding(defaults.ignoredBlocks, () -> config.ignoredBlocks, val -> {
            config.ignoredBlocks = val;
        }).controller(opt -> DropdownStringControllerBuilder.create((Option)opt).allowEmptyValue(false).values(BuiltInRegistries.BLOCK.registryKeySet().stream().map(ResourceKey::location).map(ResourceLocation::toString).toList())).initial((Object)"minecraft:grass_block").build()).build());
        builder.category(ConfigCategory.createBuilder().name((Component)Component.translatable((String)"sounds.config.world.actions")).option(SoundsConfig.HELPER.get("enableEnderpearlVariety", defaults.enableEnderpearlVariety, () -> config.enableEnderpearlVariety, v -> {
            config.enableEnderpearlVariety = v;
        })).group(config.frostWalkerSoundEffect.getOptionGroup(defaults.frostWalkerSoundEffect)).group(config.leadSnappingSoundEffect.getOptionGroup(defaults.leadSnappingSoundEffect)).group(config.bowPullSoundEffect.getOptionGroup(defaults.bowPullSoundEffect)).group(config.plantPotFillSoundEffect.getOptionGroup(defaults.plantPotFillSoundEffect)).group(config.cakeEatSoundEffect.getOptionGroup(defaults.cakeEatSoundEffect)).build());
        return builder;
    }
}

