/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstoragecreateintegration.storage;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SophisticatedMenuProvider;
import net.p3pp3rf1y.sophisticatedcore.compat.create.ContraptionHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageData;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageUpdatePayload;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderBase;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.HopperUpgradeItem;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.common.MountedLimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.common.MountedStorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.network.MountedStorageOpennessPayload;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.storage.MountedSophisticatedStorage;

public class MountedStorageHolder
extends StorageHolderBase {
    private final Consumer<ItemStack> storageStackSetter;
    private final Supplier<ItemStack> storageStackGetter;
    @Nullable
    private WeakReference<Entity> contraptionEntity = null;
    private BlockPos localPos = BlockPos.ZERO;
    private BlockPos chestOtherPartPos = BlockPos.ZERO;
    private Vec3 position = Vec3.ZERO;
    @Nullable
    private WeakReference<Level> level = null;
    private boolean clearedNbt = false;
    @Nullable
    private WeakReference<IStorageWrapper> otherHalfStorageWrapper = null;
    private boolean refreshClientBlockRender = false;
    private boolean dirty = false;

    public MountedStorageHolder(Supplier<ItemStack> storageStackGetter, Consumer<ItemStack> storageStackSetter) {
        super(false);
        this.storageStackGetter = storageStackGetter;
        this.storageStackSetter = storageStackSetter;
        this.updateRenderAttributes = true;
    }

    public void setLocalPos(BlockPos localPos) {
        this.localPos = localPos;
    }

    public void setStorageItem(ItemStack storageItem) {
        super.setStorageItem(storageItem);
        this.dirty = true;
    }

    protected boolean isOwnContainer(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof MountedStorageContainerMenu) {
            MountedStorageContainerMenu mountedStorageContainerMenu = (MountedStorageContainerMenu)abstractContainerMenu;
            return mountedStorageContainerMenu.getContraptionEntity().map(c -> c == this.getEntity() && (mountedStorageContainerMenu.getLocalPos().equals((Object)this.localPos) || mountedStorageContainerMenu.getLocalPos().equals((Object)this.chestOtherPartPos))).orElse(false);
        }
        return false;
    }

    protected IStorageSavedData getStorageData(UUID storageId) {
        return MountedStorageData.get((UUID)storageId);
    }

    protected void setSyncedStorageStack(ItemStack storageStack) {
        this.storageStackSetter.accept(storageStack);
    }

    protected ItemStack getSyncedStorageStack() {
        return this.storageStackGetter.get();
    }

    protected boolean isLocked(ItemStack storageItem) {
        return (Boolean)storageItem.getOrDefault(ModDataComponents.LOCKED, (Object)false);
    }

    @Nullable
    protected Level getLevel() {
        return this.level == null ? null : (Level)this.level.get();
    }

    public void setLevel(Level level) {
        this.level = new WeakReference<Level>(level);
        if (!level.isClientSide()) {
            this.getStorageWrapper().getRenderInfo().setDisplayItemsChangeListener(ri -> this.updateClientBlockRenderAfterNextSync());
        }
    }

    public void updateClientBlockRenderAfterNextSync() {
        this.refreshClientBlockRender = true;
    }

    public void tick(Entity entity) {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            this.sendStorageUpdatePayload();
        }
        super.tick(entity);
    }

    public void sendStorageUpdatePayload() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        Entity entity = this.getEntity();
        if (entity == null || entity.level().isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new MountedStorageUpdatePayload(entity.getId(), this.localPos, this.getSyncedStorageStack(), this.refreshClientBlockRender && this.isBarrel()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected Vec3 getPosition() {
        return this.position;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    @Nullable
    protected Entity getEntity() {
        return this.contraptionEntity == null ? null : (Entity)this.contraptionEntity.get();
    }

    public void setContraptionEntity(Entity entity) {
        this.contraptionEntity = new WeakReference<Entity>(entity);
    }

    @Nullable
    protected StorageBlockEntity retrieveRenderBlockEntity() {
        Entity e = this.getEntity();
        if (e instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)e;
            return (StorageBlockEntity)abstractContraptionEntity.getContraption().presentBlockEntities.get(this.localPos);
        }
        return null;
    }

    protected boolean isUpgradeRunnable(ItemStack upgrade) {
        return !(upgrade.getItem() instanceof HopperUpgradeItem);
    }

    protected void refreshRenderBlockEntity() {
        StorageBlockEntity renderBlockEntity = this.retrieveRenderBlockEntity();
        if (renderBlockEntity != null) {
            this.updateRenderBlockEntityAttributes(this.getSyncedStorageStack(), renderBlockEntity);
        }
    }

    protected void updateRenderBlockEntityAttributes(ItemStack storageItem, StorageBlockEntity renderBlockEntity) {
        Entity entity;
        if (this.updateRenderAttributes && (entity = this.getEntity()) instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity cEntity = (AbstractContraptionEntity)entity;
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)cEntity.getContraption().getBlocks().get(this.localPos);
            renderBlockEntity.setBlockState(blockInfo.state());
        }
        super.updateRenderBlockEntityAttributes(storageItem, renderBlockEntity);
    }

    protected void setLocked(boolean locked) {
        this.getSyncedStorageStack().set(ModDataComponents.LOCKED, (Object)locked);
    }

    protected AABB getPickupBoundingBox() {
        return new AABB(this.getPosition(), this.getPosition().add(1.0, 1.0, 1.0)).inflate(0.2);
    }

    protected void openMenu(Player player) {
        Entity e = this.getEntity();
        if (e == null) {
            return;
        }
        player.openMenu((MenuProvider)new SophisticatedMenuProvider((w, p, pl) -> this.createMenu(w, pl, e.getId(), this.localPos), this.getSyncedStorageStack().getHoverName(), false), buffer -> {
            buffer.writeInt(e.getId());
            buffer.writeBlockPos(this.localPos);
        });
    }

    private MountedStorageContainerMenuBase createMenu(int id, Player pl, int contraptionEntityId, BlockPos localPos) {
        if (MovingStorageWrapper.isLimitedBarrel((ItemStack)this.getSyncedStorageStack())) {
            return new MountedLimitedBarrelContainerMenu(id, pl, contraptionEntityId, localPos);
        }
        return new MountedStorageContainerMenu(id, pl, contraptionEntityId, localPos);
    }

    protected void playSound(SoundEvent sound) {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        Vec3 position = this.getPosition().add(0.5, 0.5, 0.5);
        level.playSound(null, position.x(), position.y(), position.z(), sound, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    void initEntityLevelAndPositions(MovementContext context) {
        if (this.getEntity() == null) {
            AbstractContraptionEntity entity = context.contraption.entity;
            BlockPos localPos = context.localPos;
            Vec3 position = context.position;
            Level level = context.world;
            this.initEntityLevelAndPositions(entity, localPos, level, position, context.state);
        }
    }

    public void initEntityLevelAndPositions(AbstractContraptionEntity abstractContraptionEntity, BlockPos localPos, Level level, Vec3 position, BlockState state) {
        this.setContraptionEntity((Entity)abstractContraptionEntity);
        this.setLocalPos(localPos);
        this.setLevel(level);
        this.setPosition(position);
        if (this.isChest() && state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
            Object v;
            this.chestOtherPartPos = localPos.relative(ChestBlock.getConnectedDirection((BlockState)state));
            boolean bl = this.isMainStorage = state.getValue((Property)ChestBlock.TYPE) == ChestType.RIGHT;
            if (!this.isMainStorage && level.isClientSide() && (v = abstractContraptionEntity.getContraption().presentBlockEntities.get(localPos)) instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)v;
                chestBlockEntity.setMainPos(this.chestOtherPartPos);
            }
        }
    }

    public void clearNbt() {
        Entity entity;
        if (!this.clearedNbt && (entity = this.getEntity()) instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)entity;
            abstractContraptionEntity.getContraption().getBlocks().computeIfPresent(this.localPos, (p, blockInfo) -> new StructureTemplate.StructureBlockInfo(blockInfo.pos(), blockInfo.state(), null));
            this.clearedNbt = true;
        }
    }

    public void startOpen(Player player, Entity entity) {
        super.startOpen(player, entity);
        if (this.isChest() && this.isMainStorage && this.chestOtherPartPos != BlockPos.ZERO) {
            this.getHolderOfOtherHalf(this.chestOtherPartPos).ifPresent(holder -> holder.startOpen(player, entity));
        }
    }

    @Nullable
    protected CustomPacketPayload createOpennessPayload() {
        Entity entity = this.getEntity();
        if (entity == null) {
            return null;
        }
        return new MountedStorageOpennessPayload(this.getEntity().getId(), this.isDoubleChest() && !this.isMainStorage ? this.chestOtherPartPos : this.localPos, this.isOpen());
    }

    private Optional<StorageHolderBase> getHolderOfOtherHalf() {
        if (this.isChest() && this.chestOtherPartPos != BlockPos.ZERO) {
            return this.getHolderOfOtherHalf(this.chestOtherPartPos).map(MountedStorageHolder.class::cast);
        }
        return Optional.empty();
    }

    private Optional<MountedStorageHolder> getHolderOfOtherHalf(BlockPos otherHalfLocalPos) {
        AbstractContraptionEntity abstractContraptionEntity;
        MountedStorageBase mountedStorageBase;
        Entity e = this.getEntity();
        if (e instanceof AbstractContraptionEntity && (mountedStorageBase = ContraptionHelper.getMountedStorage((AbstractContraptionEntity)(abstractContraptionEntity = (AbstractContraptionEntity)e), (BlockPos)otherHalfLocalPos)) instanceof MountedSophisticatedStorage) {
            MountedSophisticatedStorage mountedSophisticatedStorage = (MountedSophisticatedStorage)mountedStorageBase;
            return Optional.of(mountedSophisticatedStorage.getStorageHolder());
        }
        return Optional.empty();
    }

    public void stopOpen(Player player, Entity entity) {
        super.stopOpen(player, entity);
        if (this.isChest() && this.isMainStorage && this.chestOtherPartPos != BlockPos.ZERO) {
            this.getHolderOfOtherHalf(this.chestOtherPartPos).ifPresent(holder -> holder.stopOpen(player, entity));
        }
    }

    public IStorageWrapper getMainStorageWrapper() {
        if (this.isMainStorage) {
            return this.getStorageWrapper();
        }
        if (this.otherHalfStorageWrapper == null || this.otherHalfStorageWrapper.get() == null) {
            Object wrapper = this.getEntity() == null || this.getEntity().level().isClientSide() ? NoopStorageWrapper.INSTANCE : this.getHolderOfOtherHalf(this.chestOtherPartPos).map(StorageHolderBase::getStorageWrapper).orElse((IStorageWrapper)NoopStorageWrapper.INSTANCE);
            this.otherHalfStorageWrapper = new WeakReference<NoopStorageWrapper>((NoopStorageWrapper)wrapper);
            return wrapper;
        }
        return (IStorageWrapper)this.otherHalfStorageWrapper.get();
    }

    public void updateState() {
        Entity entity = this.getEntity();
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity cEntity = (AbstractContraptionEntity)entity;
            entity = this.getSyncedStorageStack().getItem();
            if (entity instanceof StorageBlockItem) {
                StorageBlockItem storageBlockItem = (StorageBlockItem)entity;
                StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)cEntity.getContraption().getBlocks().get(this.localPos);
                BlockState newBlockState = storageBlockItem.getBlock().defaultBlockState();
                for (Map.Entry entry : blockInfo.state().getValues().entrySet()) {
                    newBlockState = this.setStateValue(newBlockState, (Property)entry.getKey(), entry.getValue());
                }
                cEntity.setBlock(this.localPos, new StructureTemplate.StructureBlockInfo(blockInfo.pos(), newBlockState, blockInfo.nbt()));
            }
        }
    }

    private <T extends Comparable<T>> BlockState setStateValue(BlockState state, Property<T> property, Object value) {
        return (BlockState)state.setValue(property, (Comparable)value);
    }

    public void setDirty() {
        this.dirty = true;
    }

    public Optional<StorageHolderBase> getAuxiliaryStorageHolder() {
        return this.isMainStorage ? this.getHolderOfOtherHalf() : Optional.of(this);
    }

    public StorageHolderBase getMainStorageHolder() {
        return this.isMainStorage ? super.getMainStorageHolder() : this.getHolderOfOtherHalf().orElse(this);
    }

    public boolean isDoubleChest() {
        return this.isChest() && this.chestOtherPartPos != BlockPos.ZERO;
    }

    public void setShouldBeOpen(boolean shouldBeOpen) {
        super.setShouldBeOpen(shouldBeOpen);
        if (this.isDoubleChest() && this.isMainStorage) {
            this.getHolderOfOtherHalf().ifPresent(holder -> holder.setShouldBeOpen(shouldBeOpen));
        }
    }
}

