/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstoragecreateintegration.storage;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SophisticatedMenuProvider;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageData;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.ITintable;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.IMaterialHolder;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderBase;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderTierUpgradeHandler;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderToolHandler;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.PaintbrushItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageTierUpgradeItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.common.MountedLimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.common.MountedStorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.init.ModContent;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.storage.MountedStorageHolder;

public class MountedSophisticatedStorage
extends MountedStorageBase {
    public static final MapCodec<MountedSophisticatedStorage> CODEC = ItemStack.OPTIONAL_CODEC.xmap(MountedSophisticatedStorage::new, MountedStorageBase::getStorageStack).fieldOf("value");
    protected static final Multimap<Class<? extends Item>, NbtToComponentMapper<?>> NBT_TO_COMPONENT_MAPPERS = LinkedListMultimap.create();
    private final MountedStorageHolder storageHolder = new MountedStorageHolder(() -> ((MountedSophisticatedStorage)this).getStorageStack(), this::setStorageStack);

    public static void registerNbtToComponentMapper(Class<? extends Item> itemClass, NbtToComponentMapper<?> mapper) {
        NBT_TO_COMPONENT_MAPPERS.put(itemClass, mapper);
    }

    public MountedSophisticatedStorage(ItemStack storageStack) {
        super((MountedItemStorageType)ModContent.SOPHISTICATED_MOUNTED_STORAGE_TYPE.get(), storageStack);
    }

    public void setStorageStack(ItemStack stack) {
        super.setStorageStack(stack);
        if (this.storageHolder.getEntity() != null && !this.storageHolder.getEntity().level().isClientSide()) {
            this.storageHolder.setDirty();
        }
    }

    public static MountedSophisticatedStorage from(Level level, StorageBlockEntity storage) {
        ChestBlockEntity chestBlock;
        BlockState blockState;
        ChestBlockEntity chestBe;
        boolean rightChestPart = storage instanceof ChestBlockEntity && !(chestBe = (ChestBlockEntity)storage).isMainChest();
        storage.removeFromController();
        StorageWrapper storageWrapper = storage.getStorageWrapper();
        ItemStack storageItem = storageWrapper.getWrappedStorageStack();
        Item item = storageItem.getItem();
        if (item instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            if (storageWrapper.getMainColor() != -1) {
                tintableBlockItem.setMainColor(storageItem, storageWrapper.getMainColor());
            }
            if (storageWrapper.getAccentColor() != -1) {
                tintableBlockItem.setAccentColor(storageItem, storageWrapper.getAccentColor());
            }
        }
        ((ItemDisplaySettingsCategory)storage.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
        CompoundTag fullBeNbt = storage.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
        CompoundTag contentsNbt = new CompoundTag();
        CompoundTag storageWrapperNbt = fullBeNbt.getCompound("storageWrapper");
        contentsNbt.put("contents", (Tag)storageWrapperNbt.getCompound("contents"));
        contentsNbt.put("settings", (Tag)storageWrapperNbt.getCompound("settings"));
        storageItem.set(ModCoreDataComponents.RENDER_INFO_TAG, (Object)CustomData.of((CompoundTag)storageWrapperNbt.getCompound("renderInfo")));
        storageItem.set(ModCoreDataComponents.SORT_BY, (Object)NBTHelper.getString((CompoundTag)storageWrapperNbt, (String)"sortBy").map(SortBy::fromName).orElse(SortBy.NAME));
        storageItem.set(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)storageWrapperNbt.getInt("numberOfInventorySlots"));
        storageItem.set(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)storageWrapperNbt.getInt("numberOfUpgradeSlots"));
        if (!rightChestPart) {
            UUID id = UUID.randomUUID();
            storageItem.set(ModCoreDataComponents.STORAGE_UUID, (Object)id);
            MountedStorageData.get((UUID)id).setContents(contentsNbt);
            StorageBlockItem.setNumberOfInventorySlots((ItemStack)storageItem, (int)storageWrapper.getInventoryHandler().getSlots());
            StorageBlockItem.setNumberOfUpgradeSlots((ItemStack)storageItem, (int)storageWrapper.getUpgradeHandler().getSlots());
        }
        for (Map.Entry entry : NBT_TO_COMPONENT_MAPPERS.entries()) {
            if (!((Class)entry.getKey()).isInstance(storageItem.getItem())) continue;
            NbtToComponentMapper mapper = (NbtToComponentMapper)entry.getValue();
            if (!fullBeNbt.contains(mapper.tagName)) continue;
            MountedSophisticatedStorage.setComponentValue(level, mapper, storageItem, fullBeNbt);
        }
        if (storage instanceof ChestBlockEntity && (blockState = (chestBlock = (ChestBlockEntity)storage).getBlockState()).getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
            ChestBlockItem.setDoubleChest((ItemStack)storageItem, (boolean)true);
            chestBlock.removeDoubleMainPos();
        }
        MountedSophisticatedStorage mountedStorage = new MountedSophisticatedStorage(storageItem);
        if (!level.isClientSide()) {
            mountedStorage.getStorageHolder().setDirty();
        }
        return mountedStorage;
    }

    private static <T> void setComponentValue(Level level, NbtToComponentMapper<T> mapper, ItemStack storageItem, CompoundTag fullBeNbt) {
        storageItem.set(mapper.type.get(), mapper.nbtValueGetter.get(fullBeNbt, mapper.tagName, level));
    }

    protected void afterInitialSync() {
        this.storageHolder.refreshRenderBlockEntity();
    }

    public void updateWithSyncedStorageStack(ItemStack storageStack, boolean refreshBlockRender) {
        Entity entity;
        this.storageHolder.setStorageItem(storageStack);
        this.storageHolder.refreshRenderBlockEntity();
        if (refreshBlockRender && (entity = this.storageHolder.getEntity()) instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
            contraptionEntity.getContraption().deferInvalidate = true;
        }
    }

    public IStorageWrapper getStorageWrapper() {
        return this.storageHolder.getStorageWrapper();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        Map.Entry entry2;
        Integer numberOfUpgradeSlots;
        Integer numberOfInventorySlots;
        if (!this.getStorageStack().has(ModCoreDataComponents.STORAGE_UUID)) return;
        if (!(be instanceof StorageBlockEntity)) return;
        StorageBlockEntity storageBe = (StorageBlockEntity)be;
        UUID storageUuid = (UUID)this.getStorageStack().get(ModCoreDataComponents.STORAGE_UUID);
        MountedStorageData mountedStorageData = MountedStorageData.get((UUID)storageUuid);
        CompoundTag fullBeNbt = new CompoundTag();
        CompoundTag contentNbt = mountedStorageData.getContents();
        contentNbt.put("renderInfo", (Tag)((CustomData)this.getStorageStack().getOrDefault(ModCoreDataComponents.RENDER_INFO_TAG, (Object)CustomData.EMPTY)).copyTag());
        SortBy sortBy = (SortBy)this.getStorageStack().get(ModCoreDataComponents.SORT_BY);
        if (sortBy != null) {
            contentNbt.putString("sortBy", sortBy.getSerializedName());
        }
        if ((numberOfInventorySlots = (Integer)this.getStorageStack().get(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS)) != null) {
            contentNbt.putInt("numberOfInventorySlots", numberOfInventorySlots.intValue());
        }
        if ((numberOfUpgradeSlots = (Integer)this.getStorageStack().get(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS)) != null) {
            contentNbt.putInt("numberOfUpgradeSlots", numberOfUpgradeSlots.intValue());
        }
        fullBeNbt.put("storageWrapper", (Tag)contentNbt);
        for (Map.Entry entry2 : NBT_TO_COMPONENT_MAPPERS.entries()) {
            if (!((Class)entry2.getKey()).isInstance(this.getStorageStack().getItem())) continue;
            this.setNbtValueFromComponent(fullBeNbt, (NbtToComponentMapper)entry2.getValue(), this.getStorageStack(), level);
        }
        if (state.getBlock() instanceof ChestBlock && state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
            storageBe.setBeingUpgraded(true);
        }
        storageBe.loadAdditional(fullBeNbt, (HolderLookup.Provider)level.registryAccess());
        entry2 = this.getStorageStack().getItem();
        if (entry2 instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)entry2;
            storageBe.getStorageWrapper().setColors(tintableBlockItem.getMainColor(this.getStorageStack()).orElse(-1).intValue(), tintableBlockItem.getAccentColor(this.getStorageStack()).orElse(-1).intValue());
        }
        mountedStorageData.removeStorageContents();
        if (storageBe instanceof ChestBlockEntity) {
            ChestBlockEntity chestBe = (ChestBlockEntity)storageBe;
            if (state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
                BlockState inWorldState = level.getBlockState(pos);
                ChestType chestType = (ChestType)state.getValue((Property)ChestBlock.TYPE);
                level.setBlock(pos, (BlockState)inWorldState.setValue((Property)ChestBlock.TYPE, (Comparable)chestType), 3);
                Direction facing = (Direction)inWorldState.getValue((Property)ChestBlock.FACING);
                BlockPos connectedPos = pos.relative(chestType == ChestType.LEFT ? facing.getClockWise() : facing.getCounterClockWise());
                WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)connectedPos, ChestBlockEntity.class).ifPresent(otherHalfBe -> {
                    ChestBlockEntity mainBe = chestType == ChestType.LEFT ? otherHalfBe : chestBe;
                    ChestBlockEntity attachedBe = chestType == ChestType.LEFT ? chestBe : otherHalfBe;
                    mainBe.setBeingUpgraded(false);
                    attachedBe.setBeingUpgraded(false);
                    attachedBe.setMainPos(mainBe.getBlockPos());
                    mainBe.getStorageWrapper().onInit();
                    mainBe.tryToAddToController();
                });
                return;
            }
        }
        storageBe.getStorageWrapper().onInit();
        storageBe.tryToAddToController();
    }

    private <T> void setNbtValueFromComponent(CompoundTag fullBeNbt, NbtToComponentMapper<T> mapper, ItemStack storageItem, Level level) {
        if (storageItem.has(mapper.type.get())) {
            Object value = storageItem.get(mapper.type.get());
            if (value != null) {
                mapper.nbtValueSetter.set(fullBeNbt, mapper.tagName, value, level);
            }
        } else {
            fullBeNbt.remove(mapper.tagName);
        }
    }

    public MountedStorageContainerMenuBase createMenu(int id, Player pl, int contraptionEntityId, BlockPos localPos) {
        if (MovingStorageWrapper.isLimitedBarrel((ItemStack)this.getStorageStack())) {
            return new MountedLimitedBarrelContainerMenu(id, pl, contraptionEntityId, localPos);
        }
        return new MountedStorageContainerMenu(id, pl, contraptionEntityId, localPos);
    }

    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        if (WoodStorageBlockItem.isPacked((ItemStack)this.getStorageStack())) {
            return false;
        }
        ServerLevel level = player.serverLevel();
        BlockPos localPos = info.pos();
        if (info.state().getBlock() instanceof ChestBlock && info.state().getValue((Property)ChestBlock.TYPE) == ChestType.LEFT) {
            localPos = info.pos().relative(ChestBlock.getConnectedDirection((BlockState)info.state()));
        }
        int contraptionEntityId = contraption.entity.getId();
        ItemStack itemInHand = player.getMainHandItem();
        Item item = itemInHand.getItem();
        if (item instanceof StorageTierUpgradeItem) {
            StorageTierUpgradeItem tierUpgradeItem = (StorageTierUpgradeItem)item;
            InteractionResult result = this.tryStorageTierUpgrade(player, itemInHand, tierUpgradeItem);
            if (result != InteractionResult.PASS) {
                return result == InteractionResult.SUCCESS;
            }
        } else {
            if (itemInHand.getItem() instanceof StorageToolItem && this.tryToolInteraction(itemInHand)) {
                return true;
            }
            if (itemInHand.getItem() instanceof UpgradeItemBase && this.tryAddStorageUpgrade((Player)player, itemInHand)) {
                return true;
            }
            if (itemInHand.getItem() == ModItems.PAINTBRUSH.get() && this.tryPaintStorage((Player)player, itemInHand)) {
                return true;
            }
        }
        Vec3 localPosVec = Vec3.atCenterOf((Vec3i)localPos);
        OptionalInt id = this.openMenu(player, contraptionEntityId, localPos);
        if (id.isPresent()) {
            Vec3 globalPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
            this.onOpen(level, globalPos);
            return true;
        }
        return false;
    }

    private boolean tryToolInteraction(ItemStack itemInHand) {
        boolean result;
        boolean bl = result = StorageHolderToolHandler.tryStorageToolInteract((ItemStack)itemInHand, (StorageHolderBase)this.getStorageHolder()) == InteractionResult.SUCCESS;
        if (result && StorageToolItem.getMode((ItemStack)itemInHand) == StorageToolItem.Mode.LOCK) {
            this.storageHolder.updateClientBlockRenderAfterNextSync();
            this.storageHolder.sendStorageUpdatePayload();
        }
        return result;
    }

    private boolean tryAddStorageUpgrade(Player player, ItemStack itemInHand) {
        return StorageBlockBase.tryAddSingleUpgrade((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (ItemStack)itemInHand, (IStorageWrapper)this.getStorageWrapper());
    }

    private boolean tryPaintStorage(Player player, ItemStack paintbrush) {
        Item item = this.getStorageStack().getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState state = blockItem.getBlock().defaultBlockState();
        SoundEvent placeSound = state.getSoundType().getPlaceSound();
        boolean painted = PaintbrushItem.paint((Player)player, (ItemStack)paintbrush, (IMaterialHolder)this.getStorageHolder(), (ITintable)this.getStorageWrapper(), (Vec3)this.getStorageHolder().getPosition(), (Direction)Direction.UP, (SoundEvent)placeSound);
        if (painted) {
            this.storageHolder.updateClientBlockRenderAfterNextSync();
            this.storageHolder.sendStorageUpdatePayload();
        }
        return painted;
    }

    private InteractionResult tryStorageTierUpgrade(ServerPlayer player, ItemStack itemInHand, StorageTierUpgradeItem tierUpgradeItem) {
        InteractionResult result = StorageHolderTierUpgradeHandler.upgrade((Player)player, (StorageHolderBase)this.getStorageHolder(), (ItemStack)itemInHand, (StorageTierUpgradeItem)tierUpgradeItem);
        if (result == InteractionResult.SUCCESS) {
            if (this.getStorageStack().getItem() instanceof ChestBlockItem && ChestBlockItem.isDoubleChest((ItemStack)this.getStorageStack())) {
                StorageHolderBase storageHolderBase = this.storageHolder.getMainStorageHolder();
                if (storageHolderBase instanceof MountedStorageHolder) {
                    MountedStorageHolder mainStorageHolder = (MountedStorageHolder)storageHolderBase;
                    mainStorageHolder.updateState();
                }
                this.storageHolder.getAuxiliaryStorageHolder().filter(MountedStorageHolder.class::isInstance).map(MountedStorageHolder.class::cast).ifPresent(MountedStorageHolder::updateState);
            } else {
                this.storageHolder.updateState();
            }
            return InteractionResult.SUCCESS;
        }
        return result;
    }

    public MountedStorageHolder getStorageHolder() {
        return this.storageHolder;
    }

    void initEntityLevelAndPositions(MovementContext context) {
        this.getStorageHolder().initEntityLevelAndPositions(context);
    }

    public void tick(Entity entity) {
        this.getStorageHolder().tick(entity);
    }

    public void clearNbt() {
        this.getStorageHolder().clearNbt();
    }

    protected IItemHandlerModifiable getExternalItemHandler() {
        return this.getStorageHolder().getMainStorageWrapper().getInventoryForInputOutput();
    }

    public OptionalInt openMenu(ServerPlayer player, int contraptionEntityId, BlockPos localPos) {
        return player.openMenu((MenuProvider)new SophisticatedMenuProvider((w, p, pl) -> this.createMenu(w, pl, contraptionEntityId, localPos), this.getStorageStack().getHoverName(), false), buffer -> {
            buffer.writeInt(contraptionEntityId);
            buffer.writeBlockPos(localPos);
        });
    }

    public void setShouldBeOpen(boolean b) {
        this.storageHolder.setShouldBeOpen(b);
    }

    static {
        MountedSophisticatedStorage.registerNbtToComponentMapper(StorageBlockItem.class, new NbtToComponentMapper<Component>("displayName", () -> DataComponents.CUSTOM_NAME, (tag, key, level) -> Component.Serializer.fromJson((String)tag.getString(key), (HolderLookup.Provider)level.registryAccess()), (tag, key, value, level) -> tag.putString(key, Component.Serializer.toJson((Component)value, (HolderLookup.Provider)level.registryAccess()))));
        MountedSophisticatedStorage.registerNbtToComponentMapper(StorageBlockItem.class, new NbtToComponentMapper<Boolean>("locked", ModDataComponents.LOCKED, CompoundTag::getBoolean, CompoundTag::putBoolean));
        MountedSophisticatedStorage.registerNbtToComponentMapper(StorageBlockItem.class, new NbtToComponentMapper<Boolean>("showLock", ModDataComponents.LOCK_VISIBLE, CompoundTag::getBoolean, CompoundTag::putBoolean));
        MountedSophisticatedStorage.registerNbtToComponentMapper(StorageBlockItem.class, new NbtToComponentMapper<Boolean>("showTier", ModDataComponents.SHOWS_TIER, CompoundTag::getBoolean, CompoundTag::putBoolean));
        MountedSophisticatedStorage.registerNbtToComponentMapper(StorageBlockItem.class, new NbtToComponentMapper<Boolean>("showUpgrades", ModDataComponents.UPGRADES_VISIBLE, CompoundTag::getBoolean, CompoundTag::putBoolean));
        MountedSophisticatedStorage.registerNbtToComponentMapper(BarrelBlockItem.class, new NbtToComponentMapper<Boolean>("showCounts", ModDataComponents.COUNTS_VISIBLE, CompoundTag::getBoolean, CompoundTag::putBoolean));
        MountedSophisticatedStorage.registerNbtToComponentMapper(BarrelBlockItem.class, new NbtToComponentMapper<Boolean>("showFillLevels", ModDataComponents.FILL_LEVELS_VISIBLE, CompoundTag::getBoolean, CompoundTag::putBoolean));
        MountedSophisticatedStorage.registerNbtToComponentMapper(BarrelBlockItem.class, new NbtToComponentMapper<Map>("slotColors", ModDataComponents.SLOT_COLORS, (tag, key) -> NBTHelper.getMap((CompoundTag)tag, (String)"slotColors", Integer::valueOf, (tagName, t) -> Optional.of(DyeColor.byId((int)((IntTag)t).getAsInt()))).orElseGet(HashMap::new), (tag, key, value) -> NBTHelper.putMap((CompoundTag)tag, (String)key, (Map)value, String::valueOf, color -> IntTag.valueOf((int)color.getId()))));
        MountedSophisticatedStorage.registerNbtToComponentMapper(WoodStorageBlockItem.class, new NbtToComponentMapper<WoodType>("woodType", ModDataComponents.WOOD_TYPE, (tag, key) -> WoodType.values().filter(wt -> wt.name().equals(tag.getString(key))).findFirst().orElse(WoodType.ACACIA), (tag, key, value) -> tag.putString(key, value.name())));
        MountedSophisticatedStorage.registerNbtToComponentMapper(WoodStorageBlockItem.class, new NbtToComponentMapper<Boolean>("packed", ModDataComponents.PACKED, CompoundTag::getBoolean, CompoundTag::putBoolean));
        MountedSophisticatedStorage.registerNbtToComponentMapper(BarrelBlockItem.class, new NbtToComponentMapper<Map>("materials", ModDataComponents.BARREL_MATERIALS, (tag, key, level) -> NBTHelper.getMap((CompoundTag)tag, (String)key, BarrelMaterial::fromName, (bm, t) -> Optional.of(ResourceLocation.parse((String)t.getAsString()))).orElse(Map.of()), (tag, key, value, level) -> NBTHelper.putMap((CompoundTag)tag, (String)key, (Map)value, BarrelMaterial::getSerializedName, resourceLocation -> StringTag.valueOf((String)resourceLocation.toString()))));
    }

    public record NbtToComponentMapper<T>(String tagName, Supplier<DataComponentType<T>> type, NbtLevelAwareGetter<T> nbtValueGetter, NbtLevelAwareSetter<T> nbtValueSetter) {
        public NbtToComponentMapper(String tagName, Supplier<DataComponentType<T>> type, NbtGetter<T> nbtValueGetter, NbtSetter<T> nbtValueSetter) {
            this(tagName, type, (CompoundTag tag, String key, Level level) -> nbtValueGetter.get(tag, key), (CompoundTag tag, String key, T value, Level level) -> nbtValueSetter.set(tag, key, value));
        }

        public static interface NbtLevelAwareGetter<T> {
            @Nullable
            public T get(CompoundTag var1, String var2, Level var3);
        }

        public static interface NbtLevelAwareSetter<T> {
            public void set(CompoundTag var1, String var2, T var3, Level var4);
        }

        public static interface NbtGetter<T> {
            public T get(CompoundTag var1, String var2);
        }

        public static interface NbtSetter<T> {
            public void set(CompoundTag var1, String var2, T var3);
        }
    }
}

