/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;

public record TransferFullSlotPayload(int slotId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TransferFullSlotPayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getRL("transfer_full_slot"));
    public static final StreamCodec<ByteBuf, TransferFullSlotPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, TransferFullSlotPayload::slotId, TransferFullSlotPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(TransferFullSlotPayload payload, IPayloadContext context) {
        ItemStack transferResult;
        Player player = context.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase storageContainer = (StorageContainerMenuBase)abstractContainerMenu;
        Slot slot = storageContainer.getSlot(payload.slotId);
        while (!(transferResult = storageContainer.quickMoveStack(player, payload.slotId)).isEmpty() && ItemStack.isSameItem((ItemStack)slot.getItem(), (ItemStack)transferResult)) {
        }
    }
}

