/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.pipes.vox_humana;

import com.finchy.pipeorgans.block.Generic;
import com.finchy.pipeorgans.block.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.block.pipes.generic.GenericPipeBlockEntity;
import com.finchy.pipeorgans.block.pipes.generic.ReedBlockEntity;
import com.finchy.pipeorgans.block.pipes.vox_humana.VoxHumanaSoundInstance;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.steamEngine.SteamJetParticleData;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class VoxHumanaBlockEntity
extends ReedBlockEntity {
    @OnlyIn(value=Dist.CLIENT)
    protected VoxHumanaSoundInstance soundInstance;

    public VoxHumanaBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState, (BlockEntityType<? extends GenericPipeBlockEntity>)((BlockEntityType)AllBlockEntities.VOX_HUMANA_BLOCK_ENTITY.get()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickAudio(Generic.WhistleSize size, boolean powered) {
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.fadeOut();
                this.soundInstance = null;
            }
            return;
        }
        float f = (float)Math.pow(2.0, (double)(-this.pitch) / 12.0);
        boolean particle = this.level.getGameTime() % 8L == 0L;
        Vec3 eyePosition = Minecraft.getInstance().cameraEntity.getEyePosition();
        float maxVolume = (float)Mth.clamp((double)((64.0 - eyePosition.distanceTo(Vec3.atCenterOf((Vec3i)this.worldPosition))) / 64.0), (double)0.0, (double)1.0);
        if (this.soundInstance == null || this.soundInstance.isStopped() || this.soundInstance.getOctave() != size) {
            this.soundInstance = new VoxHumanaSoundInstance(size, this.worldPosition);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)this.soundInstance);
            AllSoundEvents.WHISTLE_CHIFF.playAt(this.level, (Vec3i)this.worldPosition, maxVolume * 0.1f, f, false);
            particle = true;
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(f);
        if (!particle) {
            return;
        }
        this.createSteamJet(size);
    }

    @Override
    public void createSteamJet(Generic.WhistleSize size) {
        Direction facing = this.getBlockState().getOptionalValue((Property)GenericPipeBlock.FACING).orElse(Direction.SOUTH);
        float angle = 180.0f + AngleHelper.horizontalAngle((Direction)facing);
        float yOffset = this.pitch == 0 ? 0.125f : 0.0f;
        double yPos = (double)this.pitch / 4.0 + 1.0 + (double)yOffset;
        if (size == Generic.WhistleSize.TINY) {
            size = Generic.WhistleSize.SMALL;
        }
        double zOffset = (double)(0.125f * (float)size.ordinal()) + (this.pitch == 0 ? 0.0 : 0.0625);
        Vec3 v = VecHelper.rotate((Vec3)new Vec3(0.0, yPos, zOffset), (double)angle, (Direction.Axis)Direction.Axis.Y).add(Vec3.atBottomCenterOf((Vec3i)this.worldPosition));
        Vec3 m = VecHelper.rotate((Vec3)new Vec3(0.0, 1.0, 1.0), (double)angle, (Direction.Axis)Direction.Axis.Y);
        this.level.addParticle((ParticleOptions)new SteamJetParticleData(1.0f), v.x, v.y, v.z, m.x, m.y, m.z);
    }
}

