/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.pipes.generic;

import com.finchy.pipeorgans.block.Generic;
import com.finchy.pipeorgans.block.WindchestBlock;
import com.finchy.pipeorgans.block.pipes.generic.GenericExtensionBlock;
import com.finchy.pipeorgans.block.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.block.pipes.generic.GenericSoundInstance;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.steamEngine.SteamJetParticleData;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.lang.ref.WeakReference;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GenericPipeBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public WeakReference<FluidTankBlockEntity> source = new WeakReference<Object>(null);
    public LerpedFloat animation = LerpedFloat.angular();
    protected int pitch;
    protected float steamJetOffset = 0.125f;
    protected GenericPipeBlock pipeBlock;
    @OnlyIn(value=Dist.CLIENT)
    protected GenericSoundInstance soundInstance;

    public GenericPipeBlockEntity(BlockPos pos, BlockState blockState, BlockEntityType<?> blockEntity) {
        super(blockEntity, pos, blockState);
        this.pipeBlock = (GenericPipeBlock)blockState.getBlock();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.putInt("Pitch", this.pitch);
        super.write(tag, registries, clientPacket);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.pitch = tag.getInt("Pitch");
        super.read(tag, registries, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        String[] pitches = CreateLang.translateDirect((String)"generic.notes", (Object[])new Object[0]).getString().split(";");
        CreateLang.translate((String)"generic.pitch", (Object[])new Object[]{pitches[this.pitch % pitches.length]}).forGoggles(tooltip);
        return true;
    }

    protected boolean isPowered() {
        return this.getBlockState().getOptionalValue((Property)GenericPipeBlock.POWERED).orElse(false);
    }

    protected Generic.WhistleSize getOctave() {
        return this.getBlockState().getOptionalValue(GenericPipeBlock.SIZE).orElse(Generic.WhistleSize.MEDIUM);
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide()) {
            if (this.isPowered()) {
                this.award(AllAdvancements.STEAM_WHISTLE);
            }
            return;
        }
        FluidTankBlockEntity tank = this.getTank();
        BlockState state = this.getBlockState();
        BlockPos attachedPos = this.getBlockPos().relative(GenericPipeBlock.getAttachedDirection(state));
        BlockState attachedState = this.level.getBlockState(attachedPos);
        boolean isActive = false;
        Block block = attachedState.getBlock();
        if (block instanceof WindchestBlock) {
            WindchestBlock windchest = (WindchestBlock)block;
            isActive = windchest.isMasterActive(this.level, (Direction)attachedState.getValue((Property)GenericPipeBlock.FACING), attachedPos);
        }
        boolean powered = this.isPowered() ? tank != null && tank.boiler.isActive() && (tank.boiler.passiveHeat || tank.boiler.activeHeat > 0) || this.isVirtual() || isActive : false;
        this.animation.chase(powered ? 1.0 : 0.0, powered ? 0.5 : (double)0.4f, powered ? LerpedFloat.Chaser.EXP : LerpedFloat.Chaser.LINEAR);
        this.animation.tickChaser();
        this.tickAudio(this.getOctave(), powered);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickAudio(Generic.WhistleSize size, boolean powered) {
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.fadeOut();
                this.soundInstance = null;
            }
            return;
        }
        float f = (float)Math.pow(2.0, (double)(-this.pitch) / 12.0);
        boolean particle = this.level.getGameTime() % 8L == 0L;
        Vec3 eyePosition = Minecraft.getInstance().cameraEntity.getEyePosition();
        float maxVolume = (float)Mth.clamp((double)((64.0 - eyePosition.distanceTo(Vec3.atCenterOf((Vec3i)this.worldPosition))) / 64.0), (double)0.0, (double)1.0);
        if (this.soundInstance == null || this.soundInstance.isStopped() || this.soundInstance.getOctave() != size) {
            this.soundInstance = new GenericSoundInstance(size, this.worldPosition, (SoundEvent)com.finchy.pipeorgans.init.AllSoundEvents.TROMPETTE_DEEP.get());
            Minecraft.getInstance().getSoundManager().play((SoundInstance)this.soundInstance);
            AllSoundEvents.WHISTLE_CHIFF.playAt(this.level, (Vec3i)this.worldPosition, maxVolume * 0.1f, size == Generic.WhistleSize.SMALL ? f + 0.75f : f, false);
            particle = true;
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(f);
        if (!particle) {
            return;
        }
        this.createSteamJet(size);
    }

    public void createSteamJet(Generic.WhistleSize size) {
        Direction facing = this.getBlockState().getOptionalValue((Property)GenericPipeBlock.FACING).orElse(Direction.SOUTH);
        float angle = 180.0f + AngleHelper.horizontalAngle((Direction)facing);
        Vec3 sizeOffset = VecHelper.rotate((Vec3)new Vec3(0.0, (double)-0.4f, (double)(0.0625f * (float)size.ordinal())), (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 offset = VecHelper.rotate((Vec3)new Vec3(0.0, 1.0, 0.75), (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 v = offset.scale((double)0.45f).add(sizeOffset).add(Vec3.atCenterOf((Vec3i)this.worldPosition));
        Vec3 m = offset.subtract(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(0.75));
        this.level.addParticle((ParticleOptions)new SteamJetParticleData(1.0f), v.x, v.y, v.z, m.x, m.y, m.z);
    }

    public void updatePitch() {
        BlockState blockState;
        int newPitch;
        BlockPos currentPos = this.worldPosition.above();
        for (newPitch = 0; newPitch <= 12 && (blockState = this.level.getBlockState(currentPos)).getBlock() instanceof GenericExtensionBlock; newPitch += this.pipeBlock.extensionsPerBlock) {
            if (blockState.getValue(GenericExtensionBlock.SHAPE) == Generic.QuadrupleExtensionShape.SINGLE) {
                newPitch += (int)((double)this.pipeBlock.extensionsPerBlock * 0.25);
                break;
            }
            if (blockState.getValue(GenericExtensionBlock.SHAPE) == Generic.QuadrupleExtensionShape.DOUBLE) {
                newPitch += (int)((double)this.pipeBlock.extensionsPerBlock * 0.5);
                break;
            }
            if (blockState.getValue(GenericExtensionBlock.SHAPE) == Generic.QuadrupleExtensionShape.TRIPLE) {
                newPitch += (int)((double)this.pipeBlock.extensionsPerBlock * 0.75);
                break;
            }
            currentPos = currentPos.above();
        }
        if (this.pitch == newPitch) {
            return;
        }
        this.pitch = newPitch;
        this.notifyUpdate();
        FluidTankBlockEntity tank = this.getTank();
        if (tank != null && tank.boiler != null) {
            tank.boiler.checkPipeOrganAdvancement(tank);
        }
    }

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.source.get();
        if (tank == null || tank.isRemoved()) {
            Direction facing;
            BlockEntity be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.level.getBlockEntity(this.worldPosition.relative(facing = GenericPipeBlock.getAttachedDirection(this.getBlockState())))) instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tankBe;
                tank = tankBe = (FluidTankBlockEntity)be;
                this.source = new WeakReference<FluidTankBlockEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerBE();
    }
}

