/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block;

import com.finchy.pipeorgans.PipeOrgans;
import com.finchy.pipeorgans.block.WindchestBlock;
import com.finchy.pipeorgans.block.WindchestMasterBlockEntity;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlock;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class WindchestMasterBlock
extends Block
implements IBE<WindchestMasterBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WINDY = BooleanProperty.create((String)"windy");

    public WindchestMasterBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WINDY, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, POWERED, WINDY});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level level = pContext.getLevel();
        BlockPos clickedPos = pContext.getClickedPos();
        Direction facing = pContext.getHorizontalDirection();
        return (BlockState)((BlockState)super.getStateForPlacement(pContext).setValue((Property)FACING, (Comparable)(pContext.getPlayer().isShiftKeyDown() ? facing.getOpposite() : facing))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(clickedPos)));
    }

    public void updateSlaves(BlockState state, Level level, BlockPos pos, boolean powered) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos currentPos = pos;
        for (int i = 0; i <= 12; ++i) {
            BlockState currentBlock = level.getBlockState(currentPos = currentPos.relative(facing));
            if (!(currentBlock.getBlock() instanceof WindchestBlock) || currentBlock.getValue((Property)FACING) != facing.getOpposite()) {
                return;
            }
            level.setBlock(currentPos, (BlockState)currentBlock.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean isMoving) {
        if (pLevel.isClientSide) {
            return;
        }
        if (pPos.relative((Direction)pState.getValue((Property)FACING)).equals((Object)pNeighborPos)) {
            return;
        }
        PipeOrgans.LOGGER.debug(pNeighborBlock.toString());
        PipeOrgans.LOGGER.debug(pLevel.getBlockState(pNeighborPos).getBlock().toString());
        boolean previouslyPowered = (Boolean)pState.getValue((Property)POWERED);
        boolean powered = false;
        Direction facing = (Direction)pState.getValue((Property)FACING);
        for (Direction i : Direction.values()) {
            if (i == facing || pLevel.getSignal(pPos.relative(i), i) <= 0) continue;
            powered = true;
            break;
        }
        if (previouslyPowered != powered) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
            this.updateSlaves(pState, pLevel, pPos, powered);
        }
        if (pLevel.getBlockState(pNeighborPos).getBlock() instanceof EncasedFanBlock || pNeighborBlock instanceof EncasedFanBlock) {
            WindchestMasterBlock.updateMasterWindy(pLevel, pPos);
        }
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pLevel.isClientSide) {
            return;
        }
        this.updateSlaves(pState, pLevel, pPos, pLevel.hasNeighborSignal(pPos));
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pLevel.isClientSide) {
            return;
        }
        this.updateSlaves(pState, pLevel, pPos, false);
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public static boolean updateMasterWindy(Level level, BlockPos masterPos) {
        if (level.isClientSide) {
            return false;
        }
        int activeFans = 0;
        for (Direction d : Iterate.directions) {
            EncasedFanBlockEntity fanBE;
            BlockState fanState;
            BlockEntity blockEntity = level.getBlockEntity(masterPos.relative(d));
            if (!(blockEntity instanceof EncasedFanBlockEntity) || (fanState = (fanBE = (EncasedFanBlockEntity)blockEntity).getBlockState()).getValue((Property)EncasedFanBlock.FACING) != d.getOpposite() || !(fanBE.getSpeed() * (float)d.getAxisDirection().getStep() < 0.0f)) continue;
            ++activeFans;
        }
        level.setBlock(masterPos, (BlockState)level.getBlockState(masterPos).setValue((Property)WINDY, (Comparable)Boolean.valueOf(activeFans > 0)), 2);
        return activeFans > 0;
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pMirror == Mirror.NONE ? pState : pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public Class<WindchestMasterBlockEntity> getBlockEntityClass() {
        return WindchestMasterBlockEntity.class;
    }

    public BlockEntityType<? extends WindchestMasterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntities.WINDCHEST_MASTER_BLOCK_ENTITY.get();
    }
}

