/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particle_effects.mixin;

import com.leclowndu93150.particle_effects.config.ParticleEffectsConfig;
import com.leclowndu93150.particle_effects.manager.ParticleEffectsManager;
import com.leclowndu93150.particle_effects.utils.ArgbUtils;
import com.leclowndu93150.particle_effects.utils.ListUtils;
import com.leclowndu93150.particle_effects.utils.PEType;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Mixin(value={LevelRenderer.class})
public class WorldRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel level;

    @Inject(method={"levelEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;atBottomCenterOf(Lnet/minecraft/core/Vec3i;)Lnet/minecraft/world/phys/Vec3;")})
    private void modifyParticleEffect(int eventId, BlockPos pos, int data, CallbackInfo ci, @Share(value="tp_effects") LocalRef<List<ParticleOptions>> localParticleEffects) {
        ParticleEffectsManager.processSplashPotionStageOne(localParticleEffects, data);
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZDDDDDD)Lnet/minecraft/client/particle/Particle;", ordinal=0)})
    private Particle swapParticles(LevelRenderer instance, ParticleOptions parameters, boolean alwaysSpawn, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Operation<Particle> original, @Share(value="tp_effects") LocalRef<List<ParticleOptions>> localParticleEffects, @Local(argsOnly=true, ordinal=1) int color) {
        return ParticleEffectsManager.processSplashPotionStageTwo((Level)this.level, instance, parameters, alwaysSpawn, x, y, z, velocityX, velocityY, velocityZ, original, localParticleEffects, color);
    }

    @WrapOperation(method={"addParticle(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;")})
    private Particle swapParticle(LevelRenderer instance, ParticleOptions parameters, boolean alwaysSpawn, boolean canSpawnOnMinimal, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Operation<Particle> original) {
        int color;
        if (!((Boolean)ParticleEffectsConfig.CLIENT.modEnabled.get()).booleanValue()) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        if (parameters instanceof ColorParticleOption) {
            ColorParticleOption effect = (ColorParticleOption)parameters;
            color = effect.color;
        } else {
            MobEffect statusEffect = ParticleEffectsManager.getVanillaStatusEffectByStatusEffect(parameters);
            int n = color = statusEffect == null ? 0 : ArgbUtils.getColorWithoutAlpha(statusEffect.getColor());
        }
        if (color == 0) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        List<ParticleOptions> list = ParticleEffectsManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null || this.level == null) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        ParticleOptions particleEffect = ListUtils.getRandomElement(list, this.level.getRandom());
        if (particleEffect == null) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        ((PEType)particleEffect).particleEffects$setColor(color);
        return (Particle)original.call(new Object[]{instance, particleEffect, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
    }
}

