/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import io.wispforest.owo.mixin.ui.access.BlockEntityAccessor;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.w3c.dom.Element;

public class BlockComponent
extends BaseComponent {
    private final Minecraft client = Minecraft.getInstance();
    private final BlockState state;
    @Nullable
    private final BlockEntity entity;

    protected BlockComponent(BlockState state, @Nullable BlockEntity entity) {
        this.state = state;
        this.entity = entity;
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        context.pose().pushPose();
        context.pose().translate((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, 100.0f);
        context.pose().scale((float)(40 * this.width) / 64.0f, (float)(-40 * this.height) / 64.0f, 40.0f);
        context.pose().mulPose(Axis.XP.rotationDegrees(30.0f));
        context.pose().mulPose(Axis.YP.rotationDegrees(225.0f));
        context.pose().translate(-0.5, -0.5, -0.5);
        RenderSystem.runAsFancy(() -> {
            BlockEntityRenderer \u043c\u0435\u0434\u0432\u0435\u0434\u044c;
            MultiBufferSource.BufferSource vertexConsumers = this.client.renderBuffers().bufferSource();
            if (this.state.getRenderShape() != RenderShape.ENTITYBLOCK_ANIMATED) {
                this.client.getBlockRenderer().renderSingleBlock(this.state, context.pose(), (MultiBufferSource)vertexConsumers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            if (this.entity != null && (\u043c\u0435\u0434\u0432\u0435\u0434\u044c = this.client.getBlockEntityRenderDispatcher().getRenderer(this.entity)) != null) {
                \u043c\u0435\u0434\u0432\u0435\u0434\u044c.render(this.entity, partialTicks, context.pose(), (MultiBufferSource)vertexConsumers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            RenderSystem.setShaderLights((Vector3f)new Vector3f(-1.5f, -0.5f, 0.0f), (Vector3f)new Vector3f(0.0f, -1.0f, 0.0f));
            vertexConsumers.endBatch();
            Lighting.setupFor3DItems();
        });
        context.pose().popPose();
    }

    protected static void prepareBlockEntity(BlockState state, BlockEntity blockEntity, @Nullable CompoundTag nbt) {
        if (blockEntity == null) {
            return;
        }
        ClientLevel world = Minecraft.getInstance().level;
        ((BlockEntityAccessor)blockEntity).owo$setCachedState(state);
        blockEntity.setLevel((Level)world);
        if (nbt == null) {
            return;
        }
        CompoundTag nbtCopy = nbt.copy();
        nbtCopy.putInt("x", 0);
        nbtCopy.putInt("y", 0);
        nbtCopy.putInt("z", 0);
        blockEntity.loadWithComponents(nbtCopy, (HolderLookup.Provider)world.registryAccess());
    }

    public static BlockComponent parse(Element element) {
        UIParsing.expectAttributes(element, "state");
        try {
            BlockStateParser.BlockResult result = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)element.getAttribute("state"), (boolean)true);
            return Components.block(result.blockState(), result.nbt());
        }
        catch (CommandSyntaxException cse) {
            throw new UIModelParsingException("Invalid block state", cse);
        }
    }
}

