/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.neoforge.SoftFluidStackImpl;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionBottleType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftFluidStack
implements DataComponentHolder {
    public static final Codec<SoftFluidStack> CODEC = RecordCodecBuilder.create(i -> i.group((App)SoftFluid.HOLDER_CODEC.fieldOf("id").forGetter(SoftFluidStack::getHolder), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("count", (Object)1).forGetter(SoftFluidStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(stack -> stack.components.asPatch())).apply((Applicative)i, SoftFluidStack::of));
    public static final StreamCodec<RegistryFriendlyByteBuf, SoftFluidStack> STREAM_CODEC = StreamCodec.composite(SoftFluid.STREAM_CODEC, SoftFluidStack::getHolder, (StreamCodec)ByteBufCodecs.VAR_INT, SoftFluidStack::getCount, (StreamCodec)DataComponentPatch.STREAM_CODEC, s -> s.components.asPatch(), SoftFluidStack::of);
    private final Holder<SoftFluid> fluidHolder;
    private final SoftFluid fluid;
    private int count;
    @NotNull
    private final PatchedDataComponentMap components;
    private boolean isEmptyCache;
    private final Holder<SoftFluid> myEmptyFluid;

    protected SoftFluidStack(Holder<SoftFluid> fluid, int count, DataComponentPatch components) {
        this.fluidHolder = fluid;
        if (components == null) {
            Moonlight.LOGGER.error("Some mod passed a null components, fix me");
            components = DataComponentPatch.EMPTY;
        }
        this.fluid = (SoftFluid)this.fluidHolder.value();
        this.components = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)Objects.requireNonNull(components, "component map cant be null"));
        this.count = count;
        this.updateEmpty();
        this.myEmptyFluid = this.haxFindEmpty(this.fluidHolder);
    }

    private Holder<SoftFluid> haxFindEmpty(Holder<SoftFluid> fluidHolder) {
        HolderLookup.RegistryLookup<SoftFluid> ra = Utils.hackyFindRegistryOf(fluidHolder, SoftFluidRegistry.KEY);
        return MLBuiltinSoftFluids.EMPTY.lookup((HolderGetter<SoftFluid>)ra);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SoftFluidStack of(Holder<SoftFluid> fluid, int count, @NotNull DataComponentPatch tag) {
        void var2_2;
        void var1_1;
        return SoftFluidStackImpl.of(fluid, (int)var1_1, (DataComponentPatch)var2_2);
    }

    public static SoftFluidStack of(Holder<SoftFluid> fluid, int count) {
        return SoftFluidStack.of(fluid, count, DataComponentPatch.EMPTY);
    }

    public static SoftFluidStack of(Holder<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, 1);
    }

    public static SoftFluidStack bucket(Holder<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BUCKET_COUNT);
    }

    public static SoftFluidStack bowl(Holder<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BOWL_COUNT);
    }

    public static SoftFluidStack bottle(Holder<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BOTTLE_COUNT);
    }

    public static SoftFluidStack fromFluid(Fluid fluid, int amount) {
        return SoftFluidStack.fromFluid(fluid, amount, DataComponentPatch.EMPTY);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static SoftFluidStack fromFluid(Fluid fluid, int amount, @NotNull DataComponentPatch component) {
        RegistryAccess reg = Utils.hackyGetRegistryAccess();
        return SoftFluidStack.fromFluid(fluid, amount, component, (HolderLookup.Provider)reg);
    }

    @NotNull
    public static SoftFluidStack fromFluid(Fluid fluid, int amount, @NotNull DataComponentPatch component, HolderLookup.Provider reg) {
        Holder<SoftFluid> f = SoftFluidInternal.fromVanillaFluid(fluid, reg);
        if (f == null) {
            return SoftFluidStack.empty(reg);
        }
        return SoftFluidStack.of(f, amount, component);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static SoftFluidStack fromFluid(FluidState fluid) {
        return SoftFluidStack.fromFluid(fluid, (HolderLookup.Provider)Utils.hackyGetRegistryAccess());
    }

    @NotNull
    public static SoftFluidStack fromFluid(FluidState fluid, HolderLookup.Provider reg) {
        if (fluid.is(FluidTags.WATER)) {
            return SoftFluidStack.fromFluid(fluid.getType(), 3, DataComponentPatch.EMPTY, reg);
        }
        return SoftFluidStack.fromFluid(fluid.getType(), SoftFluid.BUCKET_COUNT, DataComponentPatch.EMPTY, reg);
    }

    @Deprecated(forRemoval=true)
    public static SoftFluidStack empty() {
        return SoftFluidStack.of(SoftFluidRegistry.hackyGetEmpty(), 0);
    }

    public static SoftFluidStack empty(HolderLookup.Provider lookupProvider) {
        return SoftFluidStack.of(SoftFluidRegistry.getEmpty(lookupProvider), 0);
    }

    public static SoftFluidStack empty(HolderGetter<SoftFluid> reg) {
        return SoftFluidStack.of(SoftFluidRegistry.getEmpty(reg), 0);
    }

    public Component getDisplayName() {
        if (MLBuiltinSoftFluids.POTION.is(this.fluidHolder)) {
            PotionBottleType bottle = PotionBottleType.getOrDefault(this);
            return bottle.getTranslatedName();
        }
        return this.fluid().getTranslatedName();
    }

    public Tag save(HolderLookup.Provider lookupProvider) {
        DataResult a = CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this);
        if (a.isSuccess()) {
            return (Tag)a.getOrThrow();
        }
        Moonlight.LOGGER.error("Failed to encode fluid stack. HOW??, {}", a.error().get());
        if (PlatHelper.isDev()) {
            a.getOrThrow();
        }
        return new CompoundTag();
    }

    public static SoftFluidStack load(HolderLookup.Provider lookupProvider, Tag tag) {
        return (SoftFluidStack)CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow();
    }

    public boolean is(HolderReference<SoftFluid> fluid) {
        return fluid.is(this.fluidHolder);
    }

    public boolean is(TagKey<SoftFluid> tag) {
        return this.getHolder().is(tag);
    }

    public boolean is(ResourceKey<SoftFluid> location) {
        return this.getHolder().is(location);
    }

    @Deprecated(forRemoval=true)
    public boolean is(SoftFluid fluid) {
        return this.fluid() == fluid;
    }

    public boolean is(Holder<SoftFluid> fluid) {
        return fluid == this.fluidHolder || fluid.is(this.fluidKey());
    }

    @Deprecated(forRemoval=true)
    private Holder<SoftFluid> getFluid() {
        return this.isEmptyCache ? this.myEmptyFluid : this.fluidHolder;
    }

    public final Holder<SoftFluid> getHolder() {
        return this.isEmptyCache ? this.myEmptyFluid : this.fluidHolder;
    }

    public final SoftFluid fluid() {
        return this.isEmptyCache ? (SoftFluid)this.myEmptyFluid.value() : this.fluid;
    }

    public final ResourceKey<SoftFluid> fluidKey() {
        return (ResourceKey)this.getHolder().unwrapKey().get();
    }

    public boolean isEmpty() {
        return this.isEmptyCache;
    }

    protected void updateEmpty() {
        this.isEmptyCache = this.count <= 0 || MLBuiltinSoftFluids.EMPTY.is(this.fluidHolder);
    }

    public int getCount() {
        return this.isEmptyCache ? 0 : this.count;
    }

    public void setCount(int count) {
        if (MLBuiltinSoftFluids.EMPTY.is(this.fluidHolder)) {
            if (PlatHelper.isDev()) {
                throw new AssertionError();
            }
            return;
        }
        this.count = count;
        this.updateEmpty();
    }

    public void grow(int amount) {
        this.setCount(this.count + amount);
    }

    public void shrink(int amount) {
        this.setCount(this.count - amount);
    }

    public void consume(int amount, @Nullable LivingEntity entity) {
        if (entity == null || !entity.hasInfiniteMaterials()) {
            this.shrink(amount);
        }
    }

    public SoftFluidStack copy() {
        return SoftFluidStack.of(this.getHolder(), this.count, this.components.copy().asPatch());
    }

    public SoftFluidStack copyWithCount(int count) {
        SoftFluidStack stack = this.copy();
        if (!stack.isEmpty()) {
            stack.setCount(count);
        }
        return stack;
    }

    public SoftFluidStack split(int amount) {
        int i = Math.min(amount, this.getCount());
        SoftFluidStack stack = this.copyWithCount(i);
        if (!this.isEmpty()) {
            this.shrink(i);
        }
        return stack;
    }

    public boolean isSameFluidSameComponents(SoftFluidStack other) {
        if (!this.is(other.getHolder())) {
            return false;
        }
        return this.isEmpty() && other.isEmpty() || Objects.equals(this.components, other.components);
    }

    public static int hashFluidAndComponents(@Nullable SoftFluidStack stack) {
        if (stack != null) {
            int i = 31 + stack.getHolder().hashCode();
            return 31 * i + stack.getComponents().hashCode();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftFluidStack)) {
            return false;
        }
        SoftFluidStack that = (SoftFluidStack)o;
        return this.count == that.count && Objects.equals(this.fluidHolder.unwrapKey(), that.fluidHolder.unwrapKey()) && Objects.equals(this.components, that.components);
    }

    public int hashCode() {
        return Objects.hash(this.fluidHolder.unwrapKey(), this.count, this.components);
    }

    public String toString() {
        return this.getCount() + " " + String.valueOf(this.getHolder());
    }

    @Deprecated(forRemoval=true)
    public static Pair<SoftFluidStack, FluidContainerList.Category> fromItem(ItemStack itemStack) {
        return SoftFluidStack.fromItem(itemStack, (HolderLookup.Provider)Utils.hackyGetRegistryAccess());
    }

    @Nullable
    public static Pair<SoftFluidStack, FluidContainerList.Category> fromItem(ItemStack itemStack, HolderLookup.Provider reg) {
        Optional<FluidContainerList.Category> category;
        Item filledContainer = itemStack.getItem();
        Holder<SoftFluid> fluid = SoftFluidInternal.fromVanillaItem(filledContainer, reg);
        if (fluid != null && !MLBuiltinSoftFluids.EMPTY.is(fluid) && (category = ((SoftFluid)fluid.value()).getContainerList().getCategoryFromFilled(filledContainer)).isPresent()) {
            int count = category.get().getCapacity();
            DataComponentPatch.Builder fluidComponents = DataComponentPatch.builder();
            PotionContents potion = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            if (potion.is(Potions.WATER)) {
                fluid = MLBuiltinSoftFluids.WATER.getHolder(reg);
            } else if (potion.hasEffects()) {
                PotionBottleType bottleType = PotionBottleType.getOrDefault(filledContainer);
                fluidComponents.set(MoonlightRegistry.BOTTLE_TYPE.get(), (Object)bottleType);
            }
            SoftFluidStack sfStack = SoftFluidStack.of(fluid, count, fluidComponents.build());
            SoftFluidStack.copyComponentsTo((DataComponentHolder)itemStack, sfStack, ((SoftFluid)fluid.value()).getPreservedComponents());
            return Pair.of((Object)sfStack, (Object)category.get());
        }
        return null;
    }

    public Pair<ItemStack, FluidContainerList.Category> splitToItem(ItemStack emptyContainer) {
        Pair<ItemStack, FluidContainerList.Category> r = this.toItem(emptyContainer);
        if (r != null) {
            this.shrink(((FluidContainerList.Category)r.getSecond()).getCapacity());
        }
        return r;
    }

    @Deprecated(forRemoval=true)
    public Pair<ItemStack, FluidContainerList.Category> toItem(ItemStack emptyContainer, boolean dontModifyStack) {
        Pair<ItemStack, FluidContainerList.Category> r = this.toItem(emptyContainer);
        if (r != null && !dontModifyStack) {
            this.shrink(((FluidContainerList.Category)r.getSecond()).getCapacity());
        }
        return r;
    }

    @Nullable
    public Pair<ItemStack, FluidContainerList.Category> toItem(ItemStack emptyContainer) {
        FluidContainerList.Category category;
        ItemStack[] filledStacks;
        Optional<FluidContainerList.Category> opt = this.fluid().getContainerList().getCategoryFromEmpty(emptyContainer.getItem());
        if (opt.isPresent() && (filledStacks = this.createFilledStacks(category = opt.get(), true)).length != 0) {
            return Pair.of((Object)filledStacks[0], (Object)category);
        }
        return null;
    }

    public Multimap<FluidContainerList.Category, ItemStack> toAllPossibleFilledItems() {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (FluidContainerList.Category category : this.fluid().getContainerList()) {
            for (ItemStack filled : this.createFilledStacks(category, false)) {
                result.put((Object)category, (Object)filled);
            }
        }
        return result;
    }

    private ItemStack[] createFilledStacks(FluidContainerList.Category category, boolean onlyFirst) {
        int shrinkAmount = category.getCapacity();
        if (shrinkAmount > this.getCount()) {
            return new ItemStack[0];
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (ItemLike itemLike : category.getFilledItems()) {
            ItemStack filledStack = new ItemStack(itemLike);
            if (category.getEmptyContainer() == Items.GLASS_BOTTLE && this.is(MLBuiltinSoftFluids.POTION)) {
                PotionBottleType type = PotionBottleType.getOrDefault(this);
                filledStack = type.getDefaultItem();
            }
            if (category.getEmptyContainer() == Items.GLASS_BOTTLE && this.is(MLBuiltinSoftFluids.WATER)) {
                filledStack = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
            }
            this.copyComponentsTo((DataComponentHolder)filledStack);
            results.add(filledStack);
            if (!onlyFirst) continue;
            break;
        }
        return results.toArray(new ItemStack[0]);
    }

    public void copyComponentsTo(DataComponentHolder to) {
        SoftFluidStack.copyComponentsTo(this, to, this.fluid.getPreservedComponents());
    }

    protected static void copyComponentsTo(DataComponentHolder from, DataComponentHolder to, HolderSet<DataComponentType<?>> types) {
        for (Holder h : types) {
            DataComponentType type = (DataComponentType)h.value();
            SoftFluidStack.copyComponentTo(from, to, type);
        }
    }

    private static <A> void copyComponentTo(DataComponentHolder from, DataComponentHolder to, DataComponentType<A> comp) {
        Object componentValue = from.get(comp);
        if (componentValue != null) {
            if (to instanceof ItemStack) {
                ItemStack is = (ItemStack)to;
                is.set(comp, componentValue);
            } else if (to instanceof SoftFluidStack) {
                SoftFluidStack sf = (SoftFluidStack)to;
                sf.set(comp, componentValue);
            } else {
                PlatHelper.setComponent(to, comp, componentValue);
            }
        }
    }

    public FluidContainerList getContainerList() {
        return this.fluid().getContainerList();
    }

    public FoodProvider getFoodProvider() {
        return this.fluid().getFoodProvider();
    }

    public boolean isEquivalent(Holder<Fluid> fluid) {
        return this.isEquivalent(fluid, DataComponentPatch.EMPTY);
    }

    public boolean isEquivalent(Holder<Fluid> fluid, DataComponentPatch componentPatch) {
        return this.fluid().isEquivalent(fluid) && Objects.equals(this.components.asPatch(), componentPatch);
    }

    public Holder<Fluid> getVanillaFluid() {
        return this.fluid().getVanillaFluid();
    }

    public int getStillColor(@Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        SoftFluid fluid = this.fluid();
        SoftFluid.TintMethod method = fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.NO_TINT) {
            return -1;
        }
        int specialColor = SoftFluidColors.getSpecialColor(this, world, pos);
        if (specialColor != 0) {
            return specialColor;
        }
        return fluid.getTintColor();
    }

    public int getFlowingColor(@Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        SoftFluid.TintMethod method = this.fluid().getTintMethod();
        if (method == SoftFluid.TintMethod.FLOWING) {
            return this.getParticleColor(world, pos);
        }
        return this.getStillColor(world, pos);
    }

    public int getParticleColor(@Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        int tintColor = this.getStillColor(world, pos);
        if (tintColor == -1) {
            return this.fluid().getAverageTextureTintColor();
        }
        return tintColor;
    }

    @NotNull
    public PatchedDataComponentMap getComponents() {
        return this.components;
    }

    @Nullable
    public <T> T set(DataComponentType<? super T> type, @Nullable T component) {
        return (T)this.components.set(type, component);
    }
}

