/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.game.wrap.NbtWrap;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;

public class NbtUtils {
    @Nullable
    public static UUID readUUID(@Nonnull CompoundTag tag) {
        return NbtUtils.readUUID(tag, "UUIDM", "UUIDL");
    }

    @Nullable
    public static UUID readUUID(@Nonnull CompoundTag tag, String keyM, String keyL) {
        if (NbtWrap.containsLong(tag, keyM) && NbtWrap.containsLong(tag, keyL)) {
            return new UUID(NbtWrap.getLong(tag, keyM), NbtWrap.getLong(tag, keyL));
        }
        return null;
    }

    public static void writeUUID(@Nonnull CompoundTag tag, UUID uuid) {
        NbtUtils.writeUUID(tag, uuid, "UUIDM", "UUIDL");
    }

    public static void writeUUID(@Nonnull CompoundTag tag, UUID uuid, String keyM, String keyL) {
        NbtWrap.putLong(tag, keyM, uuid.getMostSignificantBits());
        NbtWrap.putLong(tag, keyL, uuid.getLeastSignificantBits());
    }

    public static CompoundTag getOrCreateCompound(@Nonnull CompoundTag tagIn, String tagName) {
        CompoundTag nbt;
        if (NbtWrap.containsCompound(tagIn, tagName)) {
            nbt = NbtWrap.getCompound(tagIn, tagName);
        } else {
            nbt = new CompoundTag();
            NbtWrap.putTag(tagIn, tagName, (Tag)nbt);
        }
        return nbt;
    }

    public static <T> ListTag asListTag(Collection<T> values, Function<T, Tag> tagFactory) {
        ListTag list = new ListTag();
        for (T val : values) {
            NbtWrap.addTag(list, tagFactory.apply(val));
        }
        return list;
    }

    @Nonnull
    public static CompoundTag createBlockPos(@Nonnull BlockPos pos) {
        return NbtUtils.writeBlockPos(pos, new CompoundTag());
    }

    @Nonnull
    public static CompoundTag createBlockPosTag(@Nonnull BlockPos pos) {
        return NbtUtils.writeBlockPos(pos, new CompoundTag());
    }

    @Nonnull
    public static CompoundTag createBlockPosTag(@Nonnull Vec3i pos) {
        return NbtUtils.putVec3i(new CompoundTag(), pos);
    }

    @Nonnull
    public static CompoundTag createVec3iTag(@Nonnull Vec3i pos) {
        return NbtUtils.putVec3i(new CompoundTag(), pos);
    }

    @Nonnull
    public static CompoundTag createVec3iToArray(@Nonnull Vec3i pos, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, new CompoundTag(), tagName);
    }

    @Nonnull
    public static CompoundTag createVec3iToArrayTag(@Nonnull Vec3i pos, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, new CompoundTag(), tagName);
    }

    @Nonnull
    public static CompoundTag createEntityPosition(@Nonnull Vec3 pos) {
        return NbtUtils.createEntityPositionToTag(pos);
    }

    @Nonnull
    public static CompoundTag createEntityPositionToTag(@Nonnull Vec3 pos) {
        return NbtUtils.writeVec3dToListTag(pos, new CompoundTag(), "Pos");
    }

    @Nonnull
    public static CompoundTag putVec3i(@Nonnull CompoundTag tag, @Nonnull Vec3i pos) {
        NbtWrap.putInt(tag, "x", pos.getX());
        NbtWrap.putInt(tag, "y", pos.getY());
        NbtWrap.putInt(tag, "z", pos.getZ());
        return tag;
    }

    @Nonnull
    public static CompoundTag writeBlockPosToTag(@Nonnull BlockPos pos, @Nonnull CompoundTag tag) {
        return NbtUtils.writeBlockPos(pos, tag);
    }

    @Nonnull
    public static CompoundTag writeBlockPos(@Nonnull BlockPos pos, @Nonnull CompoundTag tag) {
        NbtWrap.putInt(tag, "x", pos.getX());
        NbtWrap.putInt(tag, "y", pos.getY());
        NbtWrap.putInt(tag, "z", pos.getZ());
        return tag;
    }

    @Nonnull
    public static CompoundTag writeBlockPosToListTag(@Nonnull Vec3i pos, @Nonnull CompoundTag tag, String tagName) {
        ListTag tagList = new ListTag();
        NbtWrap.addTag(tagList, (Tag)NbtWrap.asIntTag(pos.getX()));
        NbtWrap.addTag(tagList, (Tag)NbtWrap.asIntTag(pos.getY()));
        NbtWrap.addTag(tagList, (Tag)NbtWrap.asIntTag(pos.getZ()));
        NbtWrap.putTag(tag, tagName, (Tag)tagList);
        return tag;
    }

    @Nonnull
    public static CompoundTag writeVec3iToArray(@Nonnull Vec3i pos, @Nonnull CompoundTag tag, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, tag, tagName);
    }

    @Nonnull
    public static CompoundTag writeVec3iToArrayTag(@Nonnull Vec3i pos, @Nonnull CompoundTag tag, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, tag, tagName);
    }

    @Nonnull
    public static CompoundTag writeBlockPosToArrayTag(@Nonnull Vec3i pos, @Nonnull CompoundTag tag, String tagName) {
        int[] arr = new int[]{pos.getX(), pos.getY(), pos.getZ()};
        NbtWrap.putIntArray(tag, tagName, arr);
        return tag;
    }

    @Nullable
    public static BlockPos readBlockPos(@Nullable CompoundTag tag) {
        if (tag != null && NbtWrap.containsInt(tag, "x") && NbtWrap.containsInt(tag, "y") && NbtWrap.containsInt(tag, "z")) {
            return new BlockPos(NbtWrap.getInt(tag, "x"), NbtWrap.getInt(tag, "y"), NbtWrap.getInt(tag, "z"));
        }
        return null;
    }

    @Nullable
    public static Vec3i readVec3i(@Nullable CompoundTag tag) {
        return NbtUtils.readVec3iFromTag(tag);
    }

    @Nullable
    public static Vec3i readVec3iFromTag(@Nullable CompoundTag tag) {
        if (tag != null && NbtWrap.containsInt(tag, "x") && NbtWrap.containsInt(tag, "y") && NbtWrap.containsInt(tag, "z")) {
            return new Vec3i(NbtWrap.getInt(tag, "x"), NbtWrap.getInt(tag, "y"), NbtWrap.getInt(tag, "z"));
        }
        return null;
    }

    @Nullable
    public static BlockPos readBlockPosFromListTag(@Nonnull CompoundTag tag, String tagName) {
        ListTag tagList;
        if (NbtWrap.containsList(tag, tagName) && NbtWrap.getListSize(tagList = NbtWrap.getList(tag, tagName, 3)) == 3) {
            return new BlockPos(NbtWrap.getIntAt(tagList, 0), NbtWrap.getIntAt(tagList, 1), NbtWrap.getIntAt(tagList, 2));
        }
        return null;
    }

    @Nullable
    public static BlockPos readBlockPosFromIntArray(@Nonnull CompoundTag nbt, String key) {
        return NbtUtils.readBlockPosFromArrayTag(nbt, key);
    }

    @Nullable
    public static BlockPos readBlockPosFromArrayTag(@Nonnull CompoundTag tag, String tagName) {
        int[] pos;
        if (NbtWrap.containsIntArray(tag, tagName) && (pos = NbtWrap.getIntArray(tag, tagName)).length == 3) {
            return new BlockPos(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nullable
    public static Vec3i readVec3iFromIntArray(@Nonnull CompoundTag nbt, String key) {
        return NbtUtils.readVec3iFromIntArrayTag(nbt, key);
    }

    @Nullable
    public static Vec3i readVec3iFromIntArrayTag(@Nonnull CompoundTag tag, String tagName) {
        int[] pos;
        if (NbtWrap.containsIntArray(tag, tagName) && (pos = NbtWrap.getIntArray(tag, tagName)).length == 3) {
            return new Vec3i(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nonnull
    public static CompoundTag removeBlockPos(@Nonnull CompoundTag tag) {
        return NbtUtils.removeBlockPosFromTag(tag);
    }

    @Nonnull
    public static CompoundTag removeBlockPosFromTag(@Nonnull CompoundTag tag) {
        NbtWrap.remove(tag, "x");
        NbtWrap.remove(tag, "y");
        NbtWrap.remove(tag, "z");
        return tag;
    }

    @Nonnull
    public static CompoundTag writeEntityPosition(@Nonnull Vec3 pos, @Nonnull CompoundTag tag) {
        return NbtUtils.writeVec3dToListTag(pos, tag, "Pos");
    }

    @Nonnull
    public static CompoundTag writeEntityPositionToTag(@Nonnull Vec3 pos, @Nonnull CompoundTag tag) {
        return NbtUtils.writeVec3dToListTag(pos, tag, "Pos");
    }

    @Nonnull
    public static CompoundTag writeVec3dToListTag(@Nonnull Vec3 pos, @Nonnull CompoundTag tag) {
        return NbtUtils.writeVec3dToListTag(pos, tag, "Pos");
    }

    @Nonnull
    public static CompoundTag writeVec3dToListTag(@Nonnull Vec3 pos, @Nonnull CompoundTag tag, String tagName) {
        ListTag posList = new ListTag();
        NbtWrap.addTag(posList, (Tag)NbtWrap.asDoubleTag(pos.x));
        NbtWrap.addTag(posList, (Tag)NbtWrap.asDoubleTag(pos.y));
        NbtWrap.addTag(posList, (Tag)NbtWrap.asDoubleTag(pos.z));
        NbtWrap.putTag(tag, tagName, (Tag)posList);
        return tag;
    }

    @Nullable
    public static Vec3 readVec3d(@Nullable CompoundTag tag) {
        if (tag != null && NbtWrap.containsDouble(tag, "dx") && NbtWrap.containsDouble(tag, "dy") && NbtWrap.containsDouble(tag, "dz")) {
            return new Vec3(NbtWrap.getDouble(tag, "dx"), NbtWrap.getDouble(tag, "dy"), NbtWrap.getDouble(tag, "dz"));
        }
        return null;
    }

    @Nullable
    public static Vec3 readVec3dFromListTag(@Nullable CompoundTag tag) {
        return NbtUtils.readVec3dFromListTag(tag, "Pos");
    }

    @Nullable
    public static Vec3 readEntityPositionFromTag(@Nullable CompoundTag tag) {
        return NbtUtils.readVec3dFromListTag(tag, "Pos");
    }

    @Nullable
    public static Vec3 readVec3dFromListTag(@Nullable CompoundTag tag, String tagName) {
        ListTag tagList;
        if (tag != null && NbtWrap.containsList(tag, tagName) && NbtWrap.getListStoredType(tagList = NbtWrap.getList(tag, tagName, 6)) == 6 && NbtWrap.getListSize(tagList) == 3) {
            return new Vec3(NbtWrap.getDoubleAt(tagList, 0), NbtWrap.getDoubleAt(tagList, 1), NbtWrap.getDoubleAt(tagList, 2));
        }
        return null;
    }

    @Nullable
    public static BlockPos readAttachedPosFromTag(@Nonnull CompoundTag tag) {
        if (tag.contains("TileX", 3) && tag.contains("TileY", 3) && tag.contains("TileZ", 3)) {
            return new BlockPos(tag.getInt("TileX"), tag.getInt("TileY"), tag.getInt("TileZ"));
        }
        return null;
    }

    @Nonnull
    public static CompoundTag writeAttachedPosToTag(@Nonnull BlockPos pos, @Nonnull CompoundTag tag) {
        tag.putInt("TileX", pos.getX());
        tag.putInt("TileY", pos.getY());
        tag.putInt("TileZ", pos.getZ());
        return tag;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static CompoundTag readNbtFromFile(@Nonnull File file) {
        return NbtUtils.readNbtFromFile(file, NbtAccounter.unlimitedHeap());
    }

    @Nullable
    public static CompoundTag readNbtFromFileAsPath(@Nonnull Path file) {
        return NbtUtils.readNbtFromFileAsPath(file, NbtAccounter.unlimitedHeap());
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static CompoundTag readNbtFromFile(@Nonnull File file, NbtAccounter tracker) {
        FileInputStream is;
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        try {
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("readNbtFromFile: Failed to read NBT data from file '{}' (failed to create the input stream)", (Object)file.getAbsolutePath());
            return null;
        }
        CompoundTag nbt = null;
        if (is != null) {
            try {
                nbt = NbtIo.readCompressed((InputStream)is, (NbtAccounter)tracker);
            }
            catch (Exception e) {
                try {
                    is.close();
                    is = new FileInputStream(file);
                    nbt = NbtIo.read((Path)file.toPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (nbt == null) {
            MaLiLib.LOGGER.warn("readNbtFromFile: Failed to read NBT data from file '{}'", (Object)file.getAbsolutePath());
        }
        return nbt;
    }

    @Nullable
    public static CompoundTag readNbtFromFileAsPath(@Nonnull Path file, NbtAccounter tracker) {
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return null;
        }
        try {
            return NbtIo.readCompressed((InputStream)Files.newInputStream(file, new OpenOption[0]), (NbtAccounter)tracker);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("readNbtFromFileAsPath: Failed to read NBT data from file '{}'", (Object)file.toString());
            return null;
        }
    }

    public static void writeCompressed(@Nonnull CompoundTag tag, @Nonnull OutputStream outputStream) {
        try {
            NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)outputStream);
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("writeCompressed: Failed to write NBT data to output stream");
        }
    }

    public static void writeCompressed(@Nonnull CompoundTag tag, @Nonnull Path file) {
        try {
            NbtIo.writeCompressed((CompoundTag)tag, (Path)file);
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("writeCompressed: Failed to write NBT data to file");
        }
    }
}

