/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.apache.commons.lang3.tuple.Pair;

public class NbtBlockUtils {
    @Nullable
    public static BlockEntityType<?> getBlockEntityTypeFromNbt(@Nonnull CompoundTag nbt) {
        Holder entry;
        if (nbt.contains("id", 8) && (entry = (Holder)BuiltInRegistries.BLOCK_ENTITY_TYPE.getHolder(ResourceLocation.tryParse((String)nbt.getString("id"))).orElse(null)) != null && entry.isBound()) {
            return (BlockEntityType)entry.value();
        }
        return null;
    }

    public static CompoundTag setBlockEntityTypeToNbt(BlockEntityType<?> type, @Nullable CompoundTag nbtIn) {
        CompoundTag nbt = new CompoundTag();
        ResourceLocation id = BlockEntityType.getKey(type);
        if (id != null) {
            if (nbtIn != null) {
                nbtIn.putString("id", id.toString());
                return nbtIn;
            }
            nbt.putString("id", id.toString());
        }
        return nbt;
    }

    public static Set<Integer> getDisabledSlotsFromNbt(@Nonnull CompoundTag nbt) {
        HashSet<Integer> list = new HashSet<Integer>();
        if (nbt.contains("disabled_slots", 11)) {
            int[] is;
            for (int j : is = nbt.getIntArray("disabled_slots")) {
                list.add(j);
            }
        }
        return list;
    }

    public static Pair<Holder<MobEffect>, Holder<MobEffect>> getBeaconEffectsFromNbt(@Nonnull CompoundTag nbt) {
        ResourceLocation id;
        Holder primary = null;
        Holder secondary = null;
        if (nbt.contains("primary_effect", 8) && (id = ResourceLocation.tryParse((String)nbt.getString("primary_effect"))) != null) {
            primary = BuiltInRegistries.MOB_EFFECT.getHolder(id).orElse(null);
        }
        if (nbt.contains("secondary_effect", 8) && (id = ResourceLocation.tryParse((String)nbt.getString("secondary_effect"))) != null) {
            secondary = BuiltInRegistries.MOB_EFFECT.getHolder(id).orElse(null);
        }
        return Pair.of(primary, secondary);
    }

    public static Pair<List<BeehiveBlockEntity.Occupant>, BlockPos> getBeesDataFromNbt(@Nonnull CompoundTag nbt) {
        ArrayList bees = new ArrayList();
        BlockPos flower = BlockPos.ZERO;
        if (nbt.contains("bees")) {
            BeehiveBlockEntity.Occupant.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("bees")).resultOrPartial().ifPresent(bees::addAll);
        }
        if (nbt.contains("flower_pos", 11)) {
            flower = NbtUtils.readBlockPosFromIntArray(nbt, "flower_pos");
        }
        return Pair.of(bees, (Object)flower);
    }

    public static Pair<Integer, VibrationSystem.Data> getSkulkSensorVibrationsFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        AtomicReference<Object> data = new AtomicReference<Object>(null);
        int lastFreq = -1;
        if (nbt.contains("last_vibration_frequency", 3)) {
            lastFreq = nbt.getInt("last_vibration_frequency");
        }
        if (nbt.contains("listener", 10)) {
            VibrationSystem.Data.CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.getCompound("listener")).resultOrPartial().ifPresent(data::set);
        }
        return Pair.of((Object)lastFreq, (Object)data.get());
    }

    public static Pair<Long, BlockPos> getExitPortalFromNbt(@Nonnull CompoundTag nbt) {
        long age = -1L;
        BlockPos pos = BlockPos.ZERO;
        if (nbt.contains("Age", 4)) {
            age = nbt.getLong("Age");
        }
        if (nbt.contains("exit_portal", 11)) {
            pos = NbtUtils.readBlockPosFromIntArray(nbt, "exit_portal");
        }
        return Pair.of((Object)age, (Object)pos);
    }

    public static Pair<Pair<SignText, SignText>, Boolean> getSignTextFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        AtomicReference<Object> front = new AtomicReference<Object>(null);
        AtomicReference<Object> back = new AtomicReference<Object>(null);
        boolean waxed = false;
        if (nbt.contains("front_text")) {
            SignText.DIRECT_CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.getCompound("front_text")).resultOrPartial().ifPresent(front::set);
        }
        if (nbt.contains("back_text")) {
            SignText.DIRECT_CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.getCompound("back_text")).resultOrPartial().ifPresent(back::set);
        }
        if (nbt.contains("is_waxed")) {
            waxed = nbt.getBoolean("is_waxed");
        }
        return Pair.of((Object)Pair.of((Object)front.get(), (Object)back.get()), (Object)waxed);
    }

    public static Pair<ItemStack, Integer> getBookFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        ItemStack book = ItemStack.EMPTY;
        int current = -1;
        if (nbt.contains("Book", 10)) {
            book = ItemStack.parseOptional((HolderLookup.Provider)registry, (CompoundTag)nbt.getCompound("Book"));
        }
        if (nbt.contains("Page", 3)) {
            current = nbt.getInt("Page");
        }
        return Pair.of((Object)book, (Object)current);
    }

    public static Pair<ResolvableProfile, Pair<ResourceLocation, Component>> getSkullDataFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        AtomicReference<Object> profile = new AtomicReference<Object>(null);
        ResourceLocation note = null;
        MutableComponent name = Component.empty();
        if (nbt.contains("note_block_sound", 8)) {
            note = ResourceLocation.tryParse((String)nbt.getString("note_block_sound"));
        }
        if (nbt.contains("custom_name", 8)) {
            String str = nbt.getString("custom_name");
            try {
                name = Component.Serializer.fromJson((String)str, (HolderLookup.Provider)registry);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (nbt.contains("profile")) {
            ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("profile")).resultOrPartial().ifPresent(profile::set);
        }
        return Pair.of((Object)profile.get(), (Object)Pair.of((Object)note, (Object)name));
    }

    public static Object2IntOpenHashMap<ResourceLocation> getRecipesUsedFromNbt(@Nonnull CompoundTag nbt) {
        Object2IntOpenHashMap list = new Object2IntOpenHashMap();
        if (nbt.contains("RecipesUsed", 10)) {
            CompoundTag compound = nbt.getCompound("RecipesUsed");
            for (String key : compound.getAllKeys()) {
                list.put((Object)ResourceLocation.parse((String)key), compound.getInt(key));
            }
        }
        return list;
    }

    public static int getOutputSignalFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("OutputSignal", 3)) {
            return nbt.getInt("OutputSignal");
        }
        return 0;
    }
}

