/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class MathUtils {
    private static final int[] MULTIPLY_DE_BRUIJN_BIT_POSITION = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};

    public static double average(int[] arr) {
        int size = arr.length;
        if (size == 0) {
            return 0.0;
        }
        long sum = 0L;
        for (int i = 0; i < size; ++i) {
            sum += (long)arr[i];
        }
        return (double)sum / (double)size;
    }

    public static double average(long[] arr) {
        int size = arr.length;
        if (size == 0) {
            return 0.0;
        }
        long sum = 0L;
        for (int i = 0; i < size; ++i) {
            sum += arr[i];
        }
        return (double)sum / (double)size;
    }

    public static double average(double[] arr) {
        int size = arr.length;
        if (size == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < size; ++i) {
            sum += arr[i];
        }
        return sum / (double)size;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static int floor(float value) {
        int i = (int)value;
        return value < (float)i ? i - 1 : i;
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static int roundDown(int value, int interval) {
        int remainder;
        if (interval == 0 || value == 0) {
            return 0;
        }
        if (value < 0) {
            interval *= -1;
        }
        return (remainder = value % interval) == 0 ? value : value - remainder;
    }

    public static double roundDown(double value, double interval) {
        double remainder;
        if (interval == 0.0 || value == 0.0) {
            return 0.0;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value - remainder;
    }

    public static int roundUp(int value, int interval) {
        int remainder;
        if (interval == 0) {
            return 0;
        }
        if (value == 0) {
            return interval;
        }
        if (value < 0) {
            interval *= -1;
        }
        return (remainder = value % interval) == 0 ? value : value + interval - remainder;
    }

    public static double roundUp(double value, double interval) {
        double remainder;
        if (interval == 0.0) {
            return 0.0;
        }
        if (value == 0.0) {
            return interval;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value + interval - remainder;
    }

    public static long roundUp(long number, long interval) {
        long i;
        if (interval == 0L) {
            return 0L;
        }
        if (number == 0L) {
            return interval;
        }
        if (number < 0L) {
            interval *= -1L;
        }
        return (i = number % interval) == 0L ? number : number + interval - i;
    }

    public static float sqrtf(double value) {
        return (float)Math.sqrt(value);
    }

    public static double wrapRadianAngle(double angle) {
        double twoPi = Math.PI * 2;
        if ((angle %= twoPi) < 0.0) {
            angle += twoPi;
        }
        return angle;
    }

    public static double distanceFromPointToLine(double pointX, double pointY, double line1X, double line1Y, double line2X, double line2Y) {
        double num = Math.abs((line2X - line1X) * (line1Y - pointY) - (line1X - pointX) * (line2Y - line1Y));
        double diffX = line2X - line1X;
        double diffY = line2Y - line1Y;
        double den = Math.sqrt(diffX * diffX + diffY * diffY);
        return num / den;
    }

    public static int getMinValue(int[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        int minValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] >= minValue) continue;
            minValue = arr[i];
        }
        return minValue;
    }

    public static int getMaxValue(int[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        int maxValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] <= maxValue) continue;
            maxValue = arr[i];
        }
        return maxValue;
    }

    public static long getMinValue(long[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        long minValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] >= minValue) continue;
            minValue = arr[i];
        }
        return minValue;
    }

    public static long getMaxValue(long[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        long maxValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] <= maxValue) continue;
            maxValue = arr[i];
        }
        return maxValue;
    }

    public static float positiveModulo(float numerator, float denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static double positiveModulo(double numerator, double denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static float wrapDegrees(float value) {
        if ((value %= 360.0f) >= 180.0f) {
            value -= 360.0f;
        }
        if (value < -180.0f) {
            value += 360.0f;
        }
        return value;
    }

    public static double wrapDegrees(double value) {
        if ((value %= 360.0) >= 180.0) {
            value -= 360.0;
        }
        if (value < -180.0) {
            value += 360.0;
        }
        return value;
    }

    public static int wrapDegrees(int angle) {
        if ((angle %= 360) >= 180) {
            angle -= 360;
        }
        if (angle < -180) {
            angle += 360;
        }
        return angle;
    }

    public static Vec3 getRotationVector(float yaw, float pitch) {
        double f = Math.cos((double)(-yaw) * (Math.PI / 180) - Math.PI);
        double g = Math.sin((double)(-yaw) * (Math.PI / 180) - Math.PI);
        double h = -Math.cos((double)(-pitch) * (Math.PI / 180));
        double i = Math.sin((double)(-pitch) * (Math.PI / 180));
        return new Vec3(g * h, i, f * h);
    }

    public static long getCoordinateRandom(int x, int y, int z) {
        long l = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)y;
        return l * l * 42317861L + l * 11L;
    }

    public static long getPositionRandom(Vec3i pos) {
        return MathUtils.getCoordinateRandom(pos.getX(), pos.getY(), pos.getZ());
    }

    public static int smallestEncompassingPowerOfTwo(int value) {
        int i = value - 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    private static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int log2DeBruijn(int value) {
        value = MathUtils.isPowerOfTwo(value) ? value : MathUtils.smallestEncompassingPowerOfTwo(value);
        return MULTIPLY_DE_BRUIJN_BIT_POSITION[(int)((long)value * 125613361L >> 27) & 0x1F];
    }

    public static int log2(int value) {
        if (MathUtils.isPowerOfTwo(value)) {
            return MathUtils.log2DeBruijn(value);
        }
        return MathUtils.log2DeBruijn(value) - 1;
    }

    public static Vec3 scale(Vec3 vec, double factor) {
        return new Vec3(vec.x * factor, vec.y * factor, vec.z * factor);
    }
}

