/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.value.FileWriteType;
import fi.dy.masa.malilib.util.FileNameUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.game.wrap.GameWrap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    public static final Predicate<Path> DIRECTORY_FILTER = FileUtils::isRegularDirectory;
    public static final Predicate<Path> ALWAYS_FALSE_FILEFILTER = p -> false;
    public static final Predicate<Path> ANY_FILE_FILEFILTER = x$0 -> Files.isRegularFile(x$0, new LinkOption[0]);
    public static final Predicate<Path> JSON_FILEFILTER = f -> Files.isRegularFile(f, new LinkOption[0]) && f.getFileName().toString().endsWith(".json");

    @Deprecated(forRemoval=true)
    public static File getConfigDirectory() {
        return new File(GameWrap.getClient().gameDirectory, "config");
    }

    @Deprecated(forRemoval=true)
    public static File getMinecraftDirectory() {
        return GameWrap.getClient().gameDirectory;
    }

    public static Path getConfigDirectoryAsPath() {
        return GameWrap.getClient().gameDirectory.toPath().resolve("config");
    }

    public static Path getMinecraftDirectoryAsPath() {
        return GameWrap.getClient().gameDirectory.toPath();
    }

    public static Path getRootDirectory() {
        return Paths.get("/", new String[0]);
    }

    public static long size(Path file) {
        try {
            return Files.size(file);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getMTime(Path file) {
        try {
            return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static boolean createDirectoriesIfMissing(Path dir) {
        return FileUtils.createDirectoriesIfMissing(dir, arg_0 -> ((Logger)MaLiLib.LOGGER).warn(arg_0));
    }

    public static boolean createDirectoriesIfMissing(Path dir, @Nullable Consumer<String> messageConsumer) {
        try {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            if (messageConsumer != null) {
                messageConsumer.accept(StringUtils.translate("malilib.message.error.failed_to_create_directory", dir.toAbsolutePath()));
            }
            return false;
        }
        return Files.isDirectory(dir, new LinkOption[0]);
    }

    public static boolean createFile(Path file) {
        return FileUtils.createFile(file, arg_0 -> ((Logger)MaLiLib.LOGGER).warn(arg_0));
    }

    public static boolean createFile(Path file, Consumer<String> messageConsumer) {
        try {
            Files.createFile(file, new FileAttribute[0]);
            return true;
        }
        catch (Exception e) {
            if (messageConsumer != null) {
                messageConsumer.accept(StringUtils.translate("malilib.message.error.failed_to_create_file", file.toAbsolutePath()));
            }
            return false;
        }
    }

    public static boolean copy(Path srcFile, Path dstFile) {
        return FileUtils.copy(srcFile, dstFile, true);
    }

    public static boolean copy(Path srcFile, Path dstFile, boolean overwrite) {
        return FileUtils.copy(srcFile, dstFile, overwrite, arg_0 -> ((Logger)MaLiLib.LOGGER).warn(arg_0));
    }

    public static boolean copy(Path srcFile, Path dstFile, boolean overwrite, Consumer<String> messageConsumer) {
        try {
            if (overwrite) {
                Files.copy(srcFile, dstFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            } else if (Files.exists(dstFile, new LinkOption[0])) {
                messageConsumer.accept(StringUtils.translate("malilib.message.error.file_or_directory_already_exists", dstFile.toAbsolutePath()));
            } else {
                Files.copy(srcFile, dstFile, StandardCopyOption.COPY_ATTRIBUTES);
            }
            return true;
        }
        catch (Exception e) {
            messageConsumer.accept(StringUtils.translate("malilib.message.error.failed_to_copy_file_with_message", srcFile.toAbsolutePath(), dstFile.toAbsolutePath(), e.getMessage()));
            return false;
        }
    }

    public static boolean move(Path srcFile, Path dstFile) {
        return FileUtils.move(srcFile, dstFile, true);
    }

    public static boolean move(Path srcFile, Path dstFile, boolean overwrite) {
        return FileUtils.move(srcFile, dstFile, overwrite, arg_0 -> ((Logger)MaLiLib.LOGGER).warn(arg_0));
    }

    public static boolean move(Path srcFile, Path dstFile, boolean overwrite, Consumer<String> messageConsumer) {
        try {
            if (overwrite) {
                Files.move(srcFile, dstFile, StandardCopyOption.REPLACE_EXISTING);
            } else if (Files.exists(dstFile, new LinkOption[0])) {
                messageConsumer.accept(StringUtils.translate("malilib.message.error.file_or_directory_already_exists", dstFile.toAbsolutePath()));
            } else {
                Files.move(srcFile, dstFile, new CopyOption[0]);
            }
            return true;
        }
        catch (Exception e) {
            messageConsumer.accept(StringUtils.translate("malilib.message.error.failed_to_move_file", srcFile.toAbsolutePath(), dstFile.toAbsolutePath()));
            return false;
        }
    }

    public static boolean delete(Path file) {
        return FileUtils.delete(file, arg_0 -> ((Logger)MaLiLib.LOGGER).warn(arg_0));
    }

    public static boolean delete(Path file, Consumer<String> messageConsumer) {
        try {
            Files.delete(file);
            return true;
        }
        catch (Exception e) {
            messageConsumer.accept(StringUtils.translate("malilib.message.error.failed_to_delete_file", file.toAbsolutePath()));
            return false;
        }
    }

    public static boolean canWriteToFileAsPath(Path dir, String fileName, boolean canOverwrite) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            Path file = dir.resolve(fileName);
            return !Files.exists(file, new LinkOption[0]) || canOverwrite && Files.isRegularFile(file, new LinkOption[0]) && Files.isWritable(file);
        }
        return false;
    }

    public static boolean canWriteToFile(File dir, String fileName, boolean canOverwrite) {
        if (dir.exists() && dir.isDirectory()) {
            File file = new File(dir, fileName);
            return !file.exists() || canOverwrite && file.isFile() && file.canWrite();
        }
        return false;
    }

    public static File getCanonicalFileIfPossible(File file) {
        try {
            File fileCan = file.getCanonicalFile();
            if (fileCan != null) {
                file = fileCan;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public static String getJoinedTrailingPathElements(File file, File rootPath, int maxStringLength, String separator) {
        Object path = "";
        if (maxStringLength <= 0) {
            return "...";
        }
        while (file != null) {
            String name = file.getName();
            int len = ((String)(path = !((String)path).isEmpty() ? name + separator + (String)path : name)).length();
            if (len > maxStringLength) {
                path = "... " + ((String)path).substring(len - maxStringLength, len);
                break;
            }
            if (file.equals(rootPath)) break;
            file = file.getParentFile();
        }
        return path;
    }

    public static String getJoinedTrailingPathElements(Path file, Path rootPath, int maxStringLength, String separator) {
        StringBuilder path = new StringBuilder();
        if (maxStringLength <= 0) {
            return "...";
        }
        while (file != null) {
            String name = file.getFileName().toString();
            if (!(path.length() == 0)) {
                path.insert(0, name + separator);
            } else {
                path = new StringBuilder(name);
            }
            int len = path.length();
            if (len > maxStringLength) {
                path = new StringBuilder("... " + path.substring(len - maxStringLength, len));
                break;
            }
            if (file.equals(rootPath)) break;
            file = file.getParent();
        }
        return path.toString();
    }

    @Deprecated(forRemoval=true)
    public static String generateSafeFileName(String name) {
        return FileNameUtils.generateSafeFileName(name);
    }

    @Deprecated(forRemoval=true)
    public static String getNameWithoutExtension(String name) {
        int i = name.lastIndexOf(".");
        return i != -1 ? name.substring(0, i) : name;
    }

    public static boolean writeDataToFile(Path file, Consumer<BufferedWriter> dataWriter, FileWriteType writeType) {
        Path dir = file.getParent();
        if (dir != null && !FileUtils.createDirectoriesIfMissing(dir)) {
            return false;
        }
        if (dir == null) {
            dir = Paths.get(".", new String[0]);
        }
        if (writeType == FileWriteType.NORMAL_WRITE || Files.isSymbolicLink(file)) {
            return FileUtils.writeDataToExactFile(file, dataWriter);
        }
        if (writeType == FileWriteType.TEMP_AND_RENAME) {
            Path fileTmp = dir.resolve(String.valueOf(file.getFileName()) + ".tmp");
            if (Files.exists(fileTmp, new LinkOption[0])) {
                fileTmp = dir.resolve(String.valueOf(UUID.randomUUID()) + ".tmp");
            }
            return FileUtils.writeDataToExactFile(fileTmp, dataWriter) && FileUtils.move(fileTmp, file);
        }
        return false;
    }

    public static boolean writeDataToExactFile(Path file, Consumer<BufferedWriter> dataWriter) {
        boolean bl;
        block8: {
            BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);
            try {
                dataWriter.accept(writer);
                writer.close();
                bl = true;
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    MaLiLib.LOGGER.warn("Failed to write to file '{}'", (Object)file.toAbsolutePath(), (Object)e);
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }

    public static boolean isRegularDirectory(Path file) {
        String name = String.valueOf(file.getFileName());
        return Files.isDirectory(file, new LinkOption[0]) && !name.equals(".") && !name.equals("..");
    }

    public static boolean isCurrentOrParentDirectory(Path file) {
        String name = String.valueOf(file.getFileName());
        return Files.isDirectory(file, new LinkOption[0]) && (name.equals(".") || name.equals(".."));
    }

    public static List<Path> getDirectoryContents(Path dir, Predicate<Path> filter, boolean sortByName) {
        ArrayList<Path> list = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path file : stream) {
                if (!filter.test(file)) continue;
                list.add(file);
            }
            if (sortByName) {
                list.sort(Comparator.comparing(Path::getFileName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static Path getUnusedFileName(Path dir, String fileNameFormatString, int startNumber) {
        Path file;
        int id = startNumber;
        do {
            String name = String.format(fileNameFormatString, id);
            file = dir.resolve(name);
            ++id;
        } while (Files.exists(file, new LinkOption[0]));
        return file;
    }

    @Nullable
    public static String getRelativePath(Path dir, Path file) {
        try {
            return dir.relativize(file).toString();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static List<Path> getSubDirectories(Path dir) {
        return FileUtils.getDirectoryContents(dir, FileUtils::isRegularDirectory, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirectoryEmpty(Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            Path file;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return true;
            } while (FileUtils.isCurrentOrParentDirectory(file = iterator.next()));
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static List<Path> getDirsForRootPath(Path dir, Path root) {
        ArrayList<Path> dirs = new ArrayList<Path>();
        while (dir != null && dir.startsWith(root)) {
            dirs.add(dir);
            if (root.equals(dir)) break;
            dir = dir.getParent();
        }
        return dirs;
    }

    public static List<Path> getSiblingDirs(Path dir) {
        ArrayList<Path> dirs = new ArrayList<Path>();
        Path parent = dir.getParent();
        if (parent != null) {
            dirs.addAll(FileUtils.getSubDirectories(parent));
            dirs.sort(Comparator.comparing(Path::getFileName));
        }
        return dirs;
    }

    public static boolean copyFilesToDirectory(Collection<Path> files, Path destinationDir, Consumer<String> messageConsumer) {
        boolean success = true;
        for (Path file : files) {
            if (FileUtils.copyFileToDirectory(file, destinationDir, messageConsumer)) continue;
            success = false;
        }
        return success;
    }

    public static boolean copyFileToDirectory(Path sourceFile, Path destinationDir, Consumer<String> messageConsumer) {
        Path destinationFile = destinationDir.resolve(sourceFile.getFileName());
        return FileUtils.copyFile(sourceFile, destinationFile, messageConsumer);
    }

    public static boolean copyFile(Path sourceFile, Path destinationFile, Consumer<String> messageConsumer) {
        if (Files.exists(sourceFile, new LinkOption[0])) {
            if (Files.exists(destinationFile, new LinkOption[0])) {
                String msg = StringUtils.translate("malilib.message.error.failed_to_copy_file.destination_exists", sourceFile.toAbsolutePath().toString(), destinationFile.toAbsolutePath().toString());
                messageConsumer.accept(msg);
                return false;
            }
            try {
                Files.copy(sourceFile, destinationFile, StandardCopyOption.COPY_ATTRIBUTES);
                return true;
            }
            catch (Exception e) {
                String msg = StringUtils.translate("malilib.message.error.failed_to_copy_file", sourceFile.toAbsolutePath().toString(), destinationFile.toAbsolutePath().toString());
                messageConsumer.accept(msg);
                messageConsumer.accept(e.getMessage());
            }
        }
        return false;
    }

    public static boolean moveFilesToDirectory(Collection<Path> files, Path destinationDir, Consumer<String> messageConsumer) {
        boolean success = true;
        for (Path file : files) {
            if (FileUtils.moveFileToDirectory(file, destinationDir, messageConsumer)) continue;
            success = false;
        }
        return success;
    }

    public static boolean moveFileToDirectory(Path sourceFile, Path destinationDir, Consumer<String> messageConsumer) {
        Path destinationFile = destinationDir.resolve(sourceFile.getFileName());
        return FileUtils.moveFile(sourceFile, destinationFile, messageConsumer);
    }

    public static boolean moveFile(Path sourceFile, Path destinationFile, Consumer<String> messageConsumer) {
        if (Files.exists(sourceFile, new LinkOption[0])) {
            if (Files.exists(destinationFile, new LinkOption[0])) {
                String msg = StringUtils.translate("malilib.message.error.failed_to_move_file.destination_exists", sourceFile.toAbsolutePath().toString(), destinationFile.toAbsolutePath().toString());
                messageConsumer.accept(msg);
                return false;
            }
            try {
                Files.move(sourceFile, destinationFile, new CopyOption[0]);
                return true;
            }
            catch (Exception e) {
                String msg = StringUtils.translate("malilib.message.error.failed_to_move_file", sourceFile.toAbsolutePath().toString(), destinationFile.toAbsolutePath().toString());
                messageConsumer.accept(msg);
                messageConsumer.accept(e.getMessage());
            }
        }
        return false;
    }

    public static boolean renameFile(Path sourceFile, Path destinationFile, Consumer<String> messageConsumer) {
        if (Files.exists(sourceFile, new LinkOption[0])) {
            if (Files.exists(destinationFile, new LinkOption[0])) {
                messageConsumer.accept(StringUtils.translate("malilib.message.error.failed_to_rename_file.exists", sourceFile.toAbsolutePath().toString(), destinationFile.toAbsolutePath().toString()));
                return false;
            }
            try {
                return FileUtils.move(sourceFile, destinationFile);
            }
            catch (Exception e) {
                messageConsumer.accept(StringUtils.translate("malilib.message.error.failed_to_rename_file.exception", sourceFile.toAbsolutePath().toString(), destinationFile.toAbsolutePath().toString(), e.getMessage()));
            }
        }
        return false;
    }

    public static boolean renameFileToName(Path oldFile, String newName, Consumer<String> messageConsumer) {
        Path newFile;
        Path dir;
        String ext;
        if (FileNameUtils.doesFileNameContainIllegalCharacters((String)newName)) {
            String key = "malilib.message.error.illegal_characters_in_file_name";
            messageConsumer.accept(StringUtils.translate(key, newName));
            return false;
        }
        String oldName = oldFile.getFileName().toString();
        int indexExt = oldName.lastIndexOf(46);
        String string = ext = indexExt > 0 ? oldName.substring(indexExt) : null;
        if (ext != null && !((String)newName).endsWith(ext)) {
            newName = (String)newName + ext;
        }
        if ((dir = oldFile.getParent()) == null) {
            dir = Paths.get(".", new String[0]);
        }
        if (!Files.exists(newFile = dir.resolve((String)newName), new LinkOption[0])) {
            if (FileUtils.move(oldFile, newFile)) {
                return true;
            }
            String key = "malilib.message.error.file_rename.rename_failed";
            messageConsumer.accept(StringUtils.translate(key, oldName, newName));
        } else {
            String key = "malilib.message.error.failed_to_rename_file.exists";
            messageConsumer.accept(StringUtils.translate(key, oldName, newName));
        }
        return false;
    }

    public static boolean deleteFiles(Collection<Path> files, Consumer<String> messageConsumer) {
        boolean success = true;
        for (Path file : files) {
            String key;
            if (Files.isDirectory(file, new LinkOption[0])) {
                key = "malilib.message.error.failed_to_delete_file_is_dir";
                messageConsumer.accept(StringUtils.translate(key, file.getFileName().toString()));
                success = false;
                continue;
            }
            try {
                if (Files.deleteIfExists(file)) continue;
                key = "malilib.message.error.failed_to_delete_file";
                messageConsumer.accept(StringUtils.translate(key, file.getFileName().toString()));
                success = false;
            }
            catch (Exception e) {
                String key2 = "malilib.message.error.failed_to_delete_file";
                messageConsumer.accept(StringUtils.translate(key2, file.getFileName().toString()));
                messageConsumer.accept(e.getMessage());
                success = false;
            }
        }
        return success;
    }

    @Nullable
    public static String readFileAsString(Path file, int maxFileSize) {
        if (Files.isReadable(file) && (maxFileSize == -1 || FileUtils.size(file) <= (long)maxFileSize)) {
            try {
                return String.join((CharSequence)"\n", Files.readAllLines(file));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean writeStringToFile(String str, Path file, boolean override) {
        Path dir = file.getParent();
        if (dir == null) {
            dir = Paths.get(".", new String[0]);
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return false;
        }
        if (!Files.exists(file, new LinkOption[0]) || override && Files.isWritable(file)) {
            boolean bl;
            block11: {
                BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);
                try {
                    writer.write(str);
                    writer.close();
                    bl = true;
                    if (writer == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        MaLiLib.LOGGER.warn("Failed to write string to file '{}'", (Object)file.toAbsolutePath(), (Object)e);
                    }
                }
                writer.close();
            }
            return bl;
        }
        return false;
    }
}

