/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.test.TestUtils;
import fi.dy.masa.malilib.util.Color4f;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@ApiStatus.Experimental
public class TestWalls
implements AutoCloseable {
    protected static final Tesselator TESSELLATOR_1 = new Tesselator(0x200000);
    protected static final Tesselator TESSELLATOR_2 = new Tesselator(0x200000);
    protected static BufferBuilder BUFFER_1;
    protected static BufferBuilder BUFFER_2;
    protected static VertexBuffer VERTEX_1;
    protected static VertexBuffer VERTEX_2;
    protected static boolean renderThrough;
    protected static boolean useCulling;
    protected static float glLineWidth;
    protected static BlockPos lastPos;
    private static Vec3 updateCameraPos;
    private static boolean hasData;

    public static Vec3 getUpdatePosition() {
        return updateCameraPos;
    }

    public static void setUpdatePosition(Vec3 cameraPosition) {
        updateCameraPos = cameraPosition;
    }

    public static boolean needsUpdate(BlockPos pos) {
        if (lastPos.equals((Object)BlockPos.ZERO)) {
            lastPos = pos;
            return true;
        }
        if (!pos.equals((Object)BlockPos.ZERO) && !pos.equals((Object)lastPos)) {
            lastPos = pos;
            return true;
        }
        return false;
    }

    public static void update(Camera camera, Minecraft mc) {
        Color4f color = MaLiLibConfigs.Test.TEST_CONFIG_COLOR.getColor();
        if (mc.level == null || mc.player == null) {
            return;
        }
        BlockPos pos = camera.getBlockPosition();
        Vec3 vec = camera.getPosition();
        int radius = 5;
        if (VERTEX_1 == null || VERTEX_1.isInvalid()) {
            VERTEX_1 = new VertexBuffer(VertexBuffer.Usage.STATIC);
        }
        if (VERTEX_2 == null || VERTEX_2.isInvalid()) {
            VERTEX_2 = new VertexBuffer(VertexBuffer.Usage.STATIC);
        }
        BUFFER_1 = TESSELLATOR_1.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        BUFFER_2 = TESSELLATOR_2.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        Pair<BlockPos, BlockPos> corners = TestUtils.getSpawnChunkCorners(pos, radius, (Level)mc.level);
        TestUtils.renderWallsWithLines((BlockPos)corners.getLeft(), (BlockPos)corners.getRight(), vec, 16.0, 16.0, true, color, BUFFER_1, BUFFER_2);
        TestWalls.uploadData(BUFFER_1, VERTEX_1);
        TestWalls.uploadData(BUFFER_2, VERTEX_2);
        TestWalls.setUpdatePosition(vec);
    }

    private static void uploadData(BufferBuilder bufferBuilder, VertexBuffer vertexBuffer) {
        if (vertexBuffer.isInvalid()) {
            return;
        }
        try {
            MeshData builtBuffer = bufferBuilder.build();
            if (builtBuffer != null) {
                hasData = true;
                vertexBuffer.bind();
                vertexBuffer.upload(builtBuffer);
                VertexBuffer.unbind();
                builtBuffer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void preRender() {
        RenderSystem.lineWidth((float)glLineWidth);
        if (renderThrough) {
            RenderSystem.disableDepthTest();
        }
        if (useCulling) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
    }

    protected static void postRender() {
        if (renderThrough) {
            RenderSystem.enableDepthTest();
        }
        RenderSystem.enableCull();
    }

    public static void draw(Vec3 cameraPos, Matrix4f matrix4f, Matrix4f projMatrix, Minecraft mc, ProfilerFiller profiler) {
        profiler.push(() -> "TestWalls#draw()");
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderUtils.setupBlend();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        Vec3 updatePos = TestWalls.getUpdatePosition();
        matrix4fstack.pushMatrix();
        matrix4fstack.translate((float)(updatePos.x - cameraPos.x), (float)(updatePos.y - cameraPos.y), (float)(updatePos.z - cameraPos.z));
        TestWalls.drawData(matrix4f, projMatrix);
        matrix4fstack.popMatrix();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        profiler.pop();
    }

    private static void drawData(Matrix4f matrix4f, Matrix4f projMatrix) {
        if (hasData) {
            TestWalls.preRender();
            TestWalls.drawInternal(matrix4f, projMatrix, VERTEX_1, GameRenderer::getPositionColorShader);
            TestWalls.drawInternal(matrix4f, projMatrix, VERTEX_2, GameRenderer::getPositionColorShader);
            TestWalls.postRender();
        }
    }

    private static void drawInternal(Matrix4f matrix4f, Matrix4f projMatrix, VertexBuffer vertexBuffer, Supplier<ShaderInstance> shader) {
        if (hasData) {
            RenderSystem.setShader(shader);
            vertexBuffer.bind();
            vertexBuffer.drawWithShader(matrix4f, projMatrix, shader.get());
            VertexBuffer.unbind();
        }
    }

    public static void clear() {
        lastPos = BlockPos.ZERO;
        VERTEX_1.close();
        VERTEX_2.close();
        TESSELLATOR_1.clear();
        TESSELLATOR_2.clear();
        hasData = false;
    }

    @Override
    public void close() {
        TestWalls.clear();
    }

    static {
        renderThrough = false;
        useCulling = false;
        glLineWidth = 1.0f;
        lastPos = BlockPos.ZERO;
        updateCameraPos = Vec3.ZERO;
        hasData = false;
    }
}

