/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.event.RenderEventHandler;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.mixin.item.IMixinContainerComponent;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.IEntityOwnedInventory;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.game.wrap.GameWrap;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;

public class InventoryOverlay {
    public static final ResourceLocation TEXTURE_BREWING_STAND = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/brewing_stand.png");
    public static final ResourceLocation TEXTURE_CRAFTER = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/crafter.png");
    public static final ResourceLocation TEXTURE_DISPENSER = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/dispenser.png");
    public static final ResourceLocation TEXTURE_DOUBLE_CHEST = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    public static final ResourceLocation TEXTURE_FURNACE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/furnace.png");
    public static final ResourceLocation TEXTURE_HOPPER = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/hopper.png");
    public static final ResourceLocation TEXTURE_PLAYER_INV = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/inventory.png");
    public static final ResourceLocation TEXTURE_SINGLE_CHEST = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/shulker_box.png");
    public static final ResourceLocation TEXTURE_EMPTY_SHIELD = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_shield");
    public static final ResourceLocation TEXTURE_LOCKED_SLOT = ResourceLocation.withDefaultNamespace((String)"container/crafter/disabled_slot");
    public static final ResourceLocation TEXTURE_EMPTY_HORSE_ARMOR = ResourceLocation.withDefaultNamespace((String)"container/horse/armor_slot");
    public static final ResourceLocation TEXTURE_EMPTY_LLAMA_ARMOR = ResourceLocation.withDefaultNamespace((String)"container/horse/llama_armor_slot");
    public static final ResourceLocation TEXTURE_EMPTY_SADDLE = ResourceLocation.withDefaultNamespace((String)"container/horse/saddle_slot");
    public static final ResourceLocation TEXTURE_EMPTY_BREWER_FUEL = ResourceLocation.withDefaultNamespace((String)"container/slot/brewing_fuel");
    public static final ResourceLocation TEXTURE_EMPTY_POTION = ResourceLocation.withDefaultNamespace((String)"container/slot/potion");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_AMETHYST = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_amethyst_shard");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_AXE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_axe");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_DIAMOND = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_diamond");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_EMERALD = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_emerald");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_HOE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_hoe");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_INGOT = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_ingot");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_LAPIS = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_lapis_lazuli");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_PICKAXE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_pickaxe");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_QUARTZ = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_quartz");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_REDSTONE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_redstone_dust");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_SHOVEL = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_shovel");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_ARMOR_TRIM = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_smithing_template_armor_trim");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_UPGRADE = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_smithing_template_netherite_upgrade");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_SWORD = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_sword");
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final InventoryProperties INV_PROPS_TEMP = new InventoryProperties();
    private static final ResourceLocation[] EMPTY_SLOT_TEXTURES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_boots"), ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_leggings"), ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_chestplate"), ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_helmet")};
    private static ItemStack hoveredStack = null;

    public static void renderInventoryBackground(InventoryRenderType type, int x, int y, int slotsPerRow, int totalSlots, Minecraft mc) {
        RenderUtils.setupBlend();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.applyModelViewMatrix();
        if (type == InventoryRenderType.FURNACE) {
            RenderUtils.bindTexture(TEXTURE_FURNACE);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 4, 64, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y, 84, 0, 92, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 64, 0, 162, 92, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x + 92, y + 4, 172, 102, 4, 64, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y + 4, 52, 13, 88, 60, buffer);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            RenderUtils.bindTexture(TEXTURE_BREWING_STAND);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 4, 68, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y, 63, 0, 113, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 68, 0, 162, 113, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x + 113, y + 4, 172, 98, 4, 68, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y + 4, 13, 13, 109, 64, buffer);
        } else if (type == InventoryRenderType.CRAFTER) {
            RenderUtils.bindTexture(TEXTURE_DISPENSER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 115, 0, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 61, y + 7, 169, 105, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 61, 16, 54, 54, buffer);
        } else if (type == InventoryRenderType.DISPENSER) {
            RenderUtils.bindTexture(TEXTURE_DISPENSER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 115, 0, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 61, y + 7, 169, 105, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 61, 16, 54, 54, buffer);
        } else if (type == InventoryRenderType.HOPPER) {
            RenderUtils.bindTexture(TEXTURE_HOPPER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 25, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 79, 0, 97, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 25, 0, 126, 97, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 97, y + 7, 169, 108, 7, 25, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 43, 19, 90, 18, buffer);
        } else if (type == InventoryRenderType.VILLAGER) {
            RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 79, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 133, 0, 43, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 79, 0, 215, 43, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 43, y + 7, 169, 143, 7, 79, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 36, 72, buffer);
        } else if (type == InventoryRenderType.FIXED_27) {
            InventoryOverlay.renderInventoryBackground27(x, y, buffer, mc);
        } else if (type == InventoryRenderType.FIXED_54) {
            InventoryOverlay.renderInventoryBackground54(x, y, buffer, mc);
        } else {
            RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
            int rows = (int)Math.ceil((double)totalSlots / (double)slotsPerRow);
            int bgw = Math.min(totalSlots, slotsPerRow) * 18 + 7;
            int bgh = rows * 18 + 7;
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, bgh, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 176 - bgw, 0, bgw, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + bgh, 0, 215, bgw, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + bgw, y + 7, 169, 222 - bgh, 7, bgh, buffer);
            for (int row = 0; row < rows; ++row) {
                int rowLen = Mth.clamp((int)(totalSlots - row * slotsPerRow), (int)1, (int)slotsPerRow);
                RenderUtils.drawTexturedRectBatched(x + 7, y + row * 18 + 7, 7, 17, rowLen * 18, 18, buffer);
                if (rows <= 1 || rowLen >= slotsPerRow) continue;
                RenderUtils.drawTexturedRectBatched(x + rowLen * 18 + 7, y + row * 18 + 7, 7, 3, (slotsPerRow - rowLen) * 18, 9, buffer);
                RenderUtils.drawTexturedRectBatched(x + rowLen * 18 + 7, y + row * 18 + 16, 7, 3, (slotsPerRow - rowLen) * 18, 9, buffer);
            }
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        try {
            MeshData builtBuffer = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderInventoryBackground27(int x, int y, BufferBuilder buffer, Minecraft mc) {
        RenderUtils.bindTexture(TEXTURE_SINGLE_CHEST);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y, 7, 0, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x + 169, y + 7, 169, 105, 7, 61, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 162, 54, buffer);
    }

    public static void renderInventoryBackground54(int x, int y, BufferBuilder buffer, Minecraft mc) {
        RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 115, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y, 7, 0, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 115, 0, 215, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x + 169, y + 7, 169, 107, 7, 115, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 162, 108, buffer);
    }

    public static void renderInventoryBackgroundSlots(InventoryRenderType type, Container inv, int x, int y, GuiGraphics drawContext) {
        if (type == InventoryRenderType.HORSE) {
            InventoryOverlay.renderHorseArmorBackgroundSlots(inv, x, y, drawContext);
        } else if (type == InventoryRenderType.LLAMA) {
            InventoryOverlay.renderLlamaArmorBackgroundSlots(inv, x, y, drawContext);
        } else if (type == InventoryRenderType.WOLF) {
            InventoryOverlay.renderWolfArmorBackgroundSlots(inv, x, y, drawContext);
        }
    }

    private static void renderBrewerBackgroundSlots(Container inv, int x, int y, GuiGraphics drawContext) {
        InventoryOverlay.renderBrewerBackgroundSlots(inv, x, y, 0.9f, drawContext, 0.0, 0.0);
    }

    private static void renderBrewerBackgroundSlots(Container inv, int x, int y, float scale, GuiGraphics drawContext, double mouseX, double mouseY) {
        if (inv.getItem(0).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(x + 47, y + 42, scale, TEXTURE_EMPTY_POTION, drawContext, mouseX, mouseY);
        }
        if (inv.getItem(1).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(x + 70, y + 49, scale, TEXTURE_EMPTY_POTION, drawContext, mouseX, mouseY);
        }
        if (inv.getItem(2).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(x + 93, y + 42, scale, TEXTURE_EMPTY_POTION, drawContext, mouseX, mouseY);
        }
        if (inv.getItem(4).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(x + 8, y + 8, scale, TEXTURE_EMPTY_BREWER_FUEL, drawContext, mouseX, mouseY);
        }
    }

    public static void renderHorseArmorBackgroundSlots(Container inv, int x, int y, GuiGraphics drawContext) {
        InventoryOverlay.renderHorseArmorBackgroundSlots(inv, x, y, 0.9f, drawContext, 0.0, 0.0);
    }

    public static void renderHorseArmorBackgroundSlots(Container inv, int x, int y, float scale, GuiGraphics drawContext, double mouseX, double mouseY) {
        if (inv.getItem(0).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(x, y, scale, TEXTURE_EMPTY_HORSE_ARMOR, drawContext, mouseX, mouseY);
        }
        if (inv.getItem(1).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(x, y + 18, scale, TEXTURE_EMPTY_SADDLE, drawContext, mouseX, mouseY);
        }
    }

    public static void renderLlamaArmorBackgroundSlots(Container inv, int x, int y, GuiGraphics drawContext) {
        InventoryOverlay.renderLlamaArmorBackgroundSlots(inv, x, y, 0.9f, drawContext, 0.0, 0.0);
    }

    public static void renderLlamaArmorBackgroundSlots(Container inv, int x, int y, float scale, GuiGraphics drawContext, double mouseX, double mouseY) {
        if (inv.getItem(0).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(x, y, scale, TEXTURE_EMPTY_LLAMA_ARMOR, drawContext, mouseX, mouseY);
        }
    }

    public static void renderWolfArmorBackgroundSlots(Container inv, int x, int y, GuiGraphics drawContext) {
        InventoryOverlay.renderWolfArmorBackgroundSlots(inv, x, y, 0.9f, drawContext, 0.0, 0.0);
    }

    public static void renderWolfArmorBackgroundSlots(Container inv, int x, int y, float scale, GuiGraphics drawContext, double mouseX, double mouseY) {
        if (inv.getItem(0).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(x, y, scale, TEXTURE_EMPTY_HORSE_ARMOR, drawContext, mouseX, mouseY);
        }
    }

    public static void renderEquipmentOverlayBackground(int x, int y, LivingEntity entity, GuiGraphics drawContext) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.applyModelViewMatrix();
        RenderUtils.bindTexture(TEXTURE_DISPENSER);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 50, 83, buffer);
        RenderUtils.drawTexturedRectBatched(x + 50, y, 173, 0, 3, 83, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 83, 0, 163, 50, 3, buffer);
        RenderUtils.drawTexturedRectBatched(x + 50, y + 83, 173, 163, 3, 3, buffer);
        int i22 = 0;
        int xOff = 7;
        int yOff = 7;
        while (i22 < 4) {
            RenderUtils.drawTexturedRectBatched(x + xOff, y + yOff, 61, 16, 18, 18, buffer);
            ++i22;
            yOff += 18;
        }
        RenderUtils.drawTexturedRectBatched(x + 28, y + 36 + 7, 61, 16, 18, 18, buffer);
        RenderUtils.drawTexturedRectBatched(x + 28, y + 54 + 7, 61, 16, 18, 18, buffer);
        try {
            MeshData builtBuffer = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception i22) {
            // empty catch block
        }
        RenderUtils.bindTexture(InventoryMenu.BLOCK_ATLAS);
        if (entity.getItemBySlot(EquipmentSlot.OFFHAND).isEmpty()) {
            RenderUtils.renderSprite(x + 28 + 1, y + 54 + 7 + 1, 16, 16, InventoryMenu.BLOCK_ATLAS, TEXTURE_EMPTY_SHIELD, drawContext);
        }
        int i = 0;
        xOff = 7;
        yOff = 7;
        while (i < 4) {
            EquipmentSlot eqSlot = VALID_EQUIPMENT_SLOTS[i];
            if (entity.getItemBySlot(eqSlot).isEmpty()) {
                ResourceLocation texture = EMPTY_SLOT_TEXTURES[eqSlot.getIndex()];
                RenderUtils.renderSprite(x + xOff + 1, y + yOff + 1, 16, 16, InventoryMenu.BLOCK_ATLAS, texture, drawContext);
            }
            ++i;
            yOff += 18;
        }
    }

    public static InventoryRenderType getInventoryType(Container inv) {
        if (inv instanceof ShulkerBoxBlockEntity) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof CompoundContainer) {
            return InventoryRenderType.FIXED_54;
        }
        if (inv instanceof ChestBoat) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof MinecartChest) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof AbstractFurnaceBlockEntity) {
            return InventoryRenderType.FURNACE;
        }
        if (inv instanceof BrewingStandBlockEntity) {
            return InventoryRenderType.BREWING_STAND;
        }
        if (inv instanceof CrafterBlockEntity) {
            return InventoryRenderType.CRAFTER;
        }
        if (inv instanceof DispenserBlockEntity) {
            return InventoryRenderType.DISPENSER;
        }
        if (inv instanceof HopperBlockEntity) {
            return InventoryRenderType.HOPPER;
        }
        if (inv instanceof MinecartHopper) {
            return InventoryRenderType.HOPPER;
        }
        if (inv instanceof Inventory) {
            return InventoryRenderType.PLAYER;
        }
        if (inv instanceof IEntityOwnedInventory) {
            IEntityOwnedInventory inventory = (IEntityOwnedInventory)inv;
            if (inventory.malilib$getEntityOwner() instanceof Llama) {
                return InventoryRenderType.LLAMA;
            }
            if (inventory.malilib$getEntityOwner() instanceof Wolf) {
                return InventoryRenderType.WOLF;
            }
            if (inventory.malilib$getEntityOwner() instanceof AbstractHorse) {
                return InventoryRenderType.HORSE;
            }
            if (inventory.malilib$getEntityOwner() instanceof Piglin) {
                return InventoryRenderType.VILLAGER;
            }
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryRenderType getInventoryType(ItemStack stack) {
        Item item = stack.getItem();
        ItemContainerContents container = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            if (block instanceof ShulkerBoxBlock || block instanceof ChestBlock || block instanceof BarrelBlock) {
                int size = ((IMixinContainerComponent)container).malilib_getStacks().size();
                if (size >= 0 && size <= 27) {
                    return InventoryRenderType.FIXED_27;
                }
                if (size > 27 && size <= 54) {
                    return InventoryRenderType.FIXED_54;
                }
                if (size > 54 && size < 256) {
                    return InventoryRenderType.GENERIC;
                }
            } else {
                if (block instanceof AbstractFurnaceBlock) {
                    return InventoryRenderType.FURNACE;
                }
                if (block instanceof DispenserBlock) {
                    return InventoryRenderType.DISPENSER;
                }
                if (block instanceof HopperBlock) {
                    return InventoryRenderType.HOPPER;
                }
                if (block instanceof BrewingStandBlock) {
                    return InventoryRenderType.BREWING_STAND;
                }
                if (block instanceof CrafterBlock) {
                    return InventoryRenderType.CRAFTER;
                }
                if (block instanceof DecoratedPotBlock || block instanceof JukeboxBlock || block instanceof LecternBlock) {
                    return InventoryRenderType.SINGLE_ITEM;
                }
                if (block instanceof ChiseledBookShelfBlock) {
                    return InventoryRenderType.BOOKSHELF;
                }
                if (block instanceof EnderChestBlock) {
                    return InventoryRenderType.ENDER_CHEST;
                }
            }
        } else if (item instanceof BundleItem) {
            return InventoryRenderType.BUNDLE;
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryRenderType getInventoryType(@Nonnull CompoundTag nbt) {
        EntityType<?> entityType;
        BlockEntityType<?> blockType = NbtBlockUtils.getBlockEntityTypeFromNbt(nbt);
        if (blockType != null) {
            if (blockType.equals((Object)BlockEntityType.SHULKER_BOX) || blockType.equals((Object)BlockEntityType.BARREL) || blockType.equals((Object)BlockEntityType.CHEST) || blockType.equals((Object)BlockEntityType.TRAPPED_CHEST)) {
                ListTag list;
                if (nbt.contains("Items") && (list = nbt.getList("Items", 10)).size() > 27) {
                    return InventoryRenderType.FIXED_54;
                }
                return InventoryRenderType.FIXED_27;
            }
            if (blockType.equals((Object)BlockEntityType.FURNACE) || blockType.equals((Object)BlockEntityType.BLAST_FURNACE) || blockType.equals((Object)BlockEntityType.SMOKER)) {
                return InventoryRenderType.FURNACE;
            }
            if (blockType.equals((Object)BlockEntityType.DISPENSER) || blockType.equals((Object)BlockEntityType.DROPPER)) {
                return InventoryRenderType.DISPENSER;
            }
            if (blockType.equals((Object)BlockEntityType.HOPPER)) {
                return InventoryRenderType.HOPPER;
            }
            if (blockType.equals((Object)BlockEntityType.BREWING_STAND)) {
                return InventoryRenderType.BREWING_STAND;
            }
            if (blockType.equals((Object)BlockEntityType.CRAFTER)) {
                return InventoryRenderType.CRAFTER;
            }
            if (blockType.equals((Object)BlockEntityType.DECORATED_POT) || blockType.equals((Object)BlockEntityType.JUKEBOX) || blockType.equals((Object)BlockEntityType.LECTERN)) {
                return InventoryRenderType.SINGLE_ITEM;
            }
            if (blockType.equals((Object)BlockEntityType.CHISELED_BOOKSHELF)) {
                return InventoryRenderType.BOOKSHELF;
            }
            if (blockType.equals((Object)BlockEntityType.ENDER_CHEST)) {
                return InventoryRenderType.ENDER_CHEST;
            }
        }
        if ((entityType = NbtEntityUtils.getEntityTypeFromNbt(nbt)) != null) {
            if (entityType.equals((Object)EntityType.CHEST_MINECART) || entityType.equals((Object)EntityType.CHEST_BOAT)) {
                return InventoryRenderType.FIXED_27;
            }
            if (entityType.equals((Object)EntityType.HOPPER_MINECART)) {
                return InventoryRenderType.HOPPER;
            }
            if (entityType.equals((Object)EntityType.HORSE) || entityType.equals((Object)EntityType.DONKEY) || entityType.equals((Object)EntityType.MULE) || entityType.equals((Object)EntityType.CAMEL) || entityType.equals((Object)EntityType.SKELETON_HORSE) || entityType.equals((Object)EntityType.ZOMBIE_HORSE)) {
                return InventoryRenderType.HORSE;
            }
            if (entityType.equals((Object)EntityType.LLAMA) || entityType.equals((Object)EntityType.TRADER_LLAMA)) {
                return InventoryRenderType.LLAMA;
            }
            if (entityType.equals((Object)EntityType.WOLF)) {
                return InventoryRenderType.WOLF;
            }
            if (entityType.equals((Object)EntityType.VILLAGER) || entityType.equals((Object)EntityType.ALLAY) || entityType.equals((Object)EntityType.PILLAGER) || entityType.equals((Object)EntityType.PIGLIN) || entityType.equals((Object)EntityType.WANDERING_TRADER) || entityType.equals((Object)EntityType.ZOMBIE_VILLAGER)) {
                return InventoryRenderType.VILLAGER;
            }
            if (entityType.equals((Object)EntityType.PLAYER)) {
                return InventoryRenderType.PLAYER;
            }
            if (entityType.equals((Object)EntityType.ARMOR_STAND)) {
                return InventoryRenderType.ARMOR_STAND;
            }
            if (nbt.contains("attributes") || nbt.contains("active_effects") || nbt.contains("ArmorItems")) {
                return InventoryRenderType.LIVING_ENTITY;
            }
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryRenderType getBestInventoryType(@Nonnull Container inv, @Nonnull CompoundTag nbt) {
        InventoryRenderType n;
        InventoryRenderType i = InventoryOverlay.getInventoryType(inv);
        if (i != (n = InventoryOverlay.getInventoryType(nbt)) && i == InventoryRenderType.GENERIC) {
            return n;
        }
        return i;
    }

    public static InventoryRenderType getBestInventoryType(@Nonnull Container inv, @Nonnull CompoundTag nbt, Context ctx) {
        InventoryRenderType n;
        InventoryRenderType i = InventoryOverlay.getInventoryType(inv);
        if (i != (n = InventoryOverlay.getInventoryType(nbt)) && i == InventoryRenderType.GENERIC) {
            if (n != ctx.type() && ctx.type() != InventoryRenderType.GENERIC) {
                return ctx.type();
            }
            return n;
        }
        return i;
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryRenderType type, int totalSlots) {
        return InventoryOverlay.getInventoryPropsTemp(type, totalSlots, 9);
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryRenderType type, int totalSlots, int slotsPerARow) {
        InventoryOverlay.INV_PROPS_TEMP.totalSlots = totalSlots;
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 96;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 109;
            InventoryOverlay.INV_PROPS_TEMP.height = 72;
        } else if (type == InventoryRenderType.CRAFTER || type == InventoryRenderType.DISPENSER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HORSE || type == InventoryRenderType.LLAMA || type == InventoryRenderType.WOLF) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = Math.max(1, totalSlots / 3);
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = totalSlots * 18 / 3 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HOPPER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 5;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 105;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryRenderType.VILLAGER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 2;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 50;
            InventoryOverlay.INV_PROPS_TEMP.height = 86;
        } else if (type == InventoryRenderType.SINGLE_ITEM) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 32;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryRenderType.BOOKSHELF) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 50;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = 6;
        } else if (type == InventoryRenderType.BUNDLE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = slotsPerARow != 9 ? MathUtils.clamp(slotsPerARow, 6, 9) : 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = rows * InventoryOverlay.INV_PROPS_TEMP.slotsPerRow;
        } else {
            if (type == InventoryRenderType.FIXED_27 || type == InventoryRenderType.PLAYER || type == InventoryRenderType.ENDER_CHEST) {
                totalSlots = 27;
            } else if (type == InventoryRenderType.FIXED_54) {
                totalSlots = 54;
            }
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
        }
        return INV_PROPS_TEMP;
    }

    public static void renderInventoryStacks(InventoryRenderType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc, GuiGraphics drawContext) {
        InventoryOverlay.renderInventoryStacks(type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mc, drawContext, 0.0, 0.0);
    }

    public static void renderInventoryStacks(InventoryRenderType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, Minecraft mc, GuiGraphics drawContext) {
        InventoryOverlay.renderInventoryStacks(type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, disabledSlots, mc, drawContext, 0.0, 0.0);
    }

    public static void renderInventoryStacks(InventoryRenderType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc, GuiGraphics drawContext, double mouseX, double mouseY) {
        InventoryOverlay.renderInventoryStacks(type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mc, drawContext, mouseX, mouseY);
    }

    public static void renderInventoryStacks(InventoryRenderType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, Minecraft mc, GuiGraphics drawContext, double mouseX, double mouseY) {
        if (inv == null) {
            inv = new SimpleContainer(maxSlots > 0 ? maxSlots : InventoryOverlay.INV_PROPS_TEMP.totalSlots);
        }
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.renderStackAt(inv.getItem(0), startX + 8, startY + 8, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.getItem(1), startX + 8, startY + 44, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.getItem(2), startX + 68, startY + 26, 1.0f, mc, drawContext, mouseX, mouseY);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.renderStackAt(inv.getItem(0), startX + 47, startY + 42, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.getItem(1), startX + 70, startY + 49, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.getItem(2), startX + 93, startY + 42, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.getItem(3), startX + 70, startY + 8, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.getItem(4), startX + 8, startY + 8, 1.0f, mc, drawContext, mouseX, mouseY);
        } else {
            int slots = inv.getContainerSize();
            int x = startX;
            int y = startY;
            if (maxSlots < 0) {
                maxSlots = slots;
            }
            int slot = startSlot;
            int i = 0;
            while (slot < slots && i < maxSlots) {
                for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                    ItemStack stack = inv.getItem(slot).copy();
                    if (disabledSlots.contains(slot)) {
                        InventoryOverlay.renderLockedSlotAt(x - 1, y - 1, 1.0f, drawContext, mouseX, mouseY);
                    } else if (!stack.isEmpty()) {
                        InventoryOverlay.renderStackAt(stack, x, y, 1.0f, mc, drawContext, mouseX, mouseY);
                    }
                    x += 18;
                }
                x = startX;
                y += 18;
            }
        }
        if (hoveredStack != null) {
            ItemStack stack = hoveredStack.copy();
            hoveredStack = null;
            InventoryOverlay.renderStackToolTipStyled((int)mouseX, (int)mouseY, stack, mc, drawContext);
        }
    }

    public static void renderEquipmentStacks(LivingEntity entity, int x, int y, Minecraft mc, GuiGraphics drawContext) {
        InventoryOverlay.renderEquipmentStacks(entity, x, y, mc, drawContext, 0.0, 0.0);
    }

    public static void renderEquipmentStacks(LivingEntity entity, int x, int y, Minecraft mc, GuiGraphics drawContext, double mouseX, double mouseY) {
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            EquipmentSlot eqSlot = VALID_EQUIPMENT_SLOTS[i];
            ItemStack stack = entity.getItemBySlot(eqSlot);
            if (!stack.isEmpty()) {
                InventoryOverlay.renderStackAt(stack.copy(), x + xOff + 1, y + yOff + 1, 1.0f, mc, drawContext, mouseX, mouseY);
            }
            ++i;
            yOff += 18;
        }
        ItemStack stack = entity.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!stack.isEmpty()) {
            InventoryOverlay.renderStackAt(stack.copy(), x + 28, y + 36 + 7 + 1, 1.0f, mc, drawContext, mouseX, mouseY);
        }
        if (!(stack = entity.getItemBySlot(EquipmentSlot.OFFHAND)).isEmpty()) {
            InventoryOverlay.renderStackAt(stack.copy(), x + 28, y + 54 + 7 + 1, 1.0f, mc, drawContext, mouseX, mouseY);
        }
        if (hoveredStack != null) {
            stack = hoveredStack.copy();
            hoveredStack = null;
            InventoryOverlay.renderStackToolTipStyled((int)mouseX, (int)mouseY, stack, mc, drawContext);
        }
    }

    public static void renderItemStacks(NonNullList<ItemStack> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc, GuiGraphics drawContext) {
        InventoryOverlay.renderItemStacks(items, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mc, drawContext);
    }

    public static void renderItemStacks(NonNullList<ItemStack> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, Minecraft mc, GuiGraphics drawContext) {
        int slots = items.size();
        int x = startX;
        int y = startY;
        if (maxSlots < 0) {
            maxSlots = slots;
        }
        int slot = startSlot;
        int i = 0;
        while (slot < slots && i < maxSlots) {
            for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                ItemStack stack = ((ItemStack)items.get(slot)).copy();
                if (disabledSlots.contains(slot)) {
                    InventoryOverlay.renderLockedSlotAt(x - 1, y - 1, 1.0f, drawContext, 0.0, 0.0);
                } else if (!stack.isEmpty()) {
                    InventoryOverlay.renderStackAt(stack, x, y, 1.0f, mc, drawContext);
                }
                x += 18;
            }
            x = startX;
            y += 18;
        }
    }

    public static void renderStackAt(ItemStack stack, float x, float y, float scale, Minecraft mc, GuiGraphics drawContext) {
        InventoryOverlay.renderStackAt(stack, x, y, scale, mc, drawContext, 0.0, 0.0);
    }

    public static void renderStackAt(ItemStack stack, float x, float y, float scale, Minecraft mc, GuiGraphics drawContext, double mouseX, double mouseY) {
        PoseStack matrixStack = drawContext.pose();
        matrixStack.pushPose();
        matrixStack.translate(x, y, 0.0f);
        matrixStack.scale(scale, scale, 1.0f);
        RenderUtils.enableDiffuseLightingGui3D();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        drawContext.renderItem(stack.copy(), 0, 0);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        drawContext.renderItemDecorations(mc.font, stack.copyWithCount(stack.getCount()), 0, 0);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.popPose();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = stack.copy();
        }
    }

    public static void renderLockedSlotAt(float x, float y, float scale, GuiGraphics drawContext, double mouseX, double mouseY) {
        PoseStack matrixStack = drawContext.pose();
        matrixStack.pushPose();
        matrixStack.translate(x, y, 0.0f);
        matrixStack.scale(scale, scale, 1.0f);
        RenderUtils.enableDiffuseLightingGui3D();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        drawContext.blitSprite(TEXTURE_LOCKED_SLOT, 0, 0, 18, 18, 18);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.popPose();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = null;
        }
    }

    public static void renderBackgroundSlotAt(float x, float y, ResourceLocation texture, GuiGraphics drawContext) {
        InventoryOverlay.renderBackgroundSlotAt(x, y, 0.9f, texture, drawContext, 0.0, 0.0);
    }

    public static void renderBackgroundSlotAt(float x, float y, float scale, ResourceLocation texture, GuiGraphics drawContext, double mouseX, double mouseY) {
        PoseStack matrixStack = drawContext.pose();
        matrixStack.pushPose();
        matrixStack.translate(x, y, 0.0f);
        matrixStack.scale(scale, scale, 1.0f);
        RenderUtils.enableDiffuseLightingGui3D();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        drawContext.blitSprite(texture, 0, 0, 18, 18, 18);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.popPose();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = null;
        }
    }

    public static void renderStackToolTip(int x, int y, ItemStack stack, Minecraft mc, GuiGraphics drawContext) {
        List list = stack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                lines.add(String.valueOf(stack.getRarity().color()) + ((Component)list.get(i)).getString());
                continue;
            }
            lines.add(GuiBase.TXT_DARK_GRAY + ((Component)list.get(i)).getString());
        }
        RenderUtils.drawHoverText(x, y, lines, drawContext);
    }

    public static void renderStackToolTipStyled(int x, int y, ItemStack stack, Minecraft mc, GuiGraphics drawContext) {
        if (!stack.isEmpty() && mc.level != null && mc.player != null) {
            List toolTips = stack.getTooltipLines(Item.TooltipContext.of((Level)WorldUtils.getBestWorld(mc)), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
            drawContext.renderTooltip(mc.font, toolTips, stack.getTooltipImage(), x, y);
            ((RenderEventHandler)RenderEventHandler.getInstance()).onRenderTooltipLast(drawContext, stack, x, y);
        }
    }

    private static void dumpStack(ItemStack stack, @Nullable List<Component> list) {
        if (stack.isEmpty()) {
            System.out.printf("dumpStack(): [%s]\n", ItemStack.EMPTY.toString());
            return;
        }
        System.out.printf("dumpStack(): [%s]\n", stack.save((HolderLookup.Provider)WorldUtils.getBestWorld(GameWrap.getClient()).registryAccess()).toString());
        if (list != null && !list.isEmpty()) {
            int i = 0;
            for (Component entry : list) {
                System.out.printf("ToolTip[%d]: %s\n", i, entry.getString());
                ++i;
            }
        }
    }

    public static enum InventoryRenderType {
        BREWING_STAND,
        CRAFTER,
        DISPENSER,
        FURNACE,
        HOPPER,
        HORSE,
        LLAMA,
        WOLF,
        FIXED_27,
        FIXED_54,
        VILLAGER,
        PLAYER,
        ENDER_CHEST,
        BOOKSHELF,
        SINGLE_ITEM,
        BUNDLE,
        ARMOR_STAND,
        LIVING_ENTITY,
        GENERIC;

    }

    public record Context(InventoryRenderType type, @Nullable Container inv, @Nullable BlockEntity be, @Nullable LivingEntity entity, @Nullable CompoundTag nbt, Refresher handler) {
    }

    public static class InventoryProperties {
        public int totalSlots = 1;
        public int width = 176;
        public int height = 83;
        public int slotsPerRow = 9;
        public int slotOffsetX = 8;
        public int slotOffsetY = 8;
    }

    public static interface Refresher {
        public Context onContextRefresh(Context var1, Level var2);
    }
}

