/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.mixin.network;

import fi.dy.masa.malilib.event.WorldLoadHandler;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinClientPlayNetworkHandler {
    @Shadow
    private ClientLevel level;
    @Unique
    @Nullable
    private ClientLevel worldBefore;

    @Inject(method={"handleLogin(Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V"}, at={@At(value="HEAD")})
    private void onPreJoinGameHead(ClientboundLoginPacket packet, CallbackInfo ci) {
        this.worldBefore = this.level;
    }

    @Inject(method={"handleLogin(Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/gui/screens/ReceivingLevelScreen$Reason;)V", shift=At.Shift.BEFORE)})
    private void onPreGameJoin(ClientboundLoginPacket packet, CallbackInfo ci) {
        ((WorldLoadHandler)WorldLoadHandler.getInstance()).onWorldLoadPre(this.worldBefore, this.level, Minecraft.getInstance());
    }

    @Inject(method={"handleLogin(Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V"}, at={@At(value="RETURN")})
    private void onPostGameJoin(ClientboundLoginPacket packet, CallbackInfo ci) {
        ((WorldLoadHandler)WorldLoadHandler.getInstance()).onWorldLoadPost(this.worldBefore, this.level, Minecraft.getInstance());
        this.worldBefore = null;
    }
}

