/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.interfaces;

import fi.dy.masa.malilib.interfaces.IDataSyncer;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.InventoryOverlayScreen;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public interface IInventoryOverlayHandler {
    public String getModId();

    public IDataSyncer getDataSyncer();

    public void setDataSyncer(IDataSyncer var1);

    public InventoryOverlay.Refresher getRefreshHandler();

    public boolean isEmpty();

    @Nullable
    public InventoryOverlay.Context getRenderContextNullable();

    @Nullable
    public InventoryOverlay.Context getRenderContext(GuiGraphics var1, ProfilerFiller var2, Minecraft var3);

    default public void renderInventoryOverlay(InventoryOverlay.Context context, GuiGraphics drawContext, Minecraft mc, boolean shulkerBGColors, boolean villagerBGColors) {
        InventoryOverlayScreen screen = new InventoryOverlayScreen(this.getModId(), context, shulkerBGColors, villagerBGColors);
        screen.init(mc, 0, 0);
        screen.render(drawContext, 0, 0, 0.0f);
    }

    default public void renderInventoryOverlay(InventoryOverlay.Context context, GuiGraphics drawContext, Minecraft mc, boolean shulkerBGColors) {
        this.renderInventoryOverlay(context, drawContext, mc, shulkerBGColors, false);
    }

    default public void renderInventoryOverlay(InventoryOverlay.Context context, GuiGraphics drawContext, Minecraft mc) {
        this.renderInventoryOverlay(context, drawContext, mc, false, false);
    }

    default public void refreshInventoryOverlay(Minecraft mc, boolean shulkerBGColors, boolean villagerBGColors) {
        this.getTargetInventory(mc);
        if (!this.isEmpty()) {
            mc.setScreen((Screen)new InventoryOverlayScreen(this.getModId(), this.getRenderContextNullable(), shulkerBGColors, villagerBGColors));
        }
    }

    default public void refreshInventoryOverlay(Minecraft mc, boolean shulkerBGColors) {
        this.refreshInventoryOverlay(mc, shulkerBGColors, false);
    }

    default public void refreshInventoryOverlay(Minecraft mc) {
        this.refreshInventoryOverlay(mc, false, false);
    }

    @Nullable
    default public Pair<BlockEntity, CompoundTag> requestBlockEntityAt(Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel)) {
            ChestType type;
            Pair<BlockEntity, CompoundTag> pair = this.getDataSyncer().requestBlockEntity(world, pos);
            BlockState state = world.getBlockState(pos);
            if (state.getBlock() instanceof ChestBlock && (type = (ChestType)state.getValue((Property)ChestBlock.TYPE)) != ChestType.SINGLE) {
                return this.getDataSyncer().requestBlockEntity(world, pos.relative(ChestBlock.getConnectedDirection((BlockState)state)));
            }
            return pair;
        }
        return null;
    }

    @Nullable
    public InventoryOverlay.Context getTargetInventory(Minecraft var1);

    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromBlock(Level var1, BlockPos var2, @Nullable BlockEntity var3, CompoundTag var4);

    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromEntity(Entity var1, CompoundTag var2);
}

