/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.value;

import fi.dy.masa.malilib.config.value.OptionListConfigValue;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class BaseOptionListConfigValue
implements OptionListConfigValue {
    protected final String name;
    protected final String translationKey;

    public BaseOptionListConfigValue(String name, String translationKey) {
        this.name = name;
        this.translationKey = translationKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    public String toString() {
        return this.name;
    }

    public static <T extends OptionListConfigValue> T findValueByName(String name, List<T> values) {
        return (T)BaseOptionListConfigValue.findValueByName(name, values, (OptionListConfigValue)values.get(0));
    }

    public static <T extends OptionListConfigValue> T findValueByName(String name, List<T> values, @Nullable T fallback) {
        for (OptionListConfigValue val : values) {
            if (!val.getName().equalsIgnoreCase(name)) continue;
            return (T)val;
        }
        return fallback;
    }
}

