/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.common;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.Constants;
import net.mehvahdjukaar.jeed.recipes.EffectProviderRecipe;
import net.mehvahdjukaar.jeed.recipes.PotionProviderRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.material.Fluid;

public abstract class EffectInfo {
    private static final Supplier<Map<MobEffect, List<ItemStack>>> STATIC_CACHE = Suppliers.memoize(EffectInfo::buildStaticCache);
    protected final List<FormattedText> description;
    protected final MobEffectInstance effect;

    protected EffectInfo(MobEffectInstance effectInstance, List<FormattedText> description) {
        this.description = description;
        this.effect = effectInstance;
    }

    public List<FormattedText> getDescription() {
        return this.description;
    }

    public MobEffectInstance getEffect() {
        return this.effect;
    }

    private static Map<MobEffect, List<ItemStack>> buildStaticCache() {
        HashMap<MobEffect, List<ItemStack>> effectProvidingItems = new HashMap<MobEffect, List<ItemStack>>();
        for (Block b : BuiltInRegistries.BLOCK) {
            if (!(b instanceof FlowerBlock)) continue;
            FlowerBlock flowerblock = (FlowerBlock)b;
            ItemStack stew = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW);
            SuspiciousStewEffects effects = flowerblock.getSuspiciousEffects();
            stew.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)effects);
            for (SuspiciousStewEffects.Entry e : effects.effects()) {
                effectProvidingItems.computeIfAbsent((MobEffect)e.effect().value(), s -> new ItemStackList()).add(stew);
            }
        }
        for (Item i : BuiltInRegistries.ITEM) {
            FoodProperties food = (FoodProperties)i.getDefaultInstance().get(DataComponents.FOOD);
            if (food == null) continue;
            ItemStack foodItem = new ItemStack((ItemLike)i);
            for (FoodProperties.PossibleEffect possibleEffect : food.effects()) {
                MobEffectInstance first = possibleEffect.effect();
                if (first == null) continue;
                effectProvidingItems.computeIfAbsent((MobEffect)first.getEffect().value(), s -> new ItemStackList()).add(foodItem);
            }
        }
        for (List array : BeaconBlockEntity.BEACON_EFFECTS) {
            for (Holder e : array) {
                effectProvidingItems.computeIfAbsent((MobEffect)e.value(), s -> new ItemStackList()).add(Items.BEACON.getDefaultInstance());
            }
        }
        return effectProvidingItems;
    }

    public static List<Holder<MobEffect>> computeEffectProviders(MobEffect effect) {
        ArrayList<Holder<MobEffect>> list = new ArrayList<Holder<MobEffect>>();
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            List recipes = world.getRecipeManager().getAllRecipesFor(Jeed.getEffectProviderType());
            for (RecipeHolder recipeHolder : recipes) {
                EffectProviderRecipe recipe = (EffectProviderRecipe)recipeHolder.value();
                for (Holder<MobEffect> holder : recipe.getEffects()) {
                    if (holder.value() != effect) continue;
                    recipe.effectProviders().forEach(list::add);
                }
            }
        }
        if (Jeed.sortIngredients()) {
            list.sort((o1, o2) -> Constants.ID_COMPARATOR.compare(((ResourceKey)o1.unwrapKey().get()).location(), ((ResourceKey)o2.unwrapKey().get()).location()));
        }
        return list;
    }

    public static List<Holder<Fluid>> computeFluidProvides(MobEffect effect) {
        ArrayList<Holder<Fluid>> list = new ArrayList<Holder<Fluid>>();
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            List recipes = world.getRecipeManager().getAllRecipesFor(Jeed.getEffectProviderType());
            for (RecipeHolder recipeHolder : recipes) {
                EffectProviderRecipe recipe = (EffectProviderRecipe)recipeHolder.value();
                for (Holder<MobEffect> holder : recipe.getEffects()) {
                    if (holder.value() != effect) continue;
                    recipe.fluidProviders().forEach(list::add);
                }
            }
        }
        if (Jeed.sortIngredients()) {
            list.sort((o1, o2) -> Constants.ID_COMPARATOR.compare(((ResourceKey)o1.unwrapKey().get()).location(), ((ResourceKey)o2.unwrapKey().get()).location()));
        }
        return list;
    }

    public static List<ItemStack> computeItemProviders(MobEffect effect) {
        List<ItemStack> stat;
        ItemStackList list = new ItemStackList();
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            List recipes = world.getRecipeManager().getAllRecipesFor(Jeed.getEffectProviderType());
            for (RecipeHolder recipeHolder : recipes) {
                EffectProviderRecipe recipe = (EffectProviderRecipe)recipeHolder.value();
                for (Holder<MobEffect> holder : recipe.getEffects()) {
                    if (holder.value() != effect) continue;
                    for (Ingredient i : recipe.getIngredients()) {
                        list.addAll(List.of(i.getItems()));
                    }
                }
            }
            List potionRecipes = world.getRecipeManager().getAllRecipesFor(Jeed.getPotionProviderType());
            for (RecipeHolder recipeHolder : potionRecipes) {
                PotionProviderRecipe recipe = (PotionProviderRecipe)recipeHolder.value();
                for (Holder<Potion> potion : recipe.getPotions()) {
                    String path;
                    if (!((Potion)potion.value()).getEffects().stream().anyMatch(e -> e.getEffect().value() == effect) || Jeed.ignoreDerivativePotions() && ((path = ((ResourceKey)potion.unwrapKey().get()).location().getPath()).startsWith("long_") || path.startsWith("strong_"))) continue;
                    for (Ingredient ing : recipe.getIngredients()) {
                        for (ItemStack stack : ing.getItems()) {
                            ItemStack copy = stack.copy();
                            PotionContents potionContents = new PotionContents(Optional.of(potion), Optional.empty(), List.of());
                            copy.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
                            list.add(copy);
                        }
                    }
                }
            }
        }
        if ((stat = STATIC_CACHE.get().get(effect)) != null) {
            list.addAll(stat);
        }
        if (Jeed.sortIngredients()) {
            list.sort((o1, o2) -> Constants.ID_COMPARATOR.compare(((ResourceKey)o1.getItemHolder().unwrapKey().get()).location(), ((ResourceKey)o2.getItemHolder().unwrapKey().get()).location()));
        }
        return list;
    }

    public static List<Ingredient> groupIngredients(List<ItemStack> ingredients) {
        HashMap<Item, Ingredient> map = new HashMap<Item, Ingredient>();
        for (ItemStack stack : ingredients) {
            map.merge(stack.getItem(), Ingredient.of((ItemStack[])new ItemStack[]{stack}), EffectInfo::mergeIngredients);
        }
        ArrayList entryList = new ArrayList(map.entrySet());
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        for (Map.Entry entry : entryList) {
            list.add((Ingredient)entry.getValue());
        }
        return list;
    }

    private static Ingredient mergeIngredients(Ingredient ingredient, Ingredient ingredient1) {
        return EffectInfo.mergeIngredients(List.of(ingredient, ingredient1));
    }

    public static Ingredient mergeIngredients(List<Ingredient> ingredients) {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        for (Ingredient i : ingredients) {
            l.addAll(Arrays.stream(i.getItems()).toList());
        }
        return Ingredient.of((ItemStack[])l.toArray(new ItemStack[0]));
    }

    public static <T, I> List<I> divideIntoSlots(List<T> ingredients, Function<List<T>, I> mapper) {
        ArrayList slotContents = new ArrayList();
        for (int slotId = 0; slotId < ingredients.size(); ++slotId) {
            int ind = slotId % (Constants.SLOTS_PER_ROW * Constants.ROWS);
            if (slotContents.size() <= ind) {
                slotContents.add(new ArrayList());
            }
            ((List)slotContents.get(ind)).add(ingredients.get(slotId));
        }
        return slotContents.stream().map(mapper).toList();
    }

    public static Component getDescription(Holder<MobEffect> effect) {
        ResourceLocation name = ((ResourceKey)effect.unwrapKey().get()).location();
        String descriptionKey = "effect." + name.getNamespace() + "." + name.getPath() + ".description";
        MutableComponent text = Component.translatable((String)descriptionKey);
        if (text.getString().equals(descriptionKey)) {
            text = Component.translatable((String)"jeed.description.missing");
        }
        return text;
    }

    public static int getListHeight(List<?> inputs) {
        int listH = 0;
        if (Jeed.hasIngredientList() && !inputs.isEmpty()) {
            listH = Constants.MAX_BOX_HEIGHT;
            if (inputs.size() <= Constants.SLOTS_PER_ROW) {
                listH /= 2;
            }
        }
        return listH;
    }

    private static class ItemStackList
    extends ArrayList<ItemStack> {
        @Override
        public boolean add(ItemStack stack) {
            if (stack.isEmpty()) {
                return false;
            }
            for (ItemStack thisStack : this) {
                if (!ItemStack.matches((ItemStack)thisStack, (ItemStack)stack)) continue;
                return false;
            }
            return super.add(stack);
        }
    }
}

