/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivelanterns;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import toni.immersivelanterns.foundation.IPlayerLanternDataAccessor;
import toni.immersivelanterns.foundation.ImmersiveLanternsMixinConfigPlugin;
import toni.immersivelanterns.foundation.config.AllConfigs;

public class BaseLanternRenderer {
    Vec3 updatePendulum(Player player, Vec3 newPos, double dt) {
        Vec3 oldPos;
        if (ImmersiveLanternsMixinConfigPlugin.isIrisRenderingShadows()) {
            return Vec3.ZERO;
        }
        IPlayerLanternDataAccessor lanternData = (IPlayerLanternDataAccessor)player;
        Double forceStrength = (Double)AllConfigs.client().bounciness.get();
        boolean wasCrouching = lanternData.immersiveLanterns$getWasCrouching();
        boolean isCrouching = player.isCrouching();
        lanternData.immersiveLanterns$setWasCrouching(isCrouching);
        float zAngle = lanternData.immersiveLanterns$getZAngle();
        float zVel = lanternData.immersiveLanterns$getZVel();
        float xAngle = lanternData.immersiveLanterns$getXAngle();
        float xVel = lanternData.immersiveLanterns$getXVel();
        if (!wasCrouching && isCrouching) {
            xAngle = 0.3926991f;
            zAngle = 0.31415927f;
        }
        if ((oldPos = lanternData.immersiveLanterns$getLastHipPosition()) == null) {
            oldPos = newPos;
        }
        Vec3 delta = newPos.subtract(oldPos);
        Vec3 deltaForward = this.transformToPlayerRelativeMovement(delta, player.getForward());
        double zForce = (double)9.81f * Math.sin(zAngle);
        zForce += deltaForward.z * forceStrength * -50.0;
        double zAccel = -1.0 * (zForce += deltaForward.y * forceStrength * -20.0);
        zVel += (float)(zAccel * (dt / 20.0));
        zAngle += (float)((double)(zVel *= 0.98f) * (dt / 20.0));
        zAngle = Math.max(-1.0471976f, Math.min(1.0471976f, zAngle));
        double xForce = (double)9.81f * Math.sin(xAngle);
        xForce += deltaForward.x * forceStrength * -50.0;
        double xAccel = -1.0 * (xForce += deltaForward.y * forceStrength * -20.0);
        xVel += (float)(xAccel * (dt / 20.0));
        xAngle += (float)((double)(xVel *= 0.98f) * (dt / 20.0));
        xAngle = Math.max(-1.0471976f, Math.min(1.0471976f, xAngle));
        lanternData.immersiveLanterns$setZVel(Mth.clamp((float)zVel, (float)-3.0f, (float)3.0f));
        lanternData.immersiveLanterns$setZAngle(zAngle);
        lanternData.immersiveLanterns$setXVel(Mth.clamp((float)xVel, (float)-3.0f, (float)3.0f));
        lanternData.immersiveLanterns$setXAngle(xAngle);
        lanternData.immersiveLanterns$setLastHipPosition(newPos);
        return new Vec3(Math.abs(xAngle) < 0.01f ? 0.0 : (double)xAngle, 0.0, Math.abs(zAngle) < 0.01f ? 0.0 : (double)zAngle);
    }

    public Vec3 transformToPlayerRelativeMovement(Vec3 deltaMovement, Vec3 forwardVector) {
        Vec3 forward = forwardVector.normalize();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 right = forward.cross(up).normalize();
        up = right.cross(forward).normalize();
        double localForward = deltaMovement.dot(forward);
        double localRight = deltaMovement.dot(right);
        double localUp = deltaMovement.dot(up);
        return new Vec3(localRight, localUp, localForward);
    }
}

