/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.mixin;

import immersive_melodies.Config;
import immersive_melodies.item.InstrumentItem;
import immersive_melodies.util.EntityEquiper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobEntityMixin
extends LivingEntity {
    @Shadow
    @Final
    private NonNullList<ItemStack> handItems;

    @Shadow
    protected abstract Vec3i getPickupReach();

    @Shadow
    protected abstract void pickUpItem(ItemEntity var1);

    protected MobEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void immersiveMelodies$injectInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        for (ItemStack handItem : this.handItems) {
            if (!(handItem.getItem() instanceof InstrumentItem)) continue;
            ItemEntity itemEntity = this.spawnAtLocation(handItem.copyAndClear());
            if (itemEntity != null) {
                itemEntity.setThrower((Entity)this);
            }
            cir.setReturnValue((Object)InteractionResult.CONSUME);
            break;
        }
    }

    @Inject(method={"baseTick()V"}, at={@At(value="TAIL")})
    private void immersiveMelodies$injectBaseTick(CallbackInfo ci) {
        if (Config.getInstance().forceMobsToPickUp && EntityEquiper.canPickUp((Entity)this) && !this.level().isClientSide && this.isAlive() && !this.dead) {
            Vec3i vec3i = this.getPickupReach();
            for (ItemEntity itementity : this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate((double)vec3i.getX(), (double)vec3i.getY(), (double)vec3i.getZ()))) {
                if (itementity.getOwner() != null && itementity.getOwner().getUUID().equals(this.getUUID()) || itementity.isRemoved() || itementity.getItem().isEmpty() || !(itementity.getItem().getItem() instanceof InstrumentItem)) continue;
                this.pickUpItem(itementity);
            }
        }
    }

    @Inject(method={"canReplaceCurrentItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void immersiveMelodies$injectCanReplaceCurrentItem(ItemStack newStack, ItemStack oldStack, CallbackInfoReturnable<Boolean> cir) {
        if (newStack.getItem() instanceof InstrumentItem && !(oldStack.getItem() instanceof InstrumentItem)) {
            cir.setReturnValue((Object)true);
        } else if (oldStack.getItem() instanceof InstrumentItem) {
            cir.setReturnValue((Object)false);
        }
    }
}

