/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.item;

import com.mojang.serialization.Codec;
import immersive_melodies.Common;
import immersive_melodies.Config;
import immersive_melodies.Sounds;
import immersive_melodies.client.MelodyProgress;
import immersive_melodies.client.MelodyProgressManager;
import immersive_melodies.client.sound.CancelableSoundInstance;
import immersive_melodies.network.Network;
import immersive_melodies.network.s2c.MelodyListMessage;
import immersive_melodies.network.s2c.OpenGuiRequest;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.Note;
import immersive_melodies.resources.ServerMelodyManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class InstrumentItem
extends Item {
    public static final DataComponentType<Boolean> PLAYING = (DataComponentType)Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"playing", (Object)DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final DataComponentType<ResourceLocation> MELODY = (DataComponentType)Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"melody", (Object)DataComponentType.builder().persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC).build());
    public static final DataComponentType<Long> START_TIME = (DataComponentType)Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"start_time", (Object)DataComponentType.builder().persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG).build());
    public static final DataComponentType<List<Integer>> TRACKS = (DataComponentType)Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"enabled_tracks", (Object)DataComponentType.builder().persistent(Codec.list((Codec)Codec.INT)).networkSynchronized(ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list())).build());
    private final Sounds.Instrument sound;
    private final long sustain;
    private final Vector3f offset;

    public InstrumentItem(Item.Properties settings, Sounds.Instrument sound, long sustain, Vector3f offset) {
        super(settings);
        this.sound = sound;
        this.sustain = sustain;
        this.offset = offset;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!world.isClientSide) {
            Network.sendToPlayer(new MelodyListMessage(user), (ServerPlayer)user);
            Network.sendToPlayer(new OpenGuiRequest(), (ServerPlayer)user);
        }
        return super.use(world, user, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        if (this.isPlaying(stack)) {
            components.add((Component)Component.translatable((String)"immersive_melodies.playing").withStyle(ChatFormatting.GREEN));
        }
        super.appendHoverText(stack, context, components, tooltipFlag);
    }

    public boolean isPlaying(ItemStack stack) {
        return (Boolean)stack.getOrDefault(PLAYING, (Object)false);
    }

    public void inventoryClientTick(ItemStack stack, Level world, LivingEntity entity) {
        boolean isPrimary = false;
        for (ItemStack handItem : entity.getHandSlots()) {
            if (handItem == stack) {
                isPrimary = true;
                break;
            }
            if (!(handItem.getItem() instanceof InstrumentItem)) continue;
            break;
        }
        if (this.isPlaying(stack) && isPrimary && world.isClientSide && Common.soundManager.audible((Entity)entity)) {
            MelodyProgress progress = MelodyProgressManager.INSTANCE.getProgress((Entity)entity);
            progress.tick(stack);
            MelodyProgressManager.INSTANCE.sync(world.getGameTime());
            Melody melody = progress.getMelody();
            List<Integer> enabledTracks = this.getEnabledTracks(stack);
            block1: for (int track = 0; track < melody.getTracks().size(); ++track) {
                int lastIndex = MelodyProgressManager.INSTANCE.getProgress((Entity)entity).getLastIndex(track);
                List<Note> notes = melody.getTracks().get(track).getNotes();
                for (int i = lastIndex; i < notes.size(); ++i) {
                    Note note = notes.get(i);
                    if (progress.getTime() >= (long)note.getTime()) {
                        if (enabledTracks.isEmpty() || enabledTracks.contains(track)) {
                            this.playNote((Entity)entity, note, progress.getTime());
                        }
                        if (i != notes.size() - 1) continue;
                        MelodyProgressManager.INSTANCE.setLastIndex((Entity)entity, track, i + 1);
                        continue;
                    }
                    MelodyProgressManager.INSTANCE.setLastIndex((Entity)entity, track, i);
                    continue block1;
                }
            }
            if (progress.getTime() > (long)melody.getLength()) {
                this.rewind(stack, world);
            }
        }
    }

    public CancelableSoundInstance playNote(Entity entity, Note note, long time) {
        int octave;
        float volume = (float)note.getVelocity() / 255.0f * 2.0f * Config.getInstance().instrumentVolumeFactor;
        float pitch = (float)Math.pow(2.0, (double)(note.getNote() - 24) / 12.0);
        for (octave = 1; octave < 8 && (double)pitch > 1.3333333333333333; ++octave) {
            pitch /= 2.0f;
        }
        long length = note.getLength();
        long sustain = Math.min(this.sustain, (long)note.getSustain());
        float factor = Config.getInstance().perceivedLoudnessAdjustmentFactor;
        float adjustedVolume = (float)((double)volume / Math.sqrt((double)pitch * Math.pow(2.0, octave - 4)));
        volume = volume * (1.0f - factor) + adjustedVolume * factor;
        CancelableSoundInstance soundInstance = Common.soundManager.playSound(entity.getX(), entity.getY(), entity.getZ(), this.sound.get(octave), SoundSource.NEUTRAL, volume, pitch, length, sustain, (long)note.getTime() - time, entity);
        if (entity instanceof Player && Config.getInstance().stopGameMusicForPlayers) {
            Common.soundManager.pauseGameMusic();
        } else if (Config.getInstance().stopGameMusicForMobs) {
            Common.soundManager.pauseGameMusic();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!Common.soundManager.isFirstPerson(entity)) {
                double x = Math.sin((double)(-livingEntity.yBodyRot) / 180.0 * Math.PI);
                double z = Math.cos((double)(-livingEntity.yBodyRot) / 180.0 * Math.PI);
                entity.level().addParticle((ParticleOptions)ParticleTypes.NOTE, entity.getX() + x * (double)this.offset.z + z * (double)this.offset.x, entity.getY() + (double)entity.getBbHeight() / 2.0 + (double)this.offset.y, entity.getZ() + z * (double)this.offset.z - x * (double)this.offset.x, x * 5.0, 0.0, z * 5.0);
            }
        }
        MelodyProgressManager.INSTANCE.setLastNote(entity, volume, pitch, length);
        return soundInstance;
    }

    public void inventoryServerTick(ItemStack stack, ServerLevel world, Entity entity) {
        if (!(entity instanceof Player) && !this.isPlaying(stack)) {
            ResourceLocation randomMelody = ServerMelodyManager.getRandomMelody();
            this.play(stack, randomMelody, (Level)world, entity);
        }
    }

    public void play(ItemStack stack, ResourceLocation melody, Level world, Entity entity) {
        stack.set(MELODY, (Object)melody);
        stack.set(PLAYING, (Object)true);
        stack.set(START_TIME, (Object)world.getGameTime());
        this.refreshTracks(stack, entity);
    }

    public static ResourceLocation getMelody(ItemStack stack) {
        return (ResourceLocation)stack.getOrDefault(MELODY, (Object)Common.locate("default"));
    }

    public void refreshTracks(ItemStack stack, Entity entity) {
        String identifier = ServerMelodyManager.getIdentifier(entity, BuiltInRegistries.ITEM.getKey((Object)this));
        Set<Integer> enabledTracks = ServerMelodyManager.getSettings().getEnabledTracks(InstrumentItem.getMelody(stack), identifier);
        stack.set(TRACKS, new ArrayList<Integer>(enabledTracks));
    }

    public void rewind(ItemStack stack, Level world) {
        stack.set(START_TIME, (Object)world.getGameTime());
    }

    public void play(ItemStack stack) {
        stack.set(PLAYING, (Object)true);
    }

    public void pause(ItemStack stack) {
        stack.set(PLAYING, (Object)false);
    }

    public List<Integer> getEnabledTracks(ItemStack stack) {
        return (List)stack.getOrDefault(TRACKS, new ArrayList());
    }
}

