/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import immersive_melodies.client.gui.widget.DefaultButtonWidget;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class TexturedButtonWidget
extends DefaultButtonWidget {
    private final int u;
    private final int v;
    private final int tw;
    private final int th;
    private final int w;
    private final int h;
    private final ResourceLocation texture;

    public TexturedButtonWidget(int x, int y, int width, int height, ResourceLocation texture, int u, int v, int tw, int th, Component message, Button.OnPress onPress, Supplier<List<FormattedCharSequence>> tooltipSupplier) {
        super(x, y, width, height, message, onPress, tooltipSupplier);
        this.texture = texture;
        this.w = width;
        this.h = height;
        this.u = u;
        this.v = v;
        this.tw = tw;
        this.th = th;
    }

    @Override
    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.isHovered) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.75f, (float)0.75f, (float)this.alpha);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        }
        context.blit(this.texture, this.getX(), this.getY(), (float)this.u, (float)(this.v + (this.active ? 0 : 16)), this.w, this.h, this.tw, this.th);
        int j = this.active ? 0xFFFFFF : 0xA0A0A0;
        context.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }
}

