/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class CustomInventoryModels {
    private static final Map<Item, ModelResourceLocation> handIdentifierCache = new HashMap<Item, ModelResourceLocation>();
    private static final Map<Item, ModelResourceLocation> identifierCache = new HashMap<Item, ModelResourceLocation>();

    public static ModelResourceLocation computeHandIdentifier(ResourceLocation id) {
        return new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getPath() + "_hand")), "inventory");
    }

    public static ModelResourceLocation computeIdentifier(ResourceLocation id) {
        return new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath()), "inventory");
    }

    public static ModelResourceLocation computeHandIdentifier(Item item) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        return CustomInventoryModels.computeHandIdentifier(id);
    }

    public static ModelResourceLocation computeIdentifier(Item item) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        return CustomInventoryModels.computeIdentifier(id);
    }

    public static ModelResourceLocation getHandIdentifier(Item item) {
        return handIdentifierCache.computeIfAbsent(item, CustomInventoryModels::computeHandIdentifier);
    }

    public static ModelResourceLocation getIdentifier(Item item) {
        return identifierCache.computeIfAbsent(item, CustomInventoryModels::computeIdentifier);
    }
}

