/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies;

import immersive_melodies.Common;
import immersive_melodies.Sounds;
import immersive_melodies.client.animation.ItemAnimators;
import immersive_melodies.client.animation.animators.Animator;
import immersive_melodies.item.InstrumentItem;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public interface Items {
    public static final Map<ResourceLocation, Item> items = new ConcurrentHashMap<ResourceLocation, Item>();
    public static final List<ResourceLocation> customInventoryModels = new LinkedList<ResourceLocation>();
    public static final Item BAGPIPE = Items.register("immersive_melodies", "bagpipe", 300L, new Vector3f(0.5f, 0.6f, 0.05f));
    public static final Item DIDGERIDOO = Items.register("immersive_melodies", "didgeridoo", 400L, new Vector3f(0.0f, -0.45f, 1.0f));
    public static final Item FLUTE = Items.register("immersive_melodies", "flute", 100L, new Vector3f(0.0f, 0.15f, 0.9f));
    public static final Item LUTE = Items.register("immersive_melodies", "lute", 300L, new Vector3f(0.0f, 0.0f, 0.5f));
    public static final Item PIANO = Items.register("immersive_melodies", "piano", 500L, new Vector3f(0.0f, 0.25f, 0.5f));
    public static final Item TRIANGLE = Items.register("immersive_melodies", "triangle", 300L, new Vector3f(0.0f, 0.0f, 0.6f));
    public static final Item TRUMPET = Items.register("immersive_melodies", "trumpet", 100L, new Vector3f(0.0f, 0.25f, 1.4f));
    public static final Item TINY_DRUM = Items.register("immersive_melodies", "tiny_drum", 500L, new Vector3f(0.0f, 0.25f, 0.5f));
    public static final Item VIELLE = Items.register("immersive_melodies", "vielle", 200L, new Vector3f(-0.25f, 0.4f, 0.35f));
    public static final Item ENDER_BASS = Items.register("immersive_melodies", "ender_bass", 100L, new Vector3f(0.0f, 0.0f, 0.65f));
    public static final Item HANDPAN = Items.register("immersive_melodies", "handpan", 300L, new Vector3f(0.0f, 0.25f, 0.5f));

    public static Item register(@NotNull String namespace, @NotNull String name, Animator animator, long sustain, Vector3f offset) {
        ResourceLocation identifier = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name);
        ItemAnimators.register(identifier, animator);
        return Items.register(namespace, name, sustain, offset);
    }

    public static Item register(@NotNull String namespace, @NotNull String name, long sustain, Vector3f offset) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name);
        Sounds.Instrument instrument = new Sounds.Instrument(namespace, name);
        InstrumentItem item = new InstrumentItem(Items.baseProps(), instrument, sustain, offset);
        items.put(location, item);
        customInventoryModels.add(location);
        return item;
    }

    public static void bootstrap() {
    }

    public static Item.Properties baseProps() {
        return new Item.Properties().stacksTo(1);
    }

    public static Collection<ItemStack> getSortedItems() {
        return items.values().stream().map(Item::getDefaultInstance).toList();
    }

    public static void registerItems(Common.RegisterHelper<Item> helper) {
        items.forEach(helper::register);
    }
}

