/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.renderers.entities.projectiles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import tech.alexnijjar.golemoverhaul.common.entities.projectiles.CandleFlameProjectile;

public class CandleFlameProjectileRenderer
extends EntityRenderer<CandleFlameProjectile> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/particle/flame.png");

    public CandleFlameProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(CandleFlameProjectile entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        this.renderQuad(poseStack.last().pose());
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    private void renderQuad(Matrix4f matrix) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, -0.25f, -0.4f, 0.0f).setUv(1.0f, 0.0f);
        buffer.addVertex(matrix, 0.25f, -0.4f, 0.0f).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, 0.25f, 0.1f, 0.0f).setUv(0.0f, 1.0f);
        buffer.addVertex(matrix, -0.25f, 0.1f, 0.0f).setUv(1.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public ResourceLocation getTextureLocation(CandleFlameProjectile entity) {
        return TEXTURE;
    }
}

