/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base;

import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.EntityType;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemRenderer;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;

public class BaseGolemModel<T extends BaseGolem>
extends DefaultedEntityGeoModel<T> {
    private final boolean turnsHead;
    private final int maxHeadRotation;
    private final ResourceLocation textureDamaged;
    private final ResourceLocation textureVeryDamaged;

    public BaseGolemModel(RegistryEntry<EntityType<T>> golem, boolean turnsHead, int maxHeadRotation) {
        this(BaseGolemRenderer.name(golem), BaseGolemRenderer.texture(golem), BaseGolemRenderer.name(golem), turnsHead, maxHeadRotation);
    }

    public BaseGolemModel(ResourceLocation model, ResourceLocation texture, ResourceLocation animation, boolean turnsHead, int maxHeadRotation) {
        this(model, ResourceLocation.fromNamespaceAndPath((String)texture.getNamespace(), (String)"%s_1".formatted(texture.getPath())), ResourceLocation.fromNamespaceAndPath((String)texture.getNamespace(), (String)"textures/entity/%s_2.png".formatted(texture.getPath())), ResourceLocation.fromNamespaceAndPath((String)texture.getNamespace(), (String)"textures/entity/%s_3.png".formatted(texture.getPath())), animation, turnsHead, maxHeadRotation);
    }

    public BaseGolemModel(ResourceLocation model, ResourceLocation texture, ResourceLocation textureDamaged, ResourceLocation textureVeryDamaged, ResourceLocation animation, boolean turnsHead, int maxHeadRotation) {
        super(model, turnsHead);
        this.withAltTexture(texture);
        this.withAltAnimations(animation);
        this.turnsHead = turnsHead;
        this.textureDamaged = textureDamaged;
        this.textureVeryDamaged = textureVeryDamaged;
        this.maxHeadRotation = maxHeadRotation;
    }

    public void setCustomAnimations(T golem, long instanceId, AnimationState<T> animationState) {
        if (!this.turnsHead) {
            return;
        }
        GeoBone head = this.getAnimationProcessor().getBone("head_rotation");
        if (head == null) {
            return;
        }
        if (head.getChildBones().isEmpty()) {
            return;
        }
        GeoBone headRotation = (GeoBone)head.getChildBones().getFirst();
        if (headRotation == null) {
            return;
        }
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        headRotation.setRotX(Mth.clamp((float)entityData.headPitch(), (float)(-this.maxHeadRotation), (float)this.maxHeadRotation) * ((float)Math.PI / 180));
        headRotation.setRotY(Mth.clamp((float)entityData.netHeadYaw(), (float)(-this.maxHeadRotation), (float)this.maxHeadRotation) * ((float)Math.PI / 180));
    }

    public ResourceLocation getTextureResource(T golem) {
        return switch (((BaseGolem)((Object)golem)).getCrackiness()) {
            default -> throw new MatchException(null, null);
            case Crackiness.Level.NONE, Crackiness.Level.LOW -> super.getTextureResource(golem);
            case Crackiness.Level.MEDIUM -> this.textureDamaged;
            case Crackiness.Level.HIGH -> this.textureVeryDamaged;
        };
    }
}

