/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.renderers.entities.golems;

import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemModel;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemRenderer;
import tech.alexnijjar.golemoverhaul.common.entities.golems.TerracottaGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class TerracottaGolemRenderer
extends BaseGolemRenderer<TerracottaGolem> {
    public static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"geo/entity/terracotta/terracotta_golem.geo.json");
    public static final ResourceLocation CACTUS_MODEL = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"geo/entity/terracotta/cactus_terracotta_golem.geo.json");
    public static final ResourceLocation DEAD_BUSH_MODEL = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"geo/entity/terracotta/dead_bush_terracotta_golem.geo.json");

    public TerracottaGolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new BaseGolemModel<TerracottaGolem>(ModEntityTypes.TERRACOTTA_GOLEM, true, 10){

            public ResourceLocation getModelResource(TerracottaGolem golem) {
                return switch (golem.getTerracottaType()) {
                    default -> throw new MatchException(null, null);
                    case TerracottaGolem.Type.NORMAL -> MODEL;
                    case TerracottaGolem.Type.CACTUS -> CACTUS_MODEL;
                    case TerracottaGolem.Type.DEAD_BUSH -> DEAD_BUSH_MODEL;
                };
            }
        });
    }
}

