/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.compat.rei;

import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import tech.alexnijjar.golemoverhaul.client.compat.FakeLevel;
import tech.alexnijjar.golemoverhaul.common.recipes.GolemConstructionRecipe;

public class GolemConstructionWidget
extends Widget {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"textures/gui/container/golem_construction.png");
    private final FakeLevel fakeLevel;
    private final Entity entity;
    private final int x;
    private final int y;
    private final float blockScale;
    private final float entityScale;
    private final boolean single;
    private final MutableComponent blockTooltip = Component.empty();

    public GolemConstructionWidget(GolemConstructionRecipe recipe, int x, int y) {
        this.x = x;
        this.y = y;
        this.blockScale = recipe.blockScale();
        this.entityScale = recipe.entityScale();
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        this.fakeLevel = new FakeLevel(blocks);
        int width = recipe.pattern().getFirst().length();
        int height = recipe.pattern().size();
        this.single = width == 1 && height == 1;
        for (int i = 0; i < height; ++i) {
            String row = recipe.pattern().get(i);
            for (int j = 0; j < width; ++j) {
                char c = row.charAt(j);
                ResourceKey<Block> key = recipe.key().get(String.valueOf(c));
                if (key == null) {
                    throw new IllegalStateException("Invalid key: " + c);
                }
                if (key.location().equals((Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.AIR))) continue;
                BlockState state = ((Block)BuiltInRegistries.BLOCK.getOrThrow(key)).defaultBlockState();
                blocks.put(BlockPos.containing((double)(width - j - 1), (double)(height - i - 1), (double)0.0), state);
                this.blockTooltip.append((Component)state.getBlock().getName());
                if (i == height - 1) continue;
                this.blockTooltip.append("\n");
            }
        }
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(recipe.entity());
        if (type == null) {
            throw new IllegalStateException("Invalid entity: " + String.valueOf(recipe.entity()));
        }
        this.entity = type.create((Level)Objects.requireNonNull(Minecraft.getInstance().level));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.entity.setYHeadRot(0.0f);
        graphics.blit(TEXTURE, this.x - 47, this.y - 58, 0.0f, 0.0f, 180, 76, 180, 76);
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            pose.translate((float)this.x, (float)this.y, 100.0f);
            pose.translate(10.0f, -5.0f, 0.0f);
            pose.scale(-20.0f, -20.0f, -20.0f);
            pose.scale(this.blockScale, this.blockScale, this.blockScale);
            if (this.single) {
                pose.translate(0.1, 0.2, 0.0);
            }
            pose.translate(0.5, 0.5, 0.5);
            pose.mulPose(Axis.XP.rotationDegrees(-30.0f));
            pose.mulPose(Axis.YP.rotationDegrees(45.0f));
            pose.translate(-0.5, -0.5, -0.5);
            this.fakeLevel.renderBlocks(graphics.pose());
        }
        pose = new CloseablePoseStack(graphics);
        try {
            pose.translate(95.0f, -7.0f, 0.0f);
            Vector3f ARMOR_STAND_TRANSLATION = new Vector3f();
            Quaternionf ARMOR_STAND_ANGLE = new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(135.0), (float)Math.PI);
            InventoryScreen.renderEntityInInventory((GuiGraphics)graphics, (float)this.x, (float)this.y, (float)(32.0f * this.entityScale), (Vector3f)ARMOR_STAND_TRANSLATION, (Quaternionf)ARMOR_STAND_ANGLE, null, (LivingEntity)((LivingEntity)this.entity));
        }
        finally {
            pose.close();
        }
        if (mouseX >= this.x + 68 && mouseX < this.x + 120 && mouseY >= this.y - 48 && mouseY < this.y + 8) {
            Minecraft.getInstance().screen.setTooltipForNextRenderPass(this.entity.getName());
        } else if (mouseX >= this.x - 34 && mouseX < this.x + 18 && mouseY >= this.y - 48 && mouseY < this.y + 8) {
            Minecraft.getInstance().screen.setTooltipForNextRenderPass((Component)this.blockTooltip);
        }
    }

    public List<? extends GuiEventListener> children() {
        return List.of();
    }
}

