/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.compat.jei;

import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import tech.alexnijjar.golemoverhaul.client.compat.jei.GolemConstructionDrawable;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.golemoverhaul.common.recipes.GolemConstructionRecipe;
import tech.alexnijjar.golemoverhaul.common.registry.ModItems;

public record GolemConstructionCategory(IGuiHelper guiHelper) implements IRecipeCategory<GolemConstructionRecipe>
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"golemoverhaul", (String)"golem_construction");
    public static final RecipeType<GolemConstructionRecipe> RECIPE = new RecipeType(ID, GolemConstructionRecipe.class);

    public RecipeType<GolemConstructionRecipe> getRecipeType() {
        return RECIPE;
    }

    public Component getTitle() {
        return ConstantComponents.GOLEM_CONSTRUCTION_CATEGORY;
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableItemStack(((Item)ModItems.CLAY_GOLEM_STATUE.get()).getDefaultInstance());
    }

    public int getWidth() {
        return 180;
    }

    public int getHeight() {
        return 76;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GolemConstructionRecipe recipe, IFocusGroup group) {
        recipe.key().values().stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0)).filter(Objects::nonNull).map(Block::asItem).filter(item -> item != Items.AIR).forEach(item -> builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{item})));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Objects.requireNonNull((Item)BuiltInRegistries.ITEM.get(recipe.item()))}));
    }

    public void draw(GolemConstructionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        new GolemConstructionDrawable(mouseX, mouseY, recipe, 47, 58).draw(guiGraphics);
        IDrawableStatic recipeArrow = this.guiHelper.getRecipeArrow();
        recipeArrow.draw(guiGraphics, 78, 30);
    }
}

