/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity.ai.goal;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.item.ItemStack;

public class GoblinTemptGoal
extends TemptGoal {
    private final AbstractGoblinEntity goblin;

    public GoblinTemptGoal(AbstractGoblinEntity goblin, double speedModifier, Predicate<ItemStack> predicate, boolean canScare) {
        super((PathfinderMob)goblin, speedModifier, predicate, canScare);
        this.goblin = goblin;
    }

    public boolean canUse() {
        return super.canUse() && !this.goblin.isLeashed();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.goblin.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
    }

    public void tick() {
        super.tick();
        if (this.goblin.getNavigation().isDone()) {
            this.goblin.setCurious(true);
        } else {
            this.goblin.setCurious(false);
        }
    }

    public void stop() {
        super.stop();
        this.goblin.setCurious(false);
    }
}

