/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.core;

import com.mrcrayfish.framework.api.registry.RegistryContainer;
import com.mrcrayfish.framework.api.registry.RegistryEntry;
import com.mrcrayfish.goblintraders.entity.GoblinTrader;
import com.mrcrayfish.goblintraders.entity.VeinGoblinTrader;
import com.mrcrayfish.goblintraders.util.Utils;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;

@RegistryContainer
public class ModEntities {
    public static final RegistryEntry<EntityType<GoblinTrader>> GOBLIN_TRADER = ModEntities.build("goblin_trader", GoblinTrader::new, 0.5f, 1.0f);
    public static final RegistryEntry<EntityType<VeinGoblinTrader>> VEIN_GOBLIN_TRADER = ModEntities.build("vein_goblin_trader", VeinGoblinTrader::new, 0.5f, 1.0f);

    private static <T extends Entity> RegistryEntry<EntityType<T>> build(String name, Function<Level, T> function, float width, float height) {
        return RegistryEntry.entityType((ResourceLocation)Utils.resource(name), () -> EntityType.Builder.of((entityType, world) -> (Entity)function.apply(world), (MobCategory)MobCategory.CREATURE).sized(width, height).build(name));
    }
}

