/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankException;
import dev.ftb.mods.ftbranks.impl.RankImpl;
import dev.ftb.mods.ftbranks.impl.RankManagerImpl;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class PlayerRankData {
    private final RankManagerImpl manager;
    private final UUID playerId;
    private final String name;
    private final Map<Rank, Instant> added;
    private final Map<String, PermissionValue> permissions;

    public PlayerRankData(RankManagerImpl manager, UUID playerId, String name) {
        this.manager = manager;
        this.playerId = playerId;
        this.name = name;
        this.added = new LinkedHashMap<Rank, Instant>();
        this.permissions = new LinkedHashMap<String, PermissionValue>();
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public Set<Rank> addedRanks() {
        return this.added.keySet();
    }

    public boolean addRank(Rank rank) {
        if (!this.added.containsKey(rank)) {
            this.added.put(rank, Instant.now());
            this.manager.markPlayerDataDirty();
            return true;
        }
        return false;
    }

    public boolean removeRank(Rank rank) {
        if (this.added.remove(rank) != null) {
            this.manager.markPlayerDataDirty();
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerRankData that = (PlayerRankData)o;
        return Objects.equals(this.playerId, that.playerId);
    }

    public int hashCode() {
        return Objects.hash(this.playerId);
    }

    @NotNull
    public PermissionValue getPermission(String node) {
        return this.permissions.getOrDefault(node, PermissionValue.MISSING);
    }

    SNBTCompoundTag writeSNBT() {
        SNBTCompoundTag permTag;
        SNBTCompoundTag res = new SNBTCompoundTag();
        res.putString("name", this.name);
        SNBTCompoundTag ranksTag = new SNBTCompoundTag();
        this.added.forEach((rank, when) -> {
            if (rank.getCondition().isDefaultCondition()) {
                ranksTag.putString(rank.getId(), when.toString());
            }
        });
        if (!ranksTag.isEmpty()) {
            res.put("ranks", (Tag)ranksTag);
        }
        if (!(permTag = RankManagerImpl.writePermissions(this.permissions, new SNBTCompoundTag())).isEmpty()) {
            res.put("permissions", (Tag)permTag);
        }
        return res;
    }

    static PlayerRankData fromSNBT(RankManagerImpl manager, UUID playerId, SNBTCompoundTag tag, Map<String, RankImpl> tempRanks) {
        PlayerRankData data = new PlayerRankData(manager, playerId, tag.getString("name"));
        SNBTCompoundTag ranksTag = tag.getCompound("ranks");
        for (String rankKey : ranksTag.getAllKeys()) {
            RankImpl rank = tempRanks.get(rankKey);
            if (rank == null) continue;
            try {
                data.added.put(rank, Instant.parse(ranksTag.getString(rankKey)));
            }
            catch (DateTimeParseException e) {
                throw new RankException(e.getMessage());
            }
        }
        SNBTCompoundTag permTag = tag.getCompound("permissions");
        for (String permKey : permTag.getAllKeys()) {
            while (permKey.endsWith(".*")) {
                permKey = permKey.substring(0, permKey.length() - 2);
                manager.markPlayerDataDirty();
            }
            if (permKey.isEmpty()) continue;
            data.permissions.put(playerId.toString(), RankManagerImpl.ofTag(permTag, permKey));
        }
        return data;
    }
}

