/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;

public record CopyQuestMessage(long id, long chapterId, double qx, double qy, boolean copyDeps) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CopyQuestMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("copy_quest_message"));
    public static final StreamCodec<FriendlyByteBuf, CopyQuestMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, CopyQuestMessage::id, (StreamCodec)ByteBufCodecs.VAR_LONG, CopyQuestMessage::chapterId, (StreamCodec)ByteBufCodecs.DOUBLE, CopyQuestMessage::qx, (StreamCodec)ByteBufCodecs.DOUBLE, CopyQuestMessage::qy, (StreamCodec)ByteBufCodecs.BOOL, CopyQuestMessage::copyDeps, CopyQuestMessage::new);

    public CustomPacketPayload.Type<CopyQuestMessage> type() {
        return TYPE;
    }

    public static void handle(CopyQuestMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerQuestFile file = ServerQuestFile.INSTANCE;
            QuestObject patt0$temp = file.get(message.id);
            if (patt0$temp instanceof Quest) {
                Quest toCopy = (Quest)patt0$temp;
                QuestObject patt1$temp = file.get(message.chapterId);
                if (patt1$temp instanceof Chapter) {
                    Chapter chapter = (Chapter)patt1$temp;
                    Quest newQuest = Objects.requireNonNull(QuestObjectBase.copy(toCopy, () -> new Quest(file.newID(), chapter)));
                    if (!message.copyDeps) {
                        newQuest.clearDependencies();
                    }
                    newQuest.setX(message.qx);
                    newQuest.setY(message.qy);
                    newQuest.onCreated();
                    toCopy.getTasks().forEach(task -> {
                        Task newTask = QuestObjectBase.copy(task, () -> TaskType.createTask(file.newID(), newQuest, task.getType().getTypeForNBT()));
                        if (newTask != null) {
                            newTask.onCreated();
                        }
                    });
                    for (Reward reward2 : toCopy.getRewards()) {
                        Reward newReward = QuestObjectBase.copy(reward2, () -> RewardType.createReward(file.newID(), newQuest, reward2.getType().getTypeForNBT()));
                        if (newReward == null) continue;
                        newReward.onCreated();
                    }
                    MinecraftServer server = context.getPlayer().getServer();
                    NetworkHelper.sendToAll((MinecraftServer)server, (CustomPacketPayload)CreateObjectResponseMessage.create(newQuest, null));
                    newQuest.getTasks().forEach(task -> {
                        CompoundTag extra = new CompoundTag();
                        extra.putString("type", task.getType().getTypeForNBT());
                        NetworkHelper.sendToAll((MinecraftServer)server, (CustomPacketPayload)CreateObjectResponseMessage.create(task, extra));
                    });
                    newQuest.getRewards().forEach(reward -> {
                        CompoundTag extra = new CompoundTag();
                        extra.putString("type", reward.getType().getTypeForNBT());
                        NetworkHelper.sendToAll((MinecraftServer)server, (CustomPacketPayload)CreateObjectResponseMessage.create(reward, extra));
                    });
                    ServerQuestFile.INSTANCE.refreshIDMap();
                    ServerQuestFile.INSTANCE.clearCachedData();
                    ServerQuestFile.INSTANCE.markDirty();
                }
            }
        });
    }
}

