/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui.resource;

import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.ui.resource.ResourceSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.resource.ResourceSelectorScreen;
import dev.ftb.mods.ftblibrary.config.ui.resource.SearchModeIndex;
import dev.ftb.mods.ftblibrary.config.ui.resource.SelectableResource;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import dev.ftb.mods.ftblibrary.util.SearchTerms;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SelectItemStackScreen
extends ResourceSelectorScreen<ItemStack> {
    public static final SearchModeIndex<ResourceSearchMode<ItemStack>> KNOWN_MODES = (SearchModeIndex)Util.make(new SearchModeIndex(), index -> {
        index.appendMode(ResourceSearchMode.ALL_ITEMS);
        index.appendMode(ResourceSearchMode.INVENTORY);
    });

    public SelectItemStackScreen(ItemStackConfig config, ConfigCallback callback) {
        super(config, callback);
    }

    @Override
    protected SearchModeIndex<ResourceSearchMode<ItemStack>> getSearchModeIndex() {
        return KNOWN_MODES;
    }

    @Override
    protected ResourceSelectorScreen.ResourceButton makeResourceButton(Panel panel, SelectableResource<ItemStack> resource) {
        return new ItemStackButton(this, panel, Objects.requireNonNullElse(resource, SelectableResource.item(ItemStack.EMPTY)));
    }

    private class ItemStackButton
    extends ResourceSelectorScreen.ResourceButton {
        private ItemStackButton(SelectItemStackScreen selectItemStackScreen, Panel panel, SelectableResource<ItemStack> resource) {
            super(panel, resource);
        }

        @Override
        public boolean shouldAdd(SearchTerms searchTerms) {
            return searchTerms.match(RegistrarManager.getId((Object)((ItemStack)this.getResource()).getItem(), (ResourceKey)Registries.ITEM), ((ItemStack)this.getResource()).getHoverName().getString(), id -> ((ItemStack)this.getResource()).is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id)));
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (!((ItemStack)this.getResource()).isEmpty()) {
                TooltipFlag.Default flag = Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
                ((ItemStack)this.getResource()).getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().level), (Player)Minecraft.getInstance().player, (TooltipFlag)flag).forEach(list::add);
                if (((Boolean)FTBLibraryClientConfig.ITEM_MODNAME.get()).booleanValue()) {
                    ModUtils.getModName(((ItemStack)this.getResource()).getItem()).ifPresent(name -> list.add((Component)Component.literal((String)name).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
                }
            }
        }
    }
}

