/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ToggleVisibilityButton
extends SimpleButton {
    private static final Component TOGGLE_ON = Component.translatable((String)"ftbchunks.gui.toggle_visibility_on");
    private static final Component TOGGLE_OFF = Component.translatable((String)"ftbchunks.gui.toggle_visibility_off");
    private boolean visible;

    private ToggleVisibilityButton(Panel panel, boolean defaultState, SimpleButton.Callback c) {
        super(panel, (Component)Component.empty(), defaultState ? Icons.ACCEPT : Icons.REMOVE_GRAY, c);
        this.visible = defaultState;
    }

    public static ToggleVisibilityButton create(Panel panel, boolean defaultState, Consumer<Boolean> newState) {
        return new ToggleVisibilityButton(panel, defaultState, (widget, button) -> {
            ToggleVisibilityButton visibilityButton = (ToggleVisibilityButton)widget;
            visibilityButton.visible = !visibilityButton.visible;
            widget.setIcon(visibilityButton.visible ? Icons.ACCEPT : Icons.REMOVE_GRAY);
            newState.accept(visibilityButton.visible);
        });
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Component getTitle() {
        return this.visible ? TOGGLE_ON : TOGGLE_OFF;
    }

    public void drawIcon(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        super.drawIcon(graphics, theme, x, y, this.width, this.height);
    }
}

