/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftbchunks.FTBCUtils;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColor;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColors;
import dev.ftb.mods.ftbchunks.client.map.color.CustomBlockColor;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.VineBlock;

public class ColorMapLoader
extends SimplePreparableReloadListener<JsonObject> {
    private static final Map<ResourceLocation, BlockColor> BLOCK_ID_TO_COLOR_MAP = new HashMap<ResourceLocation, BlockColor>();

    protected JsonObject prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        Gson gson = new GsonBuilder().setLenient().create();
        JsonObject object = new JsonObject();
        for (String namespace : resourceManager.getNamespaces()) {
            try {
                for (Resource resource : resourceManager.getResourceStack(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"ftbchunks_block_colors.json"))) {
                    try (InputStreamReader reader = new InputStreamReader(resource.open(), StandardCharsets.UTF_8);){
                        for (Map.Entry entry : ((JsonObject)gson.fromJson((Reader)reader, JsonObject.class)).entrySet()) {
                            if (((String)entry.getKey()).startsWith("#")) {
                                object.add("#" + namespace + ":" + ((String)entry.getKey()).substring(1), (JsonElement)entry.getValue());
                                continue;
                            }
                            object.add(namespace + ":" + (String)entry.getKey(), (JsonElement)entry.getValue());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        return object;
    }

    protected void apply(JsonObject object, ResourceManager resourceManager, ProfilerFiller profiler) {
        BLOCK_ID_TO_COLOR_MAP.clear();
        for (Map.Entry entry : FTBChunks.BLOCK_REGISTRY.entrySet()) {
            Block block = (Block)entry.getValue();
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            if (id == null) continue;
            if (block instanceof AirBlock || block instanceof BushBlock || block instanceof FireBlock || block instanceof ButtonBlock || block instanceof TorchBlock && !(block instanceof RedstoneTorchBlock)) {
                BLOCK_ID_TO_COLOR_MAP.put(id, BlockColors.IGNORED);
                continue;
            }
            if (block instanceof GrassBlock) {
                BLOCK_ID_TO_COLOR_MAP.put(id, BlockColors.GRASS);
                continue;
            }
            if (block instanceof LeavesBlock || block instanceof VineBlock) {
                BLOCK_ID_TO_COLOR_MAP.put(id, BlockColors.FOLIAGE);
                continue;
            }
            if (block instanceof FlowerPotBlock) {
                BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.rgb((int)6830637)));
                continue;
            }
            if (FTBCUtils.isRail(block)) {
                BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.rgb((int)0x888888)));
                continue;
            }
            if (block.defaultMapColor() != null) {
                BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.rgb((int)block.defaultMapColor().col)));
                continue;
            }
            BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.RED));
        }
        for (Map.Entry entry : object.entrySet()) {
            BlockColor col;
            if (!((JsonElement)entry.getValue()).isJsonPrimitive() || (col = BlockColors.getFromType(((JsonElement)entry.getValue()).getAsString())) == null) continue;
            BLOCK_ID_TO_COLOR_MAP.put(ResourceLocation.tryParse((String)((String)entry.getKey())), col);
        }
    }

    public static BlockColor getBlockColor(ResourceLocation id) {
        return BLOCK_ID_TO_COLOR_MAP.getOrDefault(id, BlockColors.IGNORED);
    }
}

