/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public enum FileType {
    INVALID,
    UNKNOWN,
    JSON,
    LITEMATICA_SCHEMATIC,
    SCHEMATICA_SCHEMATIC,
    SPONGE_SCHEMATIC,
    VANILLA_STRUCTURE;


    public static FileType fromName(String fileName) {
        if (fileName.endsWith(".litematic")) {
            return LITEMATICA_SCHEMATIC;
        }
        if (fileName.endsWith(".schematic")) {
            return SCHEMATICA_SCHEMATIC;
        }
        if (fileName.endsWith(".nbt")) {
            return VANILLA_STRUCTURE;
        }
        if (fileName.endsWith(".schem")) {
            return SPONGE_SCHEMATIC;
        }
        if (fileName.endsWith(".json")) {
            return JSON;
        }
        return UNKNOWN;
    }

    @Deprecated
    public static FileType fromFile(File file) {
        if (file.isFile() && file.canRead()) {
            return FileType.fromName(file.getName());
        }
        return INVALID;
    }

    public static FileType fromFile(Path file) {
        if (Files.exists(file, new LinkOption[0]) && Files.isReadable(file)) {
            return FileType.fromName(file.getFileName().toString());
        }
        return INVALID;
    }

    public static String getString(FileType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> "litematic";
            case 4 -> "schematic";
            case 5 -> "sponge";
            case 6 -> "vanilla_nbt";
            case 2 -> "JSON";
            case 0 -> "invalid";
            case 1 -> "unknown";
        };
    }
}

