/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.mojang.blaze3d.platform.InputConstants;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.mixin.input.IMixinKeyBinding;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.util.CompatUtils;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PickBlockUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.registry.Registry;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.game.PlacementUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class EasyPlaceUtils {
    private static final List<PositionCache> EASY_PLACE_POSITIONS = new ArrayList<PositionCache>();
    private static final HashMap<Block, Boolean> HAS_USE_ACTION_CACHE = new HashMap();
    private static boolean isHandling;
    private static boolean isFirstClickEasyPlace;
    private static boolean isFirstClickPlacementRestriction;

    public static boolean isHandling() {
        return isHandling;
    }

    public static void setHandling(boolean handling) {
        isHandling = handling;
    }

    public static void setIsFirstClick() {
        if (EasyPlaceUtils.shouldDoEasyPlaceActions()) {
            isFirstClickEasyPlace = true;
        }
        if (Configs.Generic.PLACEMENT_RESTRICTION.getBooleanValue()) {
            isFirstClickPlacementRestriction = true;
        }
    }

    private static boolean hasUseAction(Block block) {
        Boolean val = HAS_USE_ACTION_CACHE.get(block);
        if (val == null) {
            try {
                String name = Block.class.getSimpleName().equals("Block") ? "onUse" : "a";
                Method method = block.getClass().getMethod(name, BlockState.class, Level.class, BlockPos.class, Player.class, BlockHitResult.class);
                Method baseMethod = Block.class.getMethod(name, BlockState.class, Level.class, BlockPos.class, Player.class, BlockHitResult.class);
                val = !method.equals(baseMethod);
            }
            catch (Exception e) {
                Litematica.LOGGER.warn("EasyPlaceUtils: Failed to reflect method Block::onUse", (Throwable)e);
                val = false;
            }
            HAS_USE_ACTION_CACHE.put(block, val);
        }
        return val;
    }

    public static boolean shouldDoEasyPlaceActions() {
        return false;
    }

    public static void easyPlaceOnUseTick() {
        InputConstants.Key useKey = ((IMixinKeyBinding)Minecraft.getInstance().options.keyUse).litematica_getBoundKey();
        if (!isHandling && Configs.Generic.EASY_PLACE_HOLD_ENABLED.getBooleanValue() && EasyPlaceUtils.shouldDoEasyPlaceActions() && CompatUtils.isKeyHeld(useKey)) {
            GuiBase.isAltDown();
            isHandling = true;
            EasyPlaceUtils.handleEasyPlace();
            isHandling = false;
        }
    }

    public static boolean handleEasyPlaceWithMessage() {
        if (isHandling) {
            return false;
        }
        isHandling = true;
        InteractionResult result = EasyPlaceUtils.handleEasyPlace();
        isHandling = false;
        if (isFirstClickEasyPlace && result == InteractionResult.FAIL) {
            InfoUtils.printActionbarMessage((String)"litematica.message.easy_place_fail", (Object[])new Object[0]);
        }
        isFirstClickEasyPlace = false;
        return result != InteractionResult.PASS;
    }

    public static void onRightClickTail() {
        if (isFirstClickEasyPlace) {
            EasyPlaceUtils.handleEasyPlaceWithMessage();
        }
    }

    @Nullable
    private static BlockHitResult getTargetPosition(@Nullable RayTraceUtils.RayTraceWrapper traceWrapper) {
        Minecraft mc = Minecraft.getInstance();
        BlockPos overriddenPos = Registry.BLOCK_PLACEMENT_POSITION_HANDLER.getCurrentPlacementPosition();
        if (overriddenPos != null) {
            Direction side;
            Vec3 hitPos;
            if (mc.player == null) {
                return null;
            }
            double reach = mc.player.blockInteractionRange();
            Entity entity = mc.getCameraEntity();
            BlockHitResult trace = RayTraceUtils.traceToPositions(Collections.singletonList(overriddenPos), entity, reach);
            BlockPos pos = overriddenPos;
            if (trace != null && trace.getType() == HitResult.Type.BLOCK) {
                hitPos = trace.getLocation();
                side = trace.getDirection();
            } else {
                hitPos = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                side = Direction.UP;
            }
            return new BlockHitResult(hitPos, side, pos, false);
        }
        if (traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            return traceWrapper.getBlockHitResult();
        }
        return null;
    }

    @Nullable
    private static BlockHitResult getAdjacentClickPosition(BlockPos targetPos) {
        BlockHitResult blockHitResult;
        BlockPos posVanilla;
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        if (mc.player == null) {
            return null;
        }
        double reach = mc.player.blockInteractionRange();
        Entity entity = mc.getCameraEntity();
        if (entity == null || world == null) {
            return null;
        }
        HitResult traceVanilla = fi.dy.masa.malilib.util.game.RayTraceUtils.getRayTraceFromEntity((Level)world, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (boolean)false, (double)reach);
        if (traceVanilla.getType() == HitResult.Type.BLOCK && !PlacementUtils.isReplaceable((Level)world, (BlockPos)(posVanilla = (blockHitResult = (BlockHitResult)traceVanilla).getBlockPos()), (boolean)false) && targetPos.equals((Object)posVanilla.relative(blockHitResult.getDirection()))) {
            return new BlockHitResult(blockHitResult.getLocation(), ((BlockHitResult)traceVanilla).getDirection(), posVanilla, false);
        }
        for (Direction side : Direction.values()) {
            BlockPos posSide = targetPos.relative(side);
            if (PlacementUtils.isReplaceable((Level)world, (BlockPos)posSide, (boolean)false)) continue;
            Vec3 hitPos = EasyPlaceUtils.getHitPositionForSidePosition(posSide, side);
            return new BlockHitResult(hitPos, side.getOpposite(), posSide, false);
        }
        return null;
    }

    private static Vec3 getHitPositionForSidePosition(BlockPos posSide, Direction sideFromTarget) {
        Direction.Axis axis = sideFromTarget.getAxis();
        double x = (double)posSide.getX() + 0.5 - (double)sideFromTarget.getStepX() * 0.5;
        double y = (double)posSide.getY() + (axis == Direction.Axis.Y ? (sideFromTarget == Direction.DOWN ? 1.0 : 0.0) : 0.0);
        double z = (double)posSide.getZ() + 0.5 - (double)sideFromTarget.getStepZ() * 0.5;
        return new Vec3(x, y, z);
    }

    @Nullable
    private static BlockHitResult getClickPosition(BlockHitResult targetPosition, BlockState stateSchematic, BlockState stateClient) {
        boolean isSlab = stateSchematic.getBlock() instanceof SlabBlock;
        if (isSlab) {
            return EasyPlaceUtils.getClickPositionForSlab(targetPosition, stateSchematic, stateClient);
        }
        BlockPos targetBlockPos = targetPosition.getBlockPos();
        boolean requireAdjacent = false;
        return requireAdjacent ? EasyPlaceUtils.getAdjacentClickPosition(targetBlockPos) : targetPosition;
    }

    @Nullable
    private static BlockHitResult getClickPositionForSlab(BlockHitResult targetPosition, BlockState stateSchematic, BlockState stateClient) {
        Minecraft mc = Minecraft.getInstance();
        SlabBlock slab = (SlabBlock)stateSchematic.getBlock();
        BlockPos targetBlockPos = targetPosition.getBlockPos();
        ClientLevel worldClient = mc.level;
        boolean isDouble = ((SlabType)stateSchematic.getValue((Property)SlabBlock.TYPE)).equals((Object)SlabType.DOUBLE);
        if (isDouble) {
            if (EasyPlaceUtils.clientBlockIsSameMaterialSingleSlab(stateSchematic, stateClient)) {
                boolean isTop = stateClient.getValue((Property)SlabBlock.TYPE) == SlabType.TOP;
                Direction side = isTop ? Direction.DOWN : Direction.UP;
                Vec3 hitPos = targetPosition.getLocation();
                return new BlockHitResult(new Vec3(hitPos.x, (double)targetBlockPos.getY() + 0.5, hitPos.z), side, targetBlockPos, false);
            }
            if (PlacementUtils.isReplaceable((Level)worldClient, (BlockPos)targetBlockPos, (boolean)true)) {
                BlockHitResult pos = EasyPlaceUtils.getClickPositionForSlabHalf(targetPosition, stateSchematic, false, (Level)worldClient);
                return pos != null ? pos : EasyPlaceUtils.getClickPositionForSlabHalf(targetPosition, stateSchematic, true, (Level)worldClient);
            }
        } else if (!isDouble && PlacementUtils.isReplaceable((Level)worldClient, (BlockPos)targetBlockPos, (boolean)true)) {
            boolean isTop = stateSchematic.getValue((Property)SlabBlock.TYPE) == SlabType.TOP;
            return EasyPlaceUtils.getClickPositionForSlabHalf(targetPosition, stateSchematic, isTop, (Level)worldClient);
        }
        return null;
    }

    @Nullable
    private static BlockHitResult getClickPositionForSlabHalf(BlockHitResult targetPosition, BlockState stateSchematic, boolean isTop, Level worldClient) {
        BlockPos targetBlockPos = targetPosition.getBlockPos();
        boolean requireAdjacent = false;
        if (!requireAdjacent) {
            Direction clickSide = isTop ? Direction.DOWN : Direction.UP;
            boolean isReplaceable = PlacementUtils.isReplaceable((Level)worldClient, (BlockPos)targetBlockPos, (boolean)false);
            if (isReplaceable) {
                BlockPos posOffset = targetBlockPos.relative(clickSide);
                BlockState stateSide = worldClient.getBlockState(posOffset);
                if (!EasyPlaceUtils.clientBlockIsSameMaterialSingleSlab(stateSchematic, stateSide)) {
                    Vec3 hitPos = targetPosition.getLocation();
                    return new BlockHitResult(new Vec3(hitPos.x, (double)targetBlockPos.getY() + 0.5, hitPos.z), clickSide, targetBlockPos, false);
                }
            } else if (worldClient.getBlockState(targetBlockPos).liquid() && EasyPlaceUtils.canClickOnAdjacentBlockToPlaceSingleSlabAt(targetBlockPos, stateSchematic, clickSide.getOpposite(), worldClient)) {
                BlockPos pos = targetBlockPos.relative(clickSide.getOpposite());
                Vec3 hitPos = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                return new BlockHitResult(hitPos, clickSide, pos, false);
            }
        }
        return EasyPlaceUtils.getAdjacentClickPositionForSlab(targetBlockPos, stateSchematic, isTop, worldClient);
    }

    @Nullable
    private static BlockHitResult getAdjacentClickPositionForSlab(BlockPos targetBlockPos, BlockState stateSchematic, boolean isTop, Level worldClient) {
        Direction clickSide = isTop ? Direction.DOWN : Direction.UP;
        Direction clickSideOpposite = clickSide.getOpposite();
        BlockPos posSide = targetBlockPos.relative(clickSideOpposite);
        if (EasyPlaceUtils.canClickOnAdjacentBlockToPlaceSingleSlabAt(targetBlockPos, stateSchematic, clickSideOpposite, worldClient)) {
            return new BlockHitResult(EasyPlaceUtils.getHitPositionForSidePosition(posSide, clickSideOpposite), clickSide, posSide, false);
        }
        for (Direction side : Direction.values()) {
            if (!EasyPlaceUtils.canClickOnAdjacentBlockToPlaceSingleSlabAt(targetBlockPos, stateSchematic, side, worldClient)) continue;
            posSide = targetBlockPos.relative(side);
            Vec3 hitPos = EasyPlaceUtils.getHitPositionForSidePosition(posSide, side);
            double y = isTop ? 0.9 : 0.1;
            return new BlockHitResult(new Vec3(hitPos.x, (double)posSide.getY() + y, hitPos.z), side.getOpposite(), posSide, false);
        }
        return null;
    }

    private static boolean canClickOnAdjacentBlockToPlaceSingleSlabAt(BlockPos targetBlockPos, BlockState targetState, Direction side, Level worldClient) {
        BlockPos posSide = targetBlockPos.relative(side);
        BlockState stateSide = worldClient.getBlockState(posSide);
        return !PlacementUtils.isReplaceable((Level)worldClient, (BlockPos)posSide, (boolean)false) && (side.getAxis() != Direction.Axis.Y || !EasyPlaceUtils.clientBlockIsSameMaterialSingleSlab(targetState, stateSide) || stateSide.getValue((Property)SlabBlock.TYPE) != targetState.getValue((Property)SlabBlock.TYPE));
    }

    private static InteractionResult handleEasyPlace() {
        boolean needsSneak;
        double reach;
        Minecraft mc;
        ClientLevel world = mc.level;
        mc = Minecraft.getInstance();
        Entity entity = mc.getCameraEntity();
        RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((Level)world, entity, reach = mc.player.blockInteractionRange(), true, true, true);
        BlockHitResult targetPosition = EasyPlaceUtils.getTargetPosition(traceWrapper);
        if (targetPosition == null) {
            if (traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA_BLOCK) {
                return EasyPlaceUtils.placementRestrictionInEffect() ? InteractionResult.FAIL : InteractionResult.PASS;
            }
            return InteractionResult.PASS;
        }
        BlockPos targetBlockPos = targetPosition.getBlockPos();
        WorldSchematic schematicWorld = SchematicWorldHandler.getSchematicWorld();
        BlockState stateSchematic = schematicWorld.getBlockState(targetBlockPos);
        BlockState stateClient = world.getBlockState(targetBlockPos);
        ItemStack requiredStack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
        if (stateSchematic == stateClient || requiredStack.isEmpty() || EasyPlaceUtils.easyPlaceIsPositionCached(targetBlockPos) || !EasyPlaceUtils.canPlaceBlock(targetBlockPos, (Level)world, stateSchematic, stateClient)) {
            return InteractionResult.FAIL;
        }
        BlockHitResult clickPosition = EasyPlaceUtils.getClickPosition(targetPosition, stateSchematic, stateClient);
        InteractionHand hand = PickBlockUtils.doPickBlockForStack(requiredStack);
        if (clickPosition == null || hand == null) {
            return InteractionResult.FAIL;
        }
        boolean isSlab = stateSchematic.getBlock() instanceof SlabBlock;
        boolean usingAdjacentClickPosition = !clickPosition.getBlockPos().equals((Object)targetBlockPos);
        BlockPos clickPos = clickPosition.getBlockPos();
        Vec3 hitPos = clickPosition.getLocation();
        Direction side = clickPosition.getDirection();
        if (!usingAdjacentClickPosition && !isSlab) {
            side = EasyPlaceUtils.applyPlacementFacing(stateSchematic, side, stateClient);
            if (!stateClient.canSurvive((LevelReader)world, targetBlockPos) && stateClient.liquid()) {
                clickPos = clickPos.relative(side, -1);
            }
        }
        if (!isSlab) {
            hitPos = EasyPlaceUtils.applyCarpetProtocolHitVec(clickPos, stateSchematic, hitPos);
        }
        boolean didFakeSneak = (needsSneak = EasyPlaceUtils.hasUseAction((stateClient = world.getBlockState(clickPos)).getBlock())) && EntityUtils.setFakedSneakingState(true);
        LocalPlayer player = mc.player;
        BlockHitResult hitResult = new BlockHitResult(hitPos, side, clickPos, false);
        if (mc.gameMode.useItemOn(mc.player, hand, hitResult) == InteractionResult.PASS) {
            EasyPlaceUtils.cacheEasyPlacePosition(targetBlockPos);
            if (Configs.Generic.EASY_PLACE_SWING_HAND.getBooleanValue()) {
                player.swing(hand);
            }
            mc.getEntityRenderDispatcher().getItemInHandRenderer().itemUsed(hand);
            if (isSlab && ((SlabType)stateSchematic.getValue((Property)SlabBlock.TYPE)).equals((Object)SlabType.DOUBLE) && (stateClient = world.getBlockState(targetBlockPos)).getBlock() instanceof SlabBlock && !((SlabType)stateClient.getValue((Property)SlabBlock.TYPE)).equals((Object)SlabType.DOUBLE)) {
                side = stateClient.getValue((Property)SlabBlock.TYPE) == SlabType.TOP ? Direction.DOWN : Direction.UP;
                hitPos = new Vec3((double)targetBlockPos.getX(), (double)targetBlockPos.getY() + 0.5, (double)targetBlockPos.getZ());
                hitResult = new BlockHitResult(hitPos, side, targetBlockPos, false);
                mc.gameMode.useItemOn(mc.player, hand, hitResult);
            }
        }
        if (didFakeSneak) {
            EntityUtils.setFakedSneakingState(false);
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean clientBlockIsSameMaterialSingleSlab(BlockState stateSchematic, BlockState stateClient) {
        Block blockSchematic = stateSchematic.getBlock();
        Block blockClient = stateClient.getBlock();
        if (blockSchematic instanceof SlabBlock && blockClient instanceof SlabBlock && !((SlabType)stateClient.getValue((Property)SlabBlock.TYPE)).equals((Object)SlabType.DOUBLE)) {
            SlabType propClient;
            SlabType propSchematic = (SlabType)stateSchematic.getValue((Property)SlabBlock.TYPE);
            return propSchematic == (propClient = (SlabType)stateClient.getValue((Property)SlabBlock.TYPE)) && stateSchematic.getValue((Property)SlabBlock.TYPE) == stateClient.getValue((Property)SlabBlock.TYPE);
        }
        return false;
    }

    private static boolean canPlaceBlock(BlockPos targetPos, Level worldClient, BlockState stateSchematic, BlockState stateClient) {
        boolean isSlab = stateSchematic.getBlock() instanceof SlabBlock;
        if (isSlab) {
            return PlacementUtils.isReplaceable((Level)worldClient, (BlockPos)targetPos, (boolean)true) || ((SlabType)stateSchematic.getValue((Property)SlabBlock.TYPE)).equals((Object)SlabType.DOUBLE) && EasyPlaceUtils.clientBlockIsSameMaterialSingleSlab(stateSchematic, stateClient);
        }
        return PlacementUtils.isReplaceable((Level)worldClient, (BlockPos)targetPos, (boolean)true);
    }

    private static Vec3 applyCarpetProtocolHitVec(BlockPos pos, BlockState state, Vec3 hitVecIn) {
        double x = hitVecIn.x;
        double y = hitVecIn.y;
        double z = hitVecIn.z;
        Block block = state.getBlock();
        Optional facingOptional = BlockUtils.getFirstPropertyFacingValue((BlockState)state);
        if (facingOptional.isPresent()) {
            x = ((Direction)facingOptional.get()).ordinal() + 2 + pos.getX();
        }
        if (block instanceof RepeaterBlock) {
            x += (double)(((Integer)state.getValue((Property)RepeaterBlock.DELAY) - 1) * 10);
        } else if (block instanceof TrapDoorBlock && state.getValue((Property)TrapDoorBlock.HALF) == Half.TOP) {
            x += 10.0;
        } else if (block instanceof ComparatorBlock && state.getValue((Property)ComparatorBlock.MODE) == ComparatorMode.SUBTRACT) {
            x += 10.0;
        } else if (block instanceof StairBlock && state.getValue((Property)StairBlock.HALF) == Half.TOP) {
            x += 10.0;
        }
        return new Vec3(x, y, z);
    }

    private static Direction applyPlacementFacing(BlockState stateSchematic, Direction side, BlockState stateClient) {
        Optional propOptional = BlockUtils.getFirstDirectionProperty((BlockState)stateSchematic);
        if (propOptional.isPresent()) {
            side = ((Direction)stateSchematic.getValue((Property)propOptional.get())).getOpposite();
        }
        return side;
    }

    public static boolean handlePlacementRestriction() {
        boolean cancel = EasyPlaceUtils.placementRestrictionInEffect();
        if (cancel && isFirstClickPlacementRestriction) {
            InfoUtils.printActionbarMessage((String)"litematica.message.placement_restriction_fail", (Object[])new Object[0]);
        }
        isFirstClickPlacementRestriction = false;
        return cancel;
    }

    private static boolean placementRestrictionInEffect() {
        Minecraft mc = Minecraft.getInstance();
        Entity entity = mc.getCameraEntity();
        ClientLevel world = mc.level;
        if (world == null || mc.player == null || entity == null) {
            return false;
        }
        double reach = mc.player.blockInteractionRange();
        HitResult trace = fi.dy.masa.malilib.util.game.RayTraceUtils.getRayTraceFromEntity((Level)world, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (boolean)false, (double)reach);
        if (trace.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)trace;
            BlockPos pos = blockHitResult.getBlockPos();
            BlockState stateClient = world.getBlockState(pos);
            if (!stateClient.canSurvive((LevelReader)world, pos)) {
                pos = pos.relative(blockHitResult.getDirection());
                stateClient = world.getBlockState(pos);
            }
            if (!EasyPlaceUtils.isPositionWithinRangeOfSchematicRegions(pos, 2)) {
                return false;
            }
            if (!stateClient.canSurvive((LevelReader)world, pos) && !stateClient.liquid()) {
                return true;
            }
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            LayerRange range = DataManager.getRenderLayerRange();
            if (worldSchematic.isEmptyBlock(pos) || !range.isPositionWithinRange(pos)) {
                return true;
            }
            BlockState stateSchematic = worldSchematic.getBlockState(pos);
            ItemStack stack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
            return stack.isEmpty() || EntityUtils.getUsedHandForItem((LivingEntity)mc.player, stack, true) == null;
        }
        return false;
    }

    private static boolean isPositionWithinRangeOfSchematicRegions(BlockPos pos, int range) {
        SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
        int minCX = pos.getX() - range >> 4;
        int minCY = pos.getY() - range >> 4;
        int minCZ = pos.getZ() - range >> 4;
        int maxCX = pos.getX() + range >> 4;
        int maxCY = pos.getY() + range >> 4;
        int maxCZ = pos.getZ() + range >> 4;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        for (int cy = minCY; cy <= maxCY; ++cy) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int cx = minCX; cx <= maxCX; ++cx) {
                    List<SchematicPlacementManager.PlacementPart> parts = manager.getPlacementPartsInChunk(cx, cz);
                    for (SchematicPlacementManager.PlacementPart part : parts) {
                        IntBoundingBox box = part.bb;
                        if (x < box.minX - range || x > box.maxX + range || y < box.minY - range || y > box.maxY + range || z < box.minZ - range || z > box.maxZ + range) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean easyPlaceIsPositionCached(BlockPos pos) {
        long currentTime = System.nanoTime();
        boolean cached = false;
        for (int i = 0; i < EASY_PLACE_POSITIONS.size(); ++i) {
            PositionCache val = EASY_PLACE_POSITIONS.get(i);
            boolean expired = val.hasExpired(currentTime);
            if (expired) {
                EASY_PLACE_POSITIONS.remove(i);
                --i;
                continue;
            }
            if (!val.getPos().equals((Object)pos)) continue;
            cached = true;
            if (EASY_PLACE_POSITIONS.size() < 16) break;
        }
        return cached;
    }

    private static void cacheEasyPlacePosition(BlockPos pos) {
        EASY_PLACE_POSITIONS.add(new PositionCache(pos, System.nanoTime(), 2000000000L));
    }

    public static class PositionCache {
        private final BlockPos pos;
        private final long time;
        private final long timeout;

        private PositionCache(BlockPos pos, long time, long timeout) {
            this.pos = pos;
            this.time = time;
            this.timeout = timeout;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public boolean hasExpired(long currentTime) {
            return currentTime - this.time > this.timeout;
        }
    }
}

